/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.tools.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.directory.scim.core.schema.SchemaRegistry;
import org.apache.directory.scim.spec.filter.AttributeComparisonExpression;
import org.apache.directory.scim.spec.filter.CompareOperator;
import org.apache.directory.scim.spec.filter.FilterExpression;
import org.apache.directory.scim.spec.filter.ValuePathExpression;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;
import org.apache.directory.scim.spec.patch.PatchOperation;
import org.apache.directory.scim.spec.patch.PatchOperationPath;
import org.apache.directory.scim.spec.resources.ScimExtension;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.schema.Schema;

public class PatchGenerator {
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private final SchemaRegistry schemaRegistry;

    public PatchGenerator(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public <T extends ScimResource> List<PatchOperation> diff(T left, T right) {
        try {
            return new ArrayList<PatchOperation>(this.createPatchOperations(left, right));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error creating the patch list", e);
        }
    }

    private <T extends ScimResource> Set<PatchOperation> createPatchOperations(T left, T right) {
        HashSet<PatchOperation> patchOperations = new HashSet<PatchOperation>();
        if (left.getClass() != right.getClass() || !left.getBaseUrn().equals(right.getBaseUrn())) {
            throw new IllegalArgumentException("Objects must be of the same type");
        }
        String baseUrn = left.getBaseUrn();
        Schema baseSchema = this.schemaRegistry.getSchema(baseUrn);
        baseSchema.getAttributes().forEach(attribute -> patchOperations.addAll(this.processAttribute(null, Collections.emptyList(), (Schema.Attribute)attribute, left, right)));
        HashSet schemas = new HashSet();
        schemas.addAll(left.getExtensions().keySet());
        schemas.addAll(right.getExtensions().keySet());
        schemas.forEach(urn -> {
            Schema extSchema = this.schemaRegistry.getSchema(urn);
            ScimExtension leftExt = (ScimExtension)left.getExtensions().get(urn);
            ScimExtension rightExt = (ScimExtension)right.getExtensions().get(urn);
            if (leftExt == null) {
                patchOperations.add(new PatchOperation().setPath(new PatchOperationPath(new ValuePathExpression(new AttributeReference(PatchGenerator.attributePath(extSchema, Collections.emptyList(), null))))).setOperation(PatchOperation.Type.ADD).setValue((Object)rightExt));
            } else if (rightExt == null) {
                patchOperations.add(new PatchOperation().setPath(new PatchOperationPath(new ValuePathExpression(new AttributeReference(PatchGenerator.attributePath(extSchema, Collections.emptyList(), null))))).setOperation(PatchOperation.Type.REMOVE));
            } else {
                extSchema.getAttributes().forEach(attribute -> patchOperations.addAll(this.processAttribute(extSchema, Collections.emptyList(), (Schema.Attribute)attribute, leftExt, rightExt)));
            }
        });
        return patchOperations;
    }

    private Set<PatchOperation> processAttribute(Schema prefixSchema, List<Schema.Attribute> parentAttributes, Schema.Attribute attribute, Object left, Object right) {
        Object rightTemp;
        HashSet<PatchOperation> patchOperations = new HashSet<PatchOperation>();
        Object leftTemp = left != null ? attribute.getAccessor().get(left) : null;
        Object object = rightTemp = right != null ? attribute.getAccessor().get(right) : null;
        if (attribute.getType() == Schema.Attribute.Type.COMPLEX) {
            if (attribute.isMultiValued()) {
                patchOperations.addAll(PatchGenerator.processMultiValuedComplexAttribute(prefixSchema, parentAttributes, attribute, leftTemp, rightTemp));
            } else if (leftTemp != null && rightTemp == null) {
                patchOperations.add(new PatchOperation().setOperation(PatchOperation.Type.REMOVE).setPath(new PatchOperationPath(PatchGenerator.attributeExpression(prefixSchema, parentAttributes, attribute))));
            } else {
                attribute.getAttributes().forEach(subAttribute -> {
                    ArrayList<Schema.Attribute> subAttributeParents = new ArrayList<Schema.Attribute>(parentAttributes);
                    subAttributeParents.add(attribute);
                    patchOperations.addAll(this.processAttribute(prefixSchema, (List<Schema.Attribute>)subAttributeParents, (Schema.Attribute)subAttribute, leftTemp, rightTemp));
                });
            }
        } else {
            patchOperations.addAll(PatchGenerator.processPrimitiveAttribute(prefixSchema, parentAttributes, attribute, leftTemp, rightTemp));
        }
        return patchOperations;
    }

    private static Set<PatchOperation> processPrimitiveAttribute(Schema prefixSchema, List<Schema.Attribute> parentAttributes, Schema.Attribute attribute, Object left, Object right) {
        HashSet<PatchOperation> patchOperations = new HashSet<PatchOperation>();
        if (PatchGenerator.isEmpty(left) && PatchGenerator.isNotEmpty(right)) {
            patchOperations.add(new PatchOperation().setOperation(PatchOperation.Type.ADD).setPath(new PatchOperationPath(PatchGenerator.attributeExpression(prefixSchema, parentAttributes, attribute))).setValue(right));
        } else if (PatchGenerator.isNotEmpty(left) && PatchGenerator.isEmpty(right)) {
            patchOperations.add(new PatchOperation().setOperation(PatchOperation.Type.REMOVE).setPath(new PatchOperationPath(PatchGenerator.attributeExpression(prefixSchema, parentAttributes, attribute))));
        } else if (PatchGenerator.isNotEquivalent(left, right)) {
            patchOperations.add(new PatchOperation().setOperation(PatchOperation.Type.REPLACE).setPath(new PatchOperationPath(PatchGenerator.attributeExpression(prefixSchema, parentAttributes, attribute))).setValue(right));
        }
        return patchOperations;
    }

    private static Set<PatchOperation> processMultiValuedComplexAttribute(Schema prefixSchema, List<Schema.Attribute> parentAttributes, Schema.Attribute attribute, Object left, Object right) {
        HashSet<PatchOperation> patchOperations = new HashSet<PatchOperation>();
        if (!PatchGenerator.isCollectionOrNull(left) || !PatchGenerator.isCollectionOrNull(right)) {
            throw new IllegalArgumentException("The values of attribute '" + PatchGenerator.attributePath(prefixSchema, parentAttributes, attribute) + "' must be a Collection.");
        }
        Collection leftList = (Collection)left;
        Collection rightList = (Collection)right;
        if (PatchGenerator.isNotEmpty(leftList)) {
            if (PatchGenerator.isNotEmpty(rightList)) {
                ArrayList removed = new ArrayList(leftList);
                removed.removeAll(rightList);
                removed.forEach(item -> patchOperations.add(new PatchOperation().setOperation(PatchOperation.Type.REMOVE).setPath(new PatchOperationPath(PatchGenerator.attributeExpression(prefixSchema, parentAttributes, attribute, item)))));
            } else {
                patchOperations.add(new PatchOperation().setOperation(PatchOperation.Type.REMOVE).setPath(new PatchOperationPath(PatchGenerator.attributeExpression(prefixSchema, parentAttributes, attribute))));
            }
        }
        if (PatchGenerator.isNotEmpty(rightList)) {
            ArrayList added = new ArrayList(rightList);
            if (PatchGenerator.isNotEmpty(leftList)) {
                added.removeAll(leftList);
            }
            added.forEach(item -> patchOperations.add(new PatchOperation().setOperation(PatchOperation.Type.ADD).setPath(new PatchOperationPath(PatchGenerator.attributeExpression(prefixSchema, parentAttributes, attribute))).setValue(item)));
        }
        return patchOperations;
    }

    private static String attributePath(Schema prefixSchema, List<Schema.Attribute> parentAttributes, Schema.Attribute attribute) {
        Object attributePath = Stream.concat(parentAttributes.stream(), PatchGenerator.singleStream(attribute)).map(Schema.Attribute::getName).collect(Collectors.joining("."));
        if (prefixSchema != null) {
            String urn = prefixSchema.getId();
            attributePath = ((String)attributePath).isEmpty() ? urn : urn + ":" + (String)attributePath;
        }
        return attributePath;
    }

    private static ValuePathExpression attributeExpression(Schema prefixSchema, List<Schema.Attribute> parentAttributes, Schema.Attribute attribute) {
        return new ValuePathExpression(new AttributeReference(PatchGenerator.attributePath(prefixSchema, parentAttributes, attribute)));
    }

    private static ValuePathExpression attributeExpression(Schema prefixSchema, List<Schema.Attribute> parentAttributes, Schema.Attribute attribute, Object value) {
        Object right;
        Schema.Attribute typeAttribute = attribute.getAttribute(TYPE);
        Schema.Attribute valueAttribute = attribute.getAttribute(VALUE);
        Optional<Schema.Attribute> refAttribute = attribute.getSubAttributes().stream().filter(attr -> attr.getType() == Schema.Attribute.Type.REFERENCE).findFirst();
        if (refAttribute.isPresent() && valueAttribute != null && (right = valueAttribute.getAccessor().get(value)) != null) {
            if (!(right instanceof String)) {
                throw new IllegalArgumentException("PatchGenerator does not support 'value' attributes that are not a String.");
            }
            AttributeReference attributeReference = new AttributeReference(PatchGenerator.attributePath(prefixSchema, parentAttributes, attribute));
            AttributeReference expressionAttributeRef = new AttributeReference(PatchGenerator.attributePath(prefixSchema, parentAttributes, valueAttribute));
            return new ValuePathExpression(attributeReference, (FilterExpression)new AttributeComparisonExpression(expressionAttributeRef, CompareOperator.EQ, right));
        }
        if (typeAttribute != null) {
            Object type = typeAttribute.getAccessor().get(value);
            if (type != null) {
                type = type.toString();
            }
            AttributeReference attributeReference = new AttributeReference(PatchGenerator.attributePath(prefixSchema, parentAttributes, attribute));
            AttributeReference expressionAttributeRef = new AttributeReference(PatchGenerator.attributePath(prefixSchema, parentAttributes, typeAttribute));
            return new ValuePathExpression(attributeReference, (FilterExpression)new AttributeComparisonExpression(expressionAttributeRef, CompareOperator.EQ, type));
        }
        AttributeReference attributeReference = new AttributeReference(PatchGenerator.attributePath(prefixSchema, parentAttributes, attribute));
        return new ValuePathExpression(attributeReference);
    }

    private static boolean isEmpty(Object obj) {
        return obj == null || obj instanceof Collection && ((Collection)obj).isEmpty();
    }

    private static boolean isNotEmpty(Object obj) {
        return !PatchGenerator.isEmpty(obj);
    }

    private static boolean isEquivalent(Object left, Object right) {
        return Objects.equals(left, right) || PatchGenerator.isEmpty(left) && PatchGenerator.isEmpty(right);
    }

    private static boolean isNotEquivalent(Object left, Object right) {
        return !PatchGenerator.isEquivalent(left, right);
    }

    private static boolean isCollectionOrNull(Object value) {
        return value == null || value instanceof Collection;
    }

    private static <T> Stream<T> singleStream(T item) {
        return item != null ? Stream.of(item) : Stream.of(new Object[0]);
    }
}

