/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.protocol;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.directory.scim.protocol.adapter.FilterWrapper;
import org.apache.directory.scim.protocol.data.PatchRequest;
import org.apache.directory.scim.protocol.data.SearchRequest;
import org.apache.directory.scim.protocol.exception.ScimException;
import org.apache.directory.scim.spec.exception.ResourceException;
import org.apache.directory.scim.spec.filter.SortOrder;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;
import org.apache.directory.scim.spec.filter.attribute.AttributeReferenceListWrapper;
import org.apache.directory.scim.spec.resources.ScimResource;

@Tag(name="SCIM")
@Hidden
public interface BaseResourceTypeResource<T> {
    @GET
    @Path(value="{id}")
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Find by id")
    @ApiResponses(value={@ApiResponse(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response getById(@Parameter(name="id", required=true) @PathParam(value="id") String id, @Parameter(name="attributes") @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @Parameter(name="excludedAttributes") @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @GET
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Find by a combination of query parameters")
    @ApiResponses(value={@ApiResponse(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response query(@Parameter(name="attributes") @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @Parameter(name="excludedAttributes") @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes, @Parameter(name="filter") @QueryParam(value="filter") FilterWrapper filterWrapper, @Parameter(name="sortBy") @QueryParam(value="sortBy") AttributeReference sortBy, @Parameter(name="sortOrder") @QueryParam(value="sortOrder") SortOrder sortOrder, @Parameter(name="startIndex") @QueryParam(value="startIndex") Integer startIndex, @Parameter(name="count") @QueryParam(value="count") Integer count) throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @POST
    @Consumes(value={"application/scim+json", "application/json"})
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Create")
    @ApiResponses(value={@ApiResponse(responseCode="201", content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="409", description="Conflict"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response create(@RequestBody(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}, required=true) T resource, @Parameter(name="attributes") @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @Parameter(name="excludedAttributes") @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @POST
    @Path(value="/.search")
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Search")
    @ApiResponses(value={@ApiResponse(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response find(@RequestBody(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=SearchRequest.class))}, required=true) SearchRequest request) throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/scim+json", "application/json"})
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Update")
    @ApiResponses(value={@ApiResponse(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response update(@RequestBody(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}, required=true) T resource, @PathParam(value="id") String id, @Parameter(name="attributes") @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @Parameter(name="excludedAttributes") @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @PATCH
    @Path(value="{id}")
    @Consumes(value={"application/scim+json", "application/json"})
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Patch a portion of the backing store")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response patch(@RequestBody(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=PatchRequest.class))}, required=true) PatchRequest patchRequest, @PathParam(value="id") String id, @Parameter(name="attributes") @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @Parameter(name="excludedAttributes") @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @DELETE
    @Path(value="{id}")
    @Operation(description="Delete from the backing store")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response delete(@Parameter(name="id", required=true) @PathParam(value="id") String id) throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }
}

