/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.directory.scim.protocol.ServiceProviderConfigResource;
import org.apache.directory.scim.protocol.data.ErrorResponse;
import org.apache.directory.scim.server.configuration.ServerConfiguration;
import org.apache.directory.scim.server.exception.EtagGenerationException;
import org.apache.directory.scim.server.rest.EtagGenerator;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.schema.Meta;
import org.apache.directory.scim.spec.schema.ServiceProviderConfiguration;

@ApplicationScoped
public class ServiceProviderConfigResourceImpl
implements ServiceProviderConfigResource {
    private final ServerConfiguration serverConfiguration;
    private final EtagGenerator etagGenerator;

    @Inject
    public ServiceProviderConfigResourceImpl(ServerConfiguration serverConfiguration, EtagGenerator etagGenerator) {
        this.serverConfiguration = serverConfiguration;
        this.etagGenerator = etagGenerator;
    }

    public ServiceProviderConfigResourceImpl() {
        this(null, null);
    }

    public Response getServiceProviderConfiguration(UriInfo uriInfo) {
        ServiceProviderConfiguration serviceProviderConfiguration = new ServiceProviderConfiguration();
        List<ServiceProviderConfiguration.AuthenticationSchema> authenticationSchemas = this.serverConfiguration.getAuthenticationSchemas();
        ServiceProviderConfiguration.BulkConfiguration bulk = this.serverConfiguration.getBulkConfiguration();
        ServiceProviderConfiguration.SupportedConfiguration changePassword = this.serverConfiguration.getChangePasswordConfiguration();
        ServiceProviderConfiguration.SupportedConfiguration etagConfig = this.serverConfiguration.getEtagConfiguration();
        ServiceProviderConfiguration.FilterConfiguration filter = this.serverConfiguration.getFilterConfiguration();
        ServiceProviderConfiguration.SupportedConfiguration patch = this.serverConfiguration.getPatchConfiguration();
        ServiceProviderConfiguration.SupportedConfiguration sort = this.serverConfiguration.getSortConfiguration();
        String documentationUrl = this.serverConfiguration.getDocumentationUri();
        String externalId = this.serverConfiguration.getId();
        String id = this.serverConfiguration.getId();
        Meta meta = new Meta();
        String location = uriInfo.getAbsolutePath().toString();
        String resourceType = "ServiceProviderConfig";
        LocalDateTime now = LocalDateTime.now();
        meta.setCreated(now);
        meta.setLastModified(now);
        meta.setLocation(location);
        meta.setResourceType(resourceType);
        serviceProviderConfiguration.setAuthenticationSchemes(authenticationSchemas);
        serviceProviderConfiguration.setBulk(bulk);
        serviceProviderConfiguration.setChangePassword(changePassword);
        serviceProviderConfiguration.setDocumentationUrl(documentationUrl);
        serviceProviderConfiguration.setEtag(etagConfig);
        serviceProviderConfiguration.setExternalId(externalId);
        serviceProviderConfiguration.setFilter(filter);
        serviceProviderConfiguration.setId(id);
        serviceProviderConfiguration.setMeta(meta);
        serviceProviderConfiguration.setPatch(patch);
        serviceProviderConfiguration.setSort(sort);
        try {
            EntityTag etag = this.etagGenerator.generateEtag((ScimResource)serviceProviderConfiguration);
            return Response.ok((Object)serviceProviderConfiguration).tag(etag).build();
        }
        catch (EtagGenerationException e) {
            return this.createETagErrorResponse();
        }
    }

    private Response createETagErrorResponse() {
        ErrorResponse er = new ErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Failed to generate the etag");
        return er.toResponse();
    }
}

