/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.rest;

import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.directory.scim.core.repository.Repository;
import org.apache.directory.scim.core.repository.RepositoryRegistry;
import org.apache.directory.scim.core.repository.annotations.ScimProcessingExtension;
import org.apache.directory.scim.core.repository.extensions.AttributeFilterExtension;
import org.apache.directory.scim.core.repository.extensions.ClientFilterException;
import org.apache.directory.scim.core.repository.extensions.ProcessingExtension;
import org.apache.directory.scim.core.schema.SchemaRegistry;
import org.apache.directory.scim.protocol.BaseResourceTypeResource;
import org.apache.directory.scim.protocol.adapter.FilterWrapper;
import org.apache.directory.scim.protocol.data.ListResponse;
import org.apache.directory.scim.protocol.data.PatchRequest;
import org.apache.directory.scim.protocol.data.SearchRequest;
import org.apache.directory.scim.protocol.exception.ScimException;
import org.apache.directory.scim.server.exception.AttributeException;
import org.apache.directory.scim.server.exception.UnableToRetrieveResourceException;
import org.apache.directory.scim.server.rest.AttributeUtil;
import org.apache.directory.scim.spec.exception.ResourceException;
import org.apache.directory.scim.spec.filter.Filter;
import org.apache.directory.scim.spec.filter.FilterResponse;
import org.apache.directory.scim.spec.filter.PageRequest;
import org.apache.directory.scim.spec.filter.SortOrder;
import org.apache.directory.scim.spec.filter.SortRequest;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;
import org.apache.directory.scim.spec.filter.attribute.AttributeReferenceListWrapper;
import org.apache.directory.scim.spec.filter.attribute.ScimRequestContext;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.schema.Meta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceTypeResourceImpl<T extends ScimResource>
implements BaseResourceTypeResource<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseResourceTypeResourceImpl.class);
    private static final Logger LOG = LoggerFactory.getLogger(BaseResourceTypeResourceImpl.class);
    private final RepositoryRegistry repositoryRegistry;
    private final AttributeUtil attributeUtil;
    private final Class<T> resourceClass;
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    @Context
    HttpHeaders headers;

    public BaseResourceTypeResourceImpl(SchemaRegistry schemaRegistry, RepositoryRegistry repositoryRegistry, Class<T> resourceClass) {
        this.repositoryRegistry = repositoryRegistry;
        this.resourceClass = resourceClass;
        this.attributeUtil = new AttributeUtil(schemaRegistry);
    }

    public Repository<T> getRepository() {
        return this.repositoryRegistry.getRepository(this.resourceClass);
    }

    Repository<T> getRepositoryInternal() throws ScimException {
        Repository<T> repository = this.getRepository();
        if (repository == null) {
            throw new ScimException(Response.Status.NOT_IMPLEMENTED, "Provider not defined");
        }
        return repository;
    }

    public Response getById(String id, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        Response.ResponseBuilder evaluatePreconditionsResponse;
        ScimResource resource;
        Repository<T> repository;
        block5: {
            if (this.uriInfo.getQueryParameters().getFirst((Object)"filter") != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            repository = this.getRepositoryInternal();
            resource = null;
            try {
                resource = repository.get(id);
            }
            catch (UnableToRetrieveResourceException e2) {
                Response.Status status = Response.Status.fromStatusCode((int)e2.getStatus());
                if (!status.getFamily().equals((Object)Response.Status.Family.SERVER_ERROR)) break block5;
                throw e2;
            }
        }
        if (resource == null) {
            throw this.notFoundException(id);
        }
        EntityTag etag = this.fromVersion(resource);
        if (etag != null && (evaluatePreconditionsResponse = this.request.evaluatePreconditions(etag)) != null) {
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        }
        Set attributeReferences = AttributeReferenceListWrapper.getAttributeReferences((AttributeReferenceListWrapper)attributes);
        Set excludedAttributeReferences = AttributeReferenceListWrapper.getAttributeReferences((AttributeReferenceListWrapper)excludedAttributes);
        this.validateAttributes(attributeReferences, excludedAttributeReferences);
        resource = this.processFilterAttributeExtensions(repository, resource, attributeReferences, excludedAttributeReferences);
        resource = this.attributesForDisplayThrowOnError(resource, attributeReferences, excludedAttributeReferences);
        return Response.ok().entity((Object)resource).location(this.buildLocationTag(resource)).tag(etag).build();
    }

    public Response query(AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes, FilterWrapper filter, AttributeReference sortBy, SortOrder sortOrder, Integer startIndex, Integer count) throws ScimException, ResourceException {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setAttributes(AttributeReferenceListWrapper.getAttributeReferences((AttributeReferenceListWrapper)attributes));
        searchRequest.setExcludedAttributes(AttributeReferenceListWrapper.getAttributeReferences((AttributeReferenceListWrapper)excludedAttributes));
        if (filter != null) {
            searchRequest.setFilter(filter.getFilter());
        } else {
            searchRequest.setFilter(null);
        }
        searchRequest.setSortBy(sortBy);
        searchRequest.setSortOrder(sortOrder);
        searchRequest.setStartIndex(startIndex);
        searchRequest.setCount(count);
        return this.find(searchRequest);
    }

    public Response create(T resource, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        Repository<T> repository = this.getRepositoryInternal();
        Set attributeReferences = AttributeReferenceListWrapper.getAttributeReferences((AttributeReferenceListWrapper)attributes);
        Set excludedAttributeReferences = AttributeReferenceListWrapper.getAttributeReferences((AttributeReferenceListWrapper)excludedAttributes);
        this.validateAttributes(attributeReferences, excludedAttributeReferences);
        ScimResource created = repository.create(resource);
        EntityTag etag = this.fromVersion(created);
        created = this.processFilterAttributeExtensions(repository, created, attributeReferences, excludedAttributeReferences);
        try {
            created = this.attributesForDisplay(created, attributeReferences, excludedAttributeReferences);
        }
        catch (AttributeException e) {
            log.debug("Exception thrown while processing attributes", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.CREATED).location(this.buildLocationTag(created)).tag(etag).entity((Object)created).build();
    }

    public Response find(SearchRequest request) throws ScimException, ResourceException {
        Repository<T> repository = this.getRepositoryInternal();
        Set<AttributeReference> attributeReferences = Optional.ofNullable(request.getAttributes()).orElse(Collections.emptySet());
        Set<AttributeReference> excludedAttributeReferences = Optional.ofNullable(request.getExcludedAttributes()).orElse(Collections.emptySet());
        this.validateAttributes(attributeReferences, excludedAttributeReferences);
        Filter filter = request.getFilter();
        PageRequest pageRequest = request.getPageRequest();
        SortRequest sortRequest = request.getSortRequest();
        ListResponse listResponse = new ListResponse();
        FilterResponse filterResp = repository.find(filter, pageRequest, sortRequest);
        if (filterResp == null || filterResp.getResources() == null || filterResp.getResources().isEmpty()) {
            listResponse.setTotalResults(0);
        } else {
            log.debug("Find returned " + filterResp.getResources().size());
            listResponse.setItemsPerPage(Integer.valueOf(filterResp.getResources().size()));
            int startIndex = Optional.ofNullable(filterResp.getPageRequest().getStartIndex()).orElse(1);
            listResponse.setStartIndex(Integer.valueOf(startIndex));
            listResponse.setTotalResults(filterResp.getTotalResults());
            ArrayList<ScimResource> results = new ArrayList<ScimResource>();
            for (ScimResource resource : filterResp.getResources()) {
                resource = this.processFilterAttributeExtensions(repository, resource, attributeReferences, excludedAttributeReferences);
                resource = this.attributesForDisplayThrowOnError(resource, attributeReferences, excludedAttributeReferences);
                results.add(resource);
            }
            listResponse.setResources(results);
        }
        return Response.ok().entity((Object)listResponse).build();
    }

    public Response update(T resource, String id, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        return this.update(attributes, excludedAttributes, (etag, includeAttributes, excludeAttributes, repository) -> repository.update(id, etag, resource, includeAttributes, excludeAttributes));
    }

    public Response patch(PatchRequest patchRequest, String id, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        return this.update(attributes, excludedAttributes, (etag, includeAttributes, excludeAttributes, repository) -> repository.patch(id, etag, patchRequest.getPatchOperationList(), includeAttributes, excludeAttributes));
    }

    public Response delete(String id) throws ScimException, ResourceException {
        Repository<T> repository = this.getRepositoryInternal();
        repository.delete(id);
        return Response.noContent().build();
    }

    private Response update(AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes, UpdateFunction<T> updateFunction) throws ScimException, ResourceException {
        Repository<T> repository = this.getRepositoryInternal();
        Set attributeReferences = AttributeReferenceListWrapper.getAttributeReferences((AttributeReferenceListWrapper)attributes);
        Set excludedAttributeReferences = AttributeReferenceListWrapper.getAttributeReferences((AttributeReferenceListWrapper)excludedAttributes);
        this.validateAttributes(attributeReferences, excludedAttributeReferences);
        String requestEtag = this.headers.getHeaderString("ETag");
        T updated = updateFunction.update(requestEtag, attributeReferences, excludedAttributeReferences, repository);
        updated = this.processFilterAttributeExtensions(repository, updated, attributeReferences, excludedAttributeReferences);
        updated = this.attributesForDisplayIgnoreErrors(updated, attributeReferences, excludedAttributeReferences);
        EntityTag etag = this.fromVersion((ScimResource)updated);
        return Response.ok(updated).location(this.buildLocationTag(updated)).tag(etag).build();
    }

    private T processFilterAttributeExtensions(Repository<T> repository, T resource, Set<AttributeReference> attributeReferences, Set<AttributeReference> excludedAttributeReferences) throws ScimException {
        ScimProcessingExtension annotation = repository.getClass().getAnnotation(ScimProcessingExtension.class);
        if (annotation != null) {
            Class[] value;
            for (Class class1 : value = annotation.value()) {
                ProcessingExtension processingExtension = (ProcessingExtension)CDI.current().select(class1, new Annotation[0]).get();
                if (!(processingExtension instanceof AttributeFilterExtension)) continue;
                AttributeFilterExtension attributeFilterExtension = (AttributeFilterExtension)processingExtension;
                ScimRequestContext scimRequestContext = new ScimRequestContext(attributeReferences, excludedAttributeReferences);
                try {
                    resource = attributeFilterExtension.filterAttributes(resource, scimRequestContext);
                    log.debug("Resource now - " + resource.toString());
                }
                catch (ClientFilterException e) {
                    throw new ScimException(Response.Status.fromStatusCode((int)e.getStatus()), e.getMessage(), (Throwable)e);
                }
            }
        }
        return resource;
    }

    private URI buildLocationTag(T resource) {
        String id = resource.getId();
        if (id == null) {
            LOG.warn("Repository must supply an id for a resource");
            id = "unknown";
        }
        return this.uriInfo.getAbsolutePathBuilder().path(id).build(new Object[0]);
    }

    private <T extends ScimResource> T attributesForDisplay(T resource, Set<AttributeReference> includedAttributes, Set<AttributeReference> excludedAttributes) throws AttributeException {
        resource = !excludedAttributes.isEmpty() ? this.attributeUtil.setExcludedAttributesForDisplay(resource, excludedAttributes) : this.attributeUtil.setAttributesForDisplay(resource, includedAttributes);
        return resource;
    }

    private T attributesForDisplayIgnoreErrors(T resource, Set<AttributeReference> includedAttributes, Set<AttributeReference> excludedAttributes) {
        try {
            return this.attributesForDisplay(resource, includedAttributes, excludedAttributes);
        }
        catch (AttributeException e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to handle attribute processing in update " + e.getMessage(), (Throwable)e);
            } else {
                log.warn("Failed to handle attribute processing in update " + e.getMessage());
            }
            return resource;
        }
    }

    private T attributesForDisplayThrowOnError(T resource, Set<AttributeReference> includedAttributes, Set<AttributeReference> excludedAttributes) throws ScimException {
        try {
            return this.attributesForDisplay(resource, includedAttributes, excludedAttributes);
        }
        catch (AttributeException e) {
            throw new ScimException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to parse the attribute query value " + e.getMessage(), (Throwable)e);
        }
    }

    private ScimException notFoundException(String id) {
        return new ScimException(Response.Status.NOT_FOUND, "Resource " + id + " not found");
    }

    private void validateAttributes(Set<AttributeReference> attributeReferences, Set<AttributeReference> excludedAttributeReferences) throws ScimException {
        if (!attributeReferences.isEmpty() && !excludedAttributeReferences.isEmpty()) {
            throw new ScimException(Response.Status.BAD_REQUEST, "Cannot include both attributes and excluded attributes in a single request");
        }
    }

    private EntityTag fromVersion(ScimResource resource) {
        String version;
        Meta meta = resource.getMeta();
        if (meta != null && (version = meta.getVersion()) != null) {
            return new EntityTag(version);
        }
        return null;
    }

    @FunctionalInterface
    private static interface UpdateFunction<T extends ScimResource> {
        public T update(String var1, Set<AttributeReference> var2, Set<AttributeReference> var3, Repository<T> var4) throws ResourceException;
    }
}

