/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.directory.scim.spec.schema.ServiceProviderConfiguration;

public class ServerConfiguration {
    static final int BULK_MAXIMUM_OPERATIONS = 100;
    static final int BULK_MAXIMUM_PAYLOAD_SIZE = 1024;
    static final int FILTER_MAXIMUM_RESULTS = 100;
    String id = "spc";
    boolean supportsChangePassword = false;
    boolean supportsBulk = true;
    int bulkMaxOperations = 100;
    int bulkMaxPayloadSize = 1024;
    boolean supportsETag = true;
    boolean supportsFilter = false;
    int filterMaxResults = 100;
    boolean supportsPatch = true;
    boolean supportsSort = false;
    String documentationUri;
    List<ServiceProviderConfiguration.AuthenticationSchema> authenticationSchemas = new ArrayList<ServiceProviderConfiguration.AuthenticationSchema>();

    public List<ServiceProviderConfiguration.AuthenticationSchema> getAuthenticationSchemas() {
        return Collections.unmodifiableList(this.authenticationSchemas);
    }

    public ServerConfiguration addAuthenticationSchema(ServiceProviderConfiguration.AuthenticationSchema authenticationSchema) {
        this.authenticationSchemas.add(authenticationSchema);
        return this;
    }

    public ServiceProviderConfiguration.SupportedConfiguration getChangePasswordConfiguration() {
        return this.createSupportedConfiguration(this.isSupportsChangePassword());
    }

    public ServiceProviderConfiguration.BulkConfiguration getBulkConfiguration() {
        ServiceProviderConfiguration.BulkConfiguration bulkConfiguration = new ServiceProviderConfiguration.BulkConfiguration();
        bulkConfiguration.setSupported(this.isSupportsBulk());
        bulkConfiguration.setMaxOperations(this.getBulkMaxOperations());
        bulkConfiguration.setMaxPayloadSize(this.getBulkMaxPayloadSize());
        return bulkConfiguration;
    }

    public ServiceProviderConfiguration.SupportedConfiguration getEtagConfiguration() {
        return this.createSupportedConfiguration(this.isSupportsETag());
    }

    public ServiceProviderConfiguration.FilterConfiguration getFilterConfiguration() {
        ServiceProviderConfiguration.FilterConfiguration filterConfiguration = new ServiceProviderConfiguration.FilterConfiguration();
        filterConfiguration.setSupported(this.isSupportsFilter());
        filterConfiguration.setMaxResults(this.getFilterMaxResults());
        return filterConfiguration;
    }

    public ServiceProviderConfiguration.SupportedConfiguration getPatchConfiguration() {
        return this.createSupportedConfiguration(this.isSupportsPatch());
    }

    public ServiceProviderConfiguration.SupportedConfiguration getSortConfiguration() {
        return this.createSupportedConfiguration(this.isSupportsSort());
    }

    private ServiceProviderConfiguration.SupportedConfiguration createSupportedConfiguration(boolean supported) {
        ServiceProviderConfiguration.SupportedConfiguration supportedConfiguration = new ServiceProviderConfiguration.SupportedConfiguration();
        supportedConfiguration.setSupported(supported);
        return supportedConfiguration;
    }

    @Generated
    public ServerConfiguration() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public boolean isSupportsChangePassword() {
        return this.supportsChangePassword;
    }

    @Generated
    public boolean isSupportsBulk() {
        return this.supportsBulk;
    }

    @Generated
    public int getBulkMaxOperations() {
        return this.bulkMaxOperations;
    }

    @Generated
    public int getBulkMaxPayloadSize() {
        return this.bulkMaxPayloadSize;
    }

    @Generated
    public boolean isSupportsETag() {
        return this.supportsETag;
    }

    @Generated
    public boolean isSupportsFilter() {
        return this.supportsFilter;
    }

    @Generated
    public int getFilterMaxResults() {
        return this.filterMaxResults;
    }

    @Generated
    public boolean isSupportsPatch() {
        return this.supportsPatch;
    }

    @Generated
    public boolean isSupportsSort() {
        return this.supportsSort;
    }

    @Generated
    public String getDocumentationUri() {
        return this.documentationUri;
    }

    @Generated
    public ServerConfiguration setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public ServerConfiguration setSupportsChangePassword(boolean supportsChangePassword) {
        this.supportsChangePassword = supportsChangePassword;
        return this;
    }

    @Generated
    public ServerConfiguration setBulkMaxOperations(int bulkMaxOperations) {
        this.bulkMaxOperations = bulkMaxOperations;
        return this;
    }

    @Generated
    public ServerConfiguration setBulkMaxPayloadSize(int bulkMaxPayloadSize) {
        this.bulkMaxPayloadSize = bulkMaxPayloadSize;
        return this;
    }

    @Generated
    public ServerConfiguration setSupportsFilter(boolean supportsFilter) {
        this.supportsFilter = supportsFilter;
        return this;
    }

    @Generated
    public ServerConfiguration setFilterMaxResults(int filterMaxResults) {
        this.filterMaxResults = filterMaxResults;
        return this;
    }

    @Generated
    public ServerConfiguration setSupportsSort(boolean supportsSort) {
        this.supportsSort = supportsSort;
        return this;
    }

    @Generated
    public ServerConfiguration setDocumentationUri(String documentationUri) {
        this.documentationUri = documentationUri;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerConfiguration)) {
            return false;
        }
        ServerConfiguration other = (ServerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSupportsChangePassword() != other.isSupportsChangePassword()) {
            return false;
        }
        if (this.isSupportsBulk() != other.isSupportsBulk()) {
            return false;
        }
        if (this.getBulkMaxOperations() != other.getBulkMaxOperations()) {
            return false;
        }
        if (this.getBulkMaxPayloadSize() != other.getBulkMaxPayloadSize()) {
            return false;
        }
        if (this.isSupportsETag() != other.isSupportsETag()) {
            return false;
        }
        if (this.isSupportsFilter() != other.isSupportsFilter()) {
            return false;
        }
        if (this.getFilterMaxResults() != other.getFilterMaxResults()) {
            return false;
        }
        if (this.isSupportsPatch() != other.isSupportsPatch()) {
            return false;
        }
        if (this.isSupportsSort() != other.isSupportsSort()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$documentationUri = this.getDocumentationUri();
        String other$documentationUri = other.getDocumentationUri();
        if (this$documentationUri == null ? other$documentationUri != null : !this$documentationUri.equals(other$documentationUri)) {
            return false;
        }
        List<ServiceProviderConfiguration.AuthenticationSchema> this$authenticationSchemas = this.getAuthenticationSchemas();
        List<ServiceProviderConfiguration.AuthenticationSchema> other$authenticationSchemas = other.getAuthenticationSchemas();
        return !(this$authenticationSchemas == null ? other$authenticationSchemas != null : !((Object)this$authenticationSchemas).equals(other$authenticationSchemas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServerConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSupportsChangePassword() ? 79 : 97);
        result = result * 59 + (this.isSupportsBulk() ? 79 : 97);
        result = result * 59 + this.getBulkMaxOperations();
        result = result * 59 + this.getBulkMaxPayloadSize();
        result = result * 59 + (this.isSupportsETag() ? 79 : 97);
        result = result * 59 + (this.isSupportsFilter() ? 79 : 97);
        result = result * 59 + this.getFilterMaxResults();
        result = result * 59 + (this.isSupportsPatch() ? 79 : 97);
        result = result * 59 + (this.isSupportsSort() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $documentationUri = this.getDocumentationUri();
        result = result * 59 + ($documentationUri == null ? 43 : $documentationUri.hashCode());
        List<ServiceProviderConfiguration.AuthenticationSchema> $authenticationSchemas = this.getAuthenticationSchemas();
        result = result * 59 + ($authenticationSchemas == null ? 43 : ((Object)$authenticationSchemas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServerConfiguration(id=" + this.getId() + ", supportsChangePassword=" + this.isSupportsChangePassword() + ", supportsBulk=" + this.isSupportsBulk() + ", bulkMaxOperations=" + this.getBulkMaxOperations() + ", bulkMaxPayloadSize=" + this.getBulkMaxPayloadSize() + ", supportsETag=" + this.isSupportsETag() + ", supportsFilter=" + this.isSupportsFilter() + ", filterMaxResults=" + this.getFilterMaxResults() + ", supportsPatch=" + this.isSupportsPatch() + ", supportsSort=" + this.isSupportsSort() + ", documentationUri=" + this.getDocumentationUri() + ", authenticationSchemas=" + this.getAuthenticationSchemas() + ")";
    }
}

