/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.client.rest;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import org.apache.directory.scim.client.rest.BaseScimClient;
import org.apache.directory.scim.client.rest.RestCall;
import org.apache.directory.scim.client.rest.RestException;
import org.apache.directory.scim.client.rest.ScimJacksonXmlBindJsonProvider;
import org.apache.directory.scim.protocol.SelfResource;
import org.apache.directory.scim.protocol.data.PatchRequest;
import org.apache.directory.scim.protocol.exception.ScimException;
import org.apache.directory.scim.spec.filter.attribute.AttributeReferenceListWrapper;
import org.apache.directory.scim.spec.resources.ScimUser;

public class ScimSelfClient
implements AutoCloseable {
    private Client client;
    private WebTarget target;
    private SelfResourceClient selfResourceClient;
    private RestCall invoke = Invocation::invoke;

    public ScimSelfClient(Client client, String baseUrl) {
        this.client = (Client)client.register(ScimJacksonXmlBindJsonProvider.class);
        this.target = this.client.target(baseUrl).path("Me");
        this.selfResourceClient = new SelfResourceClient();
    }

    public ScimSelfClient(Client client, String baseUrl, RestCall invoke) {
        this(client, baseUrl);
        this.invoke = invoke;
    }

    public ScimUser getSelf(AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
        Response response = this.selfResourceClient.getSelf(attributes, excludedAttributes);
        ScimUser self = BaseScimClient.handleResponse(response, ScimUser.class, arg_0 -> ((Response)response).readEntity(arg_0));
        return self;
    }

    public ScimUser getSelf() throws ScimException {
        ScimUser self = this.getSelf(null, null);
        return self;
    }

    public void updateSelf(ScimUser scimUser, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
        Response response = this.selfResourceClient.update(scimUser, attributes, excludedAttributes);
        BaseScimClient.handleResponse(response);
    }

    public void updateSelf(ScimUser scimUser) throws ScimException {
        this.updateSelf(scimUser, null, null);
    }

    public void patchSelf(PatchRequest patchRequest, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
        Response response = this.selfResourceClient.patch(patchRequest, attributes, excludedAttributes);
        BaseScimClient.handleResponse(response);
    }

    public void patchSelf(PatchRequest patchRequest) throws ScimException {
        this.patchSelf(patchRequest, null, null);
    }

    public void deleteSelf() throws ScimException {
        Response response = this.selfResourceClient.delete();
        BaseScimClient.handleResponse(response);
    }

    public RestCall getInvoke() {
        return this.invoke;
    }

    public void setInvoke(RestCall invoke) {
        this.invoke = invoke;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    private class SelfResourceClient
    implements SelfResource {
        private SelfResourceClient() {
        }

        public Response getSelf(AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
            Response response;
            Invocation request = ScimSelfClient.this.target.queryParam("attributes", new Object[]{attributes}).queryParam("excludedAttributes", new Object[]{excludedAttributes}).request(new String[]{"application/scim+json"}).buildGet();
            try {
                response = ScimSelfClient.this.invoke.apply(request);
            }
            catch (RestException restException) {
                throw BaseScimClient.toScimException(restException);
            }
            return response;
        }

        public Response update(ScimUser scimUser, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
            Response response;
            Invocation request = ScimSelfClient.this.target.queryParam("attributes", new Object[]{attributes}).queryParam("excludedAttributes", new Object[]{excludedAttributes}).request(new String[]{"application/scim+json"}).buildPut(Entity.entity((Object)scimUser, (String)"application/scim+json"));
            try {
                response = ScimSelfClient.this.invoke.apply(request);
            }
            catch (RestException restException) {
                throw BaseScimClient.toScimException(restException);
            }
            return response;
        }

        public Response patch(PatchRequest patchRequest, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
            Response response;
            Invocation request = ScimSelfClient.this.target.queryParam("attributes", new Object[]{attributes}).queryParam("excludedAttributes", new Object[]{excludedAttributes}).request(new String[]{"application/scim+json"}).build("PATCH", Entity.entity((Object)patchRequest, (String)"application/scim+json"));
            try {
                response = ScimSelfClient.this.invoke.apply(request);
            }
            catch (RestException restException) {
                throw BaseScimClient.toScimException(restException);
            }
            return response;
        }

        public Response delete() throws ScimException {
            Response response;
            Invocation request = ScimSelfClient.this.target.request(new String[]{"application/scim+json"}).buildDelete();
            try {
                response = ScimSelfClient.this.invoke.apply(request);
            }
            catch (RestException restException) {
                throw BaseScimClient.toScimException(restException);
            }
            return response;
        }
    }
}

