/**
 * JDBM LICENSE v1.00
 *
 * Redistribution and use of this software and associated documentation
 * ("Software"), with or without modification, are permitted provided
 * that the following conditions are met:
 *
 * 1. Redistributions of source code must retain copyright
 *    statements and notices.  Redistributions must also contain a
 *    copy of this document.
 *
 * 2. Redistributions in binary form must reproduce the
 *    above copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *
 * 3. The name "JDBM" must not be used to endorse or promote
 *    products derived from this Software without prior written
 *    permission of Cees de Groot.  For written permission,
 *    please contact cg@cdegroot.com.
 *
 * 4. Products derived from this Software may not be called "JDBM"
 *    nor may "JDBM" appear in their names without prior written
 *    permission of Cees de Groot. 
 *
 * 5. Due credit should be given to the JDBM Project
 *    (http://jdbm.sourceforge.net/).
 *
 * THIS SOFTWARE IS PROVIDED BY THE JDBM PROJECT AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CEES DE GROOT OR ANY CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright 2000 (C) Cees de Groot. All Rights Reserved.
 * Contributions are Copyright (C) 2000 by their associated contributors.
 *
 * $Id: Magic.java,v 1.1 2000/05/06 00:00:31 boisvert Exp $
 */
package jdbm.recman;


/**
 * This interface contains magic cookies.
 * Final reference -> class shouldn't be extended
 */
public final class Magic 
{
    /**
     *  Ensures no construction of this class, also ensures there is no need for final keyword above
     *  (Implicit super constructor is not visible for default constructor),
     *  but is still self documenting.
     */
    private Magic()
    {
    }

    
    /** Magic cookie at start of file */
    public final static short FILE_HEADER = 0x1350;

    /** Magic for blocks. They're offset by the block type magic codes. */
    public final static short BLOCK = 0x1351;

    /** Magics for block types in certain lists. Offset by baseBlockMagic */
    public final static short FREE_PAGE = 0;
    public final static short USED_PAGE = 1;
    public final static short TRANSLATION_PAGE = 2;
    public final static short FREELOGIDS_PAGE = 3;
    public final static short FREEPHYSIDS_PAGE = 4;

    /** Number of lists in a file */
    public final static short NLISTS = 5;

    /**
     *  Maximum number of blocks in a file, leaving room for a 16 bit
     *  offset encoded within a long.
     */
    public final static long MAX_BLOCKS = 0x7FFFFFFFFFFFL;

    /** Magic for transaction file */
    public final static short LOGFILE_HEADER = 0x1360;

    /** Size of an externalized byte */
    public final static short SZ_BYTE = 1;
    /** Size of an externalized short */
    public final static short SZ_SHORT = 2;
    /** Size of an externalized int */
    public final static short SZ_INT = 4;
    /** Size of an externalized long */
    public final static short SZ_LONG = 8;
}
