/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.CursorLdapReferralException;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapReferralException;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryCursorImpl
extends AbstractCursor<Entry>
implements EntryCursor {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private Response response;
    private SearchCursor searchCursor;
    private int messageId;

    public EntryCursorImpl(SearchCursor searchCursor) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating EntryCursorImpl {}", (Object)this);
        }
        this.searchCursor = searchCursor;
        this.messageId = -1;
    }

    public boolean next() throws LdapException, CursorException {
        if (!this.searchCursor.next()) {
            return false;
        }
        try {
            do {
                this.response = (Response)this.searchCursor.get();
                if (this.response == null) {
                    throw new LdapException("TimeOut occurred");
                }
                this.messageId = this.response.getMessageId();
                if (this.response instanceof SearchResultEntry) {
                    return true;
                }
                if (!(this.response instanceof SearchResultReference)) continue;
                return true;
            } while (!(this.response instanceof SearchResultDone));
            return false;
        }
        catch (Exception e) {
            LdapException ldapException = new LdapException("The response queue has been emptied, no response was found.");
            ldapException.initCause((Throwable)e);
            this.close((Exception)((Object)ldapException));
            throw ldapException;
        }
    }

    public Entry get() throws CursorException {
        if (!this.searchCursor.available()) {
            throw new InvalidCursorPositionException();
        }
        try {
            do {
                if (this.response instanceof SearchResultEntry) {
                    return ((SearchResultEntry)this.response).getEntry();
                }
                if (!(this.response instanceof SearchResultReference)) continue;
                throw new LdapReferralException(((SearchResultReference)this.response).getReferral().getLdapUrls());
            } while (this.next() && !(this.response instanceof SearchResultDone));
        }
        catch (LdapReferralException lre) {
            throw new CursorLdapReferralException(lre);
        }
        catch (Exception e) {
            throw new CursorException((Throwable)e);
        }
        return null;
    }

    public SearchResultDone getSearchResultDone() {
        return this.searchCursor.getSearchResultDone();
    }

    public boolean available() {
        return this.searchCursor.available();
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EntryCursorImpl {}", (Object)this);
        }
        this.searchCursor.close();
    }

    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EntryCursorImpl {}", (Object)this);
        }
        this.searchCursor.close(cause);
    }

    public void after(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("after( Response element )")}));
    }

    public void afterLast() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("afterLast()")}));
    }

    public void before(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("before( Response element )")}));
    }

    public void beforeFirst() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("beforeFirst()")}));
    }

    public boolean first() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("first()")}));
    }

    public boolean last() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("last()")}));
    }

    public boolean previous() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("previous()")}));
    }

    public int getMessageId() {
        return this.messageId;
    }
}

