/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.ChangeType;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.ldif.anonymizer.Anonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.BinaryAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.CaseSensitiveStringAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.IntegerAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.StringAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.TelephoneNumberAnonymizer;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.DnSyntaxChecker;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.NameAndOptionalUIDSyntaxChecker;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;

public class LdifAnonymizer {
    private Map<Value, Value> valueMap = new HashMap<Value, Value>();
    private Set<Value> valueSet = new HashSet<Value>();
    private Map<Integer, String> latestStringMap;
    private Map<Integer, byte[]> latestBytesMap;
    private Map<String, Anonymizer> attributeAnonymizers = new HashMap<String, Anonymizer>();
    private Set<Dn> namingContexts = new HashSet<Dn>();
    private SchemaManager schemaManager;
    private PrintStream out = null;

    public LdifAnonymizer() {
        try {
            this.schemaManager = new DefaultSchemaManager();
        }
        catch (Exception e) {
            this.println("Missing a SchemaManager !");
            System.exit(-1);
        }
        this.init(null, null, null, null);
    }

    public LdifAnonymizer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.init(null, null, null, null);
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    private void println(String str) {
        if (this.out != null) {
            this.out.println(str);
        }
    }

    private void println() {
        if (this.out != null) {
            this.out.println();
        }
    }

    private void init(Map<Integer, String> stringLatestValueMap, Map<Integer, byte[]> binaryLatestValueMap, Map<Integer, String> integerLatestValueMap, Map<Integer, String> telephoneNumberLatestValueMap) {
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.1", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.25", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.3", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.13", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.241", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.2", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.1", new IntegerAnonymizer(integerLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.42", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.3", new CaseSensitiveStringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.20", new TelephoneNumberAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.39", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.9", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.51", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.60", new BinaryAnonymizer(binaryLatestValueMap));
        this.attributeAnonymizers.put("1.3.6.1.4.1.250.1.57", new CaseSensitiveStringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.7", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.3", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.10", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.12", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.41", new TelephoneNumberAnonymizer());
        this.attributeAnonymizers.put("2.5.4.10", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.11", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.42", new TelephoneNumberAnonymizer());
        this.attributeAnonymizers.put("2.5.4.16", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.7", new BinaryAnonymizer(binaryLatestValueMap));
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.21", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.34", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.4", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.20", new TelephoneNumberAnonymizer(telephoneNumberLatestValueMap));
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.1", new StringAnonymizer(stringLatestValueMap));
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.0", new IntegerAnonymizer(integerLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.36", new BinaryAnonymizer(binaryLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.35", new BinaryAnonymizer(binaryLatestValueMap));
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.216", new BinaryAnonymizer(binaryLatestValueMap));
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.40", new BinaryAnonymizer(binaryLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.45", new BinaryAnonymizer(binaryLatestValueMap));
        this.attributeAnonymizers.put("2.5.4.23", new TelephoneNumberAnonymizer(telephoneNumberLatestValueMap));
    }

    public void setAttributeLatestValueMap(AttributeType attributeType, Map<Integer, ?> latestValueMap) {
        Anonymizer anonymizer = this.attributeAnonymizers.get(attributeType.getOid());
        if (anonymizer != null) {
            if (attributeType.getSyntax().isHumanReadable()) {
                anonymizer.setLatestStringMap(latestValueMap);
            } else {
                anonymizer.setLatestBytesMap(latestValueMap);
            }
        }
    }

    public void addAnonAttributeType(AttributeType attributeType) throws LdapException {
        this.schemaManager.add(attributeType);
        LdapSyntax syntax = attributeType.getSyntax();
        if (syntax.isHumanReadable()) {
            if (syntax.getOid().equals("1.3.6.1.4.1.1466.115.121.1.27")) {
                this.attributeAnonymizers.put(attributeType.getOid(), new IntegerAnonymizer());
            } else if (syntax.getOid().equals("1.3.6.1.4.1.1466.115.121.1.15")) {
                this.attributeAnonymizers.put(attributeType.getOid(), new StringAnonymizer());
            } else if (syntax.getOid().equals("1.3.6.1.4.1.1466.115.121.1.50")) {
                this.attributeAnonymizers.put(attributeType.getOid(), new TelephoneNumberAnonymizer());
            }
        } else {
            this.attributeAnonymizers.put(attributeType.getOid(), new BinaryAnonymizer());
        }
    }

    public void addAnonAttributeType(AttributeType attributeType, Anonymizer<?> anonymizer) throws LdapException {
        this.schemaManager.add(attributeType);
        this.attributeAnonymizers.put(attributeType.getOid(), anonymizer);
    }

    public void removeAnonAttributeType(AttributeType attributeType) {
        this.attributeAnonymizers.remove(attributeType.getOid());
    }

    public Map<String, Anonymizer> getAttributeAnonymizers() {
        return this.attributeAnonymizers;
    }

    public void addNamingContext(String dn) throws LdapInvalidDnException {
        Dn namingContext = new Dn(this.schemaManager, dn);
        this.namingContexts.add(namingContext);
    }

    private Ava anonymizeAva(Ava ava) throws LdapInvalidDnException, LdapInvalidAttributeValueException {
        Ava anonymizedAva;
        Value value = ava.getValue();
        AttributeType attributeType = ava.getAttributeType();
        Value anonymizedValue = this.valueMap.get(value);
        if (anonymizedValue == null) {
            DefaultAttribute attribute = new DefaultAttribute(attributeType);
            attribute.add(value);
            Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType().getOid());
            if (value.isHumanReadable()) {
                if (anonymizer == null) {
                    anonymizedAva = new Ava(this.schemaManager, ava.getType(), value.getValue());
                } else {
                    Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, this.valueSet, attribute);
                    anonymizedAva = new Ava(this.schemaManager, ava.getType(), anonymizedAttribute.getString());
                }
            } else if (anonymizer == null) {
                anonymizedAva = new Ava(this.schemaManager, ava.getType(), value.getBytes());
            } else {
                Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, this.valueSet, attribute);
                anonymizedAva = new Ava(this.schemaManager, ava.getType(), anonymizedAttribute.getBytes());
            }
        } else {
            anonymizedAva = value.isHumanReadable() ? new Ava(this.schemaManager, ava.getType(), anonymizedValue.getValue()) : new Ava(this.schemaManager, ava.getType(), anonymizedValue.getBytes());
        }
        return anonymizedAva;
    }

    private Dn anonymizeDn(Dn entryDn) throws LdapException {
        Dn descendant = entryDn;
        Dn namingContext = null;
        for (Dn nc : this.namingContexts) {
            if (!entryDn.isDescendantOf(nc)) continue;
            descendant = entryDn.getDescendantOf(nc);
            namingContext = nc;
            break;
        }
        Rdn[] anonymizedRdns = new Rdn[entryDn.size()];
        int rdnPos = entryDn.size() - 1;
        if (namingContext != null) {
            Iterator<Rdn> iterator = namingContext.iterator();
            while (iterator.hasNext()) {
                Rdn ncRdn;
                anonymizedRdns[rdnPos] = ncRdn = iterator.next();
                --rdnPos;
            }
        }
        for (Rdn rdn : descendant) {
            Rdn anonymizedRdn;
            Ava[] anonymizedAvas = new Ava[rdn.size()];
            int pos = 0;
            for (Ava ava : rdn) {
                Ava anonymizedAva;
                anonymizedAvas[pos] = anonymizedAva = this.anonymizeAva(ava);
                ++pos;
            }
            anonymizedRdns[rdnPos] = anonymizedRdn = new Rdn(this.schemaManager, anonymizedAvas);
            --rdnPos;
        }
        return new Dn(this.schemaManager, anonymizedRdns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void anonymizeFile(String ldifFile, Writer writer) throws LdapException, IOException {
        File inputFile = new File(ldifFile);
        if (!inputFile.exists()) {
            this.println("Cannot open file " + ldifFile);
            return;
        }
        LdifReader ldifReader = new LdifReader(inputFile, this.schemaManager);
        int count = 0;
        ArrayList<LdifEntry> errors = new ArrayList<LdifEntry>();
        ArrayList<String> errorTexts = new ArrayList<String>();
        try {
            for (LdifEntry ldifEntry : ldifReader) {
                ++count;
                try {
                    LdifEntry newLdifEntry;
                    if (ldifEntry.isEntry() && !ldifEntry.isChangeAdd()) {
                        Entry newEntry = this.anonymizeEntry(ldifEntry);
                        writer.write(LdifUtils.convertToLdif(newEntry));
                        writer.write("\n");
                    } else if (ldifEntry.isChangeDelete()) {
                        newLdifEntry = this.anonymizeChangeDelete(ldifEntry);
                        if (ldifEntry != null) {
                            writer.write(newLdifEntry.toString());
                            writer.write("\n");
                        }
                    } else if (ldifEntry.isChangeAdd()) {
                        newLdifEntry = this.anonymizeChangeAdd(ldifEntry);
                        if (ldifEntry != null) {
                            writer.write(newLdifEntry.toString());
                            writer.write("\n");
                        }
                    } else if (ldifEntry.isChangeModify()) {
                        newLdifEntry = this.anonymizeChangeModify(ldifEntry);
                        if (ldifEntry != null) {
                            writer.write(newLdifEntry.toString());
                            writer.write("\n");
                        }
                    } else if (ldifEntry.isChangeModDn() || ldifEntry.isChangeModRdn()) {
                        newLdifEntry = this.anonymizeChangeModDn(ldifEntry);
                        if (ldifEntry != null) {
                            writer.write(newLdifEntry.toString());
                            writer.write("\n");
                        }
                    }
                    System.out.print('.');
                    if (count % 100 != 0) continue;
                    this.println();
                }
                catch (Exception e) {
                    System.out.print('*');
                    if (count % 100 == 0) {
                        this.println();
                    }
                    errors.add(ldifEntry);
                    errorTexts.add(e.getMessage());
                }
            }
            this.println();
            if (!errors.isEmpty()) {
                this.println("There are " + errors.size() + " bad entries");
                int i = 0;
                for (LdifEntry ldifEntry : errors) {
                    this.println("---------------------------------------------------");
                    this.println("error : " + (String)errorTexts.get(i));
                    this.println(ldifEntry.getDn().toString());
                    ++i;
                }
            }
        }
        finally {
            this.println();
            if (!errors.isEmpty()) {
                this.println("There are " + errors.size() + " bad entries");
            }
            this.println("Nb entries : " + count);
            ldifReader.close();
        }
    }

    private LdifEntry anonymizeChangeModify(LdifEntry ldifEntry) throws LdapException {
        Dn entryDn = ldifEntry.getDn();
        LdifEntry newLdifEntry = new LdifEntry(this.schemaManager);
        newLdifEntry.setChangeType(ChangeType.Modify);
        Dn anonymizedDn = this.anonymizeDn(entryDn);
        newLdifEntry.setDn(anonymizedDn);
        for (Modification modification : ldifEntry.getModifications()) {
            DefaultModification anonymizedModification;
            Attribute attribute = modification.getAttribute();
            AttributeType attributeType = this.schemaManager.getAttributeType(attribute.getId());
            if (attributeType == null) {
                System.out.println("\nUnknown AttributeType : " + attribute.getId() + " for entry " + entryDn);
                return null;
            }
            attribute.apply(attributeType);
            if (attributeType.getSyntax().getSyntaxChecker() instanceof DnSyntaxChecker) {
                Value[] anonymizedValues = new Value[attribute.size()];
                int pos = 0;
                for (Value dnValue : modification.getAttribute()) {
                    Dn dn = new Dn(this.schemaManager, dnValue.getValue());
                    Dn newdDn = this.anonymizeDn(dn);
                    anonymizedValues[pos++] = new Value(newdDn.toString());
                }
                anonymizedModification = new DefaultModification(modification.getOperation(), attributeType, anonymizedValues);
                newLdifEntry.addModification(anonymizedModification);
                continue;
            }
            Anonymizer anonymizer = this.attributeAnonymizers.get(attributeType.getOid());
            if (anonymizer == null) {
                newLdifEntry.addModification(modification);
                continue;
            }
            Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, this.valueSet, attribute);
            anonymizedModification = new DefaultModification(modification.getOperation(), anonymizedAttribute);
            newLdifEntry.addModification(anonymizedModification);
        }
        return newLdifEntry;
    }

    private LdifEntry anonymizeChangeAdd(LdifEntry ldifEntry) throws LdapException {
        Dn entryDn = ldifEntry.getDn();
        LdifEntry newLdifEntry = new LdifEntry(this.schemaManager);
        newLdifEntry.setChangeType(ChangeType.Add);
        Dn anonymizedDn = this.anonymizeDn(entryDn);
        newLdifEntry.setDn(anonymizedDn);
        for (Attribute attribute : ldifEntry) {
            AttributeType attributeType = attribute.getAttributeType();
            Attribute anonymizedAttribute = new DefaultAttribute(attributeType);
            if (attributeType.getSyntax().getSyntaxChecker() instanceof DnSyntaxChecker) {
                for (Value dnValue : attribute) {
                    Dn dn = new Dn(this.schemaManager, dnValue.getValue());
                    Dn newdDn = this.anonymizeDn(dn);
                    anonymizedAttribute.add(newdDn.toString());
                }
                newLdifEntry.addAttribute(attribute);
                continue;
            }
            Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType().getOid());
            if (anonymizer == null) {
                newLdifEntry.addAttribute(attribute);
                continue;
            }
            anonymizedAttribute = anonymizer.anonymize(this.valueMap, this.valueSet, attribute);
            if (anonymizedAttribute == null) continue;
            newLdifEntry.addAttribute(anonymizedAttribute);
        }
        return newLdifEntry;
    }

    private LdifEntry anonymizeChangeDelete(LdifEntry ldifEntry) throws LdapException {
        Dn entryDn = ldifEntry.getDn();
        Dn anonymizedDn = this.anonymizeDn(entryDn);
        ldifEntry.setDn(anonymizedDn);
        return ldifEntry;
    }

    private LdifEntry anonymizeChangeModDn(LdifEntry ldifEntry) throws LdapException {
        String newSuperiorStr;
        Dn entryDn = ldifEntry.getDn();
        Dn anonymizedDn = this.anonymizeDn(entryDn);
        ldifEntry.setDn(anonymizedDn);
        String newRdnStr = ldifEntry.getNewRdn();
        if (newRdnStr != null) {
            Dn newRdn = new Dn(this.schemaManager, newRdnStr);
            Dn anonymizedRdn = this.anonymizeDn(newRdn);
            ldifEntry.setNewRdn(anonymizedRdn.toString());
        }
        if ((newSuperiorStr = ldifEntry.getNewSuperior()) != null) {
            Dn newSuperior = new Dn(this.schemaManager, newSuperiorStr);
            Dn anonymizedSuperior = this.anonymizeDn(newSuperior);
            ldifEntry.setNewSuperior(anonymizedSuperior.toString());
        }
        return ldifEntry;
    }

    private Entry anonymizeEntry(LdifEntry ldifEntry) throws LdapException {
        Entry entry = ldifEntry.getEntry();
        DefaultEntry newEntry = new DefaultEntry(this.schemaManager);
        Dn entryDn = entry.getDn();
        Dn anonymizedDn = this.anonymizeDn(entryDn);
        for (Attribute attribute : entry) {
            AttributeType attributeType = attribute.getAttributeType();
            if (attributeType.getSyntax().getSyntaxChecker() instanceof DnSyntaxChecker) {
                for (Value dnValue : attribute) {
                    Dn dn = new Dn(this.schemaManager, dnValue.getValue());
                    Dn newdDn = this.anonymizeDn(dn);
                    newEntry.add(attributeType, newdDn.toString());
                }
                continue;
            }
            if (attributeType.getSyntax().getSyntaxChecker() instanceof NameAndOptionalUIDSyntaxChecker) {
                for (Value dnValue : attribute) {
                    String valueStr = dnValue.getValue();
                    int uidPos = valueStr.indexOf(35);
                    String uid = null;
                    if (uidPos != -1) {
                        uid = valueStr.substring(uidPos + 1);
                        valueStr = valueStr.substring(0, uidPos);
                    }
                    Dn dn = new Dn(this.schemaManager, valueStr);
                    Dn newDn = this.anonymizeDn(dn);
                    String newDnStr = newDn.toString();
                    if (uid != null) {
                        newDnStr = newDnStr + '#' + uid;
                    }
                    newEntry.add(attributeType, newDnStr);
                }
                continue;
            }
            Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType().getOid());
            if (anonymizer == null) {
                newEntry.add(attribute);
                continue;
            }
            Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, this.valueSet, attribute);
            if (anonymizedAttribute == null) continue;
            newEntry.add(anonymizedAttribute);
        }
        newEntry.setDn(anonymizedDn);
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String anonymize(String ldif) throws LdapException, IOException {
        try (LdifReader ldifReader = new LdifReader(this.schemaManager);){
            List<LdifEntry> entries = ldifReader.parseLdif(ldif);
            StringBuilder result = new StringBuilder();
            for (LdifEntry ldifEntry : entries) {
                LdifEntry newLdifEntry;
                if (ldifEntry.isEntry() && !ldifEntry.isChangeAdd()) {
                    Entry newEntry = this.anonymizeEntry(ldifEntry);
                    result.append(LdifUtils.convertToLdif(newEntry));
                    result.append("\n");
                    continue;
                }
                if (ldifEntry.isChangeDelete()) {
                    newLdifEntry = this.anonymizeChangeDelete(ldifEntry);
                    if (newLdifEntry == null) continue;
                    result.append(newLdifEntry);
                    result.append("\n");
                    continue;
                }
                if (ldifEntry.isChangeAdd()) {
                    newLdifEntry = this.anonymizeChangeAdd(ldifEntry);
                    if (newLdifEntry == null) continue;
                    result.append(newLdifEntry);
                    result.append("\n");
                    continue;
                }
                if (ldifEntry.isChangeModify()) {
                    newLdifEntry = this.anonymizeChangeModify(ldifEntry);
                    if (newLdifEntry == null) continue;
                    result.append(newLdifEntry);
                    result.append("\n");
                    continue;
                }
                if (!ldifEntry.isChangeModDn() && !ldifEntry.isChangeModRdn() || (newLdifEntry = this.anonymizeChangeModDn(ldifEntry)) == null) continue;
                result.append(newLdifEntry);
                result.append("\n");
            }
            String string = result.toString();
            return string;
        }
    }

    public Map<Value, Value> getValueMap() {
        return this.valueMap;
    }

    public void setValueMap(Map<Value, Value> valueMap) {
        this.valueMap = valueMap;
    }

    public Map<Integer, String> getLatestStringMap() {
        return this.latestStringMap;
    }

    public void setLatestStringMap(Map<Integer, String> latestStringMap) {
        this.latestStringMap = latestStringMap;
    }

    public Map<Integer, byte[]> getLatestBytesMap() {
        return this.latestBytesMap;
    }

    public void setLatestBytesMap(Map<Integer, byte[]> latestBytesMap) {
        this.latestBytesMap = latestBytesMap;
    }

    public static void main(String[] args) throws IOException, LdapException {
        if (args == null || args.length < 1) {
            System.out.println("No file to anonymize");
            return;
        }
        LdifAnonymizer anonymizer = new LdifAnonymizer();
        String ldifString = null;
        try (InputStream fis = Files.newInputStream(Paths.get(args[0], new String[0]), new OpenOption[0]);
             BufferedReader br = new BufferedReader(new InputStreamReader(fis, Charset.defaultCharset()));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            ldifString = sb.toString();
        }
        String result = anonymizer.anonymize(ldifString);
        System.out.println(result);
    }
}

