/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapEncoder;
import org.apache.directory.api.ldap.codec.decorators.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionResponseDecoder;
import org.apache.directory.api.ldap.extras.extended.endTransaction.EndTransactionResponse;
import org.apache.directory.api.ldap.extras.extended.endTransaction.UpdateControls;
import org.apache.directory.api.ldap.model.message.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndTransactionResponseDecorator
extends ExtendedResponseDecorator<EndTransactionResponse>
implements EndTransactionResponse {
    private static final Logger LOG = LoggerFactory.getLogger(EndTransactionResponseDecorator.class);
    private EndTransactionResponse endTransactionResponse;
    private UpdateControls currentUpdateControls;
    private int globalSequenceLength = 0;
    private int updateSequenceLength = 0;
    private int[] updateControlsLength;
    private int[] controlsLengths;
    private int[][] controlLengths;

    public EndTransactionResponseDecorator(LdapApiService codec, EndTransactionResponse decoratedMessage) {
        super(codec, decoratedMessage);
        this.endTransactionResponse = decoratedMessage;
    }

    @Override
    public void setResponseValue(byte[] responseValue) {
        EndTransactionResponseDecoder decoder = new EndTransactionResponseDecoder();
        try {
            if (responseValue != null) {
                this.endTransactionResponse = decoder.decode(responseValue);
                this.responseValue = new byte[responseValue.length];
                System.arraycopy(responseValue, 0, this.responseValue, 0, responseValue.length);
            } else {
                this.responseValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_08217_PAYLOAD_DECODING_ERROR, new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getFailedMessageId() {
        return this.endTransactionResponse.getFailedMessageId();
    }

    @Override
    public void setFailedMessageId(int failedMessageId) {
        this.endTransactionResponse.setFailedMessageId(failedMessageId);
    }

    @Override
    public List<UpdateControls> getUpdateControls() {
        return this.endTransactionResponse.getUpdateControls();
    }

    public UpdateControls getCurrentUpdateControls() {
        return this.currentUpdateControls;
    }

    public void setCurrentControls(UpdateControls currentUpdateControls) {
        this.currentUpdateControls = currentUpdateControls;
    }

    int computeLengthInternal() {
        this.globalSequenceLength = 0;
        if (this.endTransactionResponse.getFailedMessageId() >= 0) {
            this.globalSequenceLength = 2 + BerValue.getNbBytes(this.endTransactionResponse.getFailedMessageId());
            return 2 + this.globalSequenceLength;
        }
        int updateControlsSize = this.getUpdateControls().size();
        if (updateControlsSize > 0) {
            this.updateControlsLength = new int[updateControlsSize];
            this.controlsLengths = new int[updateControlsSize];
            this.controlLengths = new int[updateControlsSize][];
            int messageControlsCount = 0;
            this.updateSequenceLength = 0;
            for (UpdateControls updateControls : this.getUpdateControls()) {
                this.updateControlsLength[messageControlsCount] = 2 + BerValue.getNbBytes(updateControls.getMessageId());
                int controlNumber = updateControls.getControls().size();
                if (controlNumber > 0) {
                    int controlCount = 0;
                    this.controlLengths[messageControlsCount] = new int[controlNumber];
                    for (Control control : updateControls.getControls()) {
                        this.controlLengths[messageControlsCount][controlCount] = LdapEncoder.computeControlLength(control);
                        int n = messageControlsCount;
                        this.controlsLengths[n] = this.controlsLengths[n] + (1 + TLV.getNbBytes(this.controlLengths[messageControlsCount][controlCount]) + this.controlLengths[messageControlsCount][controlCount]);
                        ++controlCount;
                    }
                    int controlsLength = this.controlsLengths[messageControlsCount];
                    int n = messageControlsCount;
                    this.updateControlsLength[n] = this.updateControlsLength[n] + (1 + TLV.getNbBytes(controlsLength) + controlsLength);
                }
                this.updateSequenceLength += 1 + TLV.getNbBytes(this.updateControlsLength[messageControlsCount]) + this.updateControlsLength[messageControlsCount];
                ++messageControlsCount;
            }
            this.globalSequenceLength = 1 + TLV.getNbBytes(this.updateSequenceLength) + this.updateSequenceLength;
            return 1 + TLV.getNbBytes(this.globalSequenceLength) + this.globalSequenceLength;
        }
        return 0;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes(this.globalSequenceLength));
        if (this.getFailedMessageId() >= 0) {
            BerValue.encode(bb, this.getFailedMessageId());
        } else {
            bb.put(UniversalTag.SEQUENCE.getValue());
            bb.put(TLV.getBytes(this.updateSequenceLength));
            int updateControlsNb = 0;
            for (UpdateControls updateControls : this.getUpdateControls()) {
                bb.put(UniversalTag.SEQUENCE.getValue());
                bb.put(TLV.getBytes(this.updateControlsLength[updateControlsNb]));
                BerValue.encode(bb, updateControls.getMessageId());
                bb.put(UniversalTag.SEQUENCE.getValue());
                bb.put(TLV.getBytes(this.controlsLengths[updateControlsNb]));
                int controlNb = 0;
                for (Control control : updateControls.getControls()) {
                    int valueLength;
                    bb.put(UniversalTag.SEQUENCE.getValue());
                    bb.put(TLV.getBytes(this.controlLengths[updateControlsNb][controlNb]));
                    BerValue.encode(bb, control.getOid());
                    if (control.isCritical()) {
                        BerValue.encode(bb, true);
                    }
                    if ((valueLength = ((CodecControl)control).computeLength()) > 0) {
                        bb.put(UniversalTag.OCTET_STRING.getValue());
                        bb.put(TLV.getBytes(valueLength));
                        ((CodecControl)control).encode(bb);
                    }
                    ++controlNb;
                }
                ++updateControlsNb;
            }
        }
        return bb;
    }
}

