/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.standalone;

import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.IntermediateResponseFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.cascade.CascadeFactory;
import org.apache.directory.api.ldap.codec.controls.manageDsaIT.ManageDsaITFactory;
import org.apache.directory.api.ldap.codec.controls.proxiedauthz.ProxiedAuthzFactory;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeFactory;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsFactory;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.api.ldap.codec.controls.search.subentries.SubentriesFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseFactory;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncFactory;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdPolicyHintsFactory;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdShowDeletedFactory;
import org.apache.directory.api.ldap.extras.controls.changeNotifications_impl.ChangeNotificationsFactory;
import org.apache.directory.api.ldap.extras.controls.permissiveModify_impl.PermissiveModifyFactory;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueFactory;
import org.apache.directory.api.ldap.extras.controls.transaction_impl.TransactionSpecificationFactory;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewRequestFactory;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewResponseFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.cancel.CancelFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.startTls.StartTlsFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.startTransaction.StartTransactionFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIFactory;
import org.apache.directory.api.ldap.extras.intermediate.syncrepl_impl.SyncInfoValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodecFactoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CodecFactoryUtil.class);

    private CodecFactoryUtil() {
    }

    public static void loadStockControls(Map<String, ControlFactory<?>> controlFactories, LdapApiService apiService) {
        CascadeFactory cascadeFactory = new CascadeFactory(apiService);
        controlFactories.put(cascadeFactory.getOid(), cascadeFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, cascadeFactory.getOid()));
        }
        EntryChangeFactory entryChangeFactory = new EntryChangeFactory(apiService);
        controlFactories.put(entryChangeFactory.getOid(), entryChangeFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, entryChangeFactory.getOid()));
        }
        ManageDsaITFactory manageDsaITFactory = new ManageDsaITFactory(apiService);
        controlFactories.put(manageDsaITFactory.getOid(), manageDsaITFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, manageDsaITFactory.getOid()));
        }
        ProxiedAuthzFactory proxiedAuthzFactory = new ProxiedAuthzFactory(apiService);
        controlFactories.put(proxiedAuthzFactory.getOid(), proxiedAuthzFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, proxiedAuthzFactory.getOid()));
        }
        PagedResultsFactory pagedResultsFactory = new PagedResultsFactory(apiService);
        controlFactories.put(pagedResultsFactory.getOid(), pagedResultsFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, pagedResultsFactory.getOid()));
        }
        PersistentSearchFactory persistentSearchFactory = new PersistentSearchFactory(apiService);
        controlFactories.put(persistentSearchFactory.getOid(), persistentSearchFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, persistentSearchFactory.getOid()));
        }
        SubentriesFactory subentriesFactory = new SubentriesFactory(apiService);
        controlFactories.put(subentriesFactory.getOid(), subentriesFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, subentriesFactory.getOid()));
        }
        SortRequestFactory sortRequestFactory = new SortRequestFactory(apiService);
        controlFactories.put(sortRequestFactory.getOid(), sortRequestFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, sortRequestFactory.getOid()));
        }
        SortResponseFactory sortResponseFactory = new SortResponseFactory(apiService);
        controlFactories.put(sortResponseFactory.getOid(), sortResponseFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, sortResponseFactory.getOid()));
        }
        AdDirSyncFactory adDirSyncFactory = new AdDirSyncFactory(apiService);
        controlFactories.put(adDirSyncFactory.getOid(), adDirSyncFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, adDirSyncFactory.getOid()));
        }
        AdShowDeletedFactory adShowDeletedFactory = new AdShowDeletedFactory(apiService);
        controlFactories.put(adShowDeletedFactory.getOid(), adShowDeletedFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, adShowDeletedFactory.getOid()));
        }
        AdPolicyHintsFactory adPolicyHintsFactory = new AdPolicyHintsFactory(apiService);
        controlFactories.put(adPolicyHintsFactory.getOid(), adPolicyHintsFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, adPolicyHintsFactory.getOid()));
        }
        ChangeNotificationsFactory changeNotificationsFactory = new ChangeNotificationsFactory(apiService);
        controlFactories.put(changeNotificationsFactory.getOid(), changeNotificationsFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, changeNotificationsFactory.getOid()));
        }
        PermissiveModifyFactory permissiveModifyFactory = new PermissiveModifyFactory(apiService);
        controlFactories.put(permissiveModifyFactory.getOid(), permissiveModifyFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, permissiveModifyFactory.getOid()));
        }
        PasswordPolicyFactory passwordPolicyFactory = new PasswordPolicyFactory(apiService);
        controlFactories.put(passwordPolicyFactory.getOid(), passwordPolicyFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, passwordPolicyFactory.getOid()));
        }
        SyncDoneValueFactory syncDoneValueFactory = new SyncDoneValueFactory(apiService);
        controlFactories.put(syncDoneValueFactory.getOid(), syncDoneValueFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, syncDoneValueFactory.getOid()));
        }
        SyncRequestValueFactory syncRequestValueFactory = new SyncRequestValueFactory(apiService);
        controlFactories.put(syncRequestValueFactory.getOid(), syncRequestValueFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, syncRequestValueFactory.getOid()));
        }
        SyncStateValueFactory syncStateValueFactory = new SyncStateValueFactory(apiService);
        controlFactories.put(syncStateValueFactory.getOid(), syncStateValueFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, syncStateValueFactory.getOid()));
        }
        TransactionSpecificationFactory transactionSpecificationFactory = new TransactionSpecificationFactory(apiService);
        controlFactories.put(transactionSpecificationFactory.getOid(), transactionSpecificationFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, transactionSpecificationFactory.getOid()));
        }
        VirtualListViewRequestFactory virtualListViewRequestFactory = new VirtualListViewRequestFactory(apiService);
        controlFactories.put(virtualListViewRequestFactory.getOid(), virtualListViewRequestFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, virtualListViewRequestFactory.getOid()));
        }
        VirtualListViewResponseFactory virtualListViewResponseFactory = new VirtualListViewResponseFactory(apiService);
        controlFactories.put(virtualListViewResponseFactory.getOid(), virtualListViewResponseFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, virtualListViewResponseFactory.getOid()));
        }
    }

    public static void loadStockExtendedOperations(Map<String, ExtendedOperationFactory> extendendOperationsFactories, LdapApiService apiService) {
        CancelFactory cancelFactory = new CancelFactory(apiService);
        extendendOperationsFactories.put(cancelFactory.getOid(), cancelFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, cancelFactory.getOid()));
        }
        CertGenerationFactory certGenerationFactory = new CertGenerationFactory(apiService);
        extendendOperationsFactories.put(certGenerationFactory.getOid(), certGenerationFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, certGenerationFactory.getOid()));
        }
        EndTransactionFactory endTransactionFactory = new EndTransactionFactory(apiService);
        extendendOperationsFactories.put(endTransactionFactory.getOid(), endTransactionFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, endTransactionFactory.getOid()));
        }
        GracefulDisconnectFactory gracefulDisconnectFactory = new GracefulDisconnectFactory(apiService);
        extendendOperationsFactories.put(gracefulDisconnectFactory.getOid(), gracefulDisconnectFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, gracefulDisconnectFactory.getOid()));
        }
        GracefulShutdownFactory gracefulShutdownFactory = new GracefulShutdownFactory(apiService);
        extendendOperationsFactories.put(gracefulShutdownFactory.getOid(), gracefulShutdownFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, gracefulShutdownFactory.getOid()));
        }
        PasswordModifyFactory passwordModifyFactory = new PasswordModifyFactory(apiService);
        extendendOperationsFactories.put(passwordModifyFactory.getOid(), passwordModifyFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, passwordModifyFactory.getOid()));
        }
        StartTlsFactory startTlsFactory = new StartTlsFactory(apiService);
        extendendOperationsFactories.put(startTlsFactory.getOid(), startTlsFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, startTlsFactory.getOid()));
        }
        StartTransactionFactory startTransactionFactory = new StartTransactionFactory(apiService);
        extendendOperationsFactories.put(startTransactionFactory.getOid(), startTransactionFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, startTransactionFactory.getOid()));
        }
        StoredProcedureFactory storedProcedureFactory = new StoredProcedureFactory(apiService);
        extendendOperationsFactories.put(storedProcedureFactory.getOid(), storedProcedureFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, storedProcedureFactory.getOid()));
        }
        WhoAmIFactory whoAmIFactory = new WhoAmIFactory(apiService);
        extendendOperationsFactories.put(whoAmIFactory.getOid(), whoAmIFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, whoAmIFactory.getOid()));
        }
    }

    public static void loadStockIntermediateResponses(Map<String, IntermediateResponseFactory> intermediateResponseFactories, LdapApiService apiService) {
        SyncInfoValueFactory syncInfoValueFactory = new SyncInfoValueFactory(apiService);
        intermediateResponseFactories.put(syncInfoValueFactory.getOid(), syncInfoValueFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06002_REGISTERED_INTERMEDIATE_FACTORY, syncInfoValueFactory.getOid()));
        }
    }
}

