/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.intermediate;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.IntermediateResponseDecorator;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreIntermediateResponseName
extends GrammarAction<LdapMessageContainer<IntermediateResponseDecorator<?>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreIntermediateResponseName.class);

    public StoreIntermediateResponseName() {
        super("Store response name");
    }

    @Override
    public void action(LdapMessageContainer<IntermediateResponseDecorator<?>> container) throws DecoderException {
        IntermediateResponse intermediateResponse = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_05122_NULL_NAME, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] responseNameBytes = tlv.getValue().getData();
        String oidStr = Strings.utf8ToString(responseNameBytes);
        if (!Oid.isOid(oidStr)) {
            String msg = I18n.err(I18n.ERR_05133_INTERMEDIATE_RESPONSE_INVALID_OID, Strings.utf8ToString(responseNameBytes), Strings.dumpBytes(responseNameBytes));
            LOG.error(I18n.err(I18n.ERR_05114_ERROR_MESSAGE, msg, oidStr));
            throw new DecoderException(msg);
        }
        Oid.isOid(oidStr);
        intermediateResponse.setResponseName(oidStr);
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05172_OID_READ, intermediateResponse.getResponseName()));
        }
    }
}

