/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.modify;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.ModifyRequestDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAttributeVals
extends GrammarAction<LdapMessageContainer<ModifyRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAttributeVals.class);

    public InitAttributeVals() {
        super("Init Attribute vals");
    }

    @Override
    public void action(LdapMessageContainer<ModifyRequestDecorator> container) {
        TLV tlv = container.getCurrentTLV();
        if (LOG.isDebugEnabled() && tlv.getLength() == 0) {
            LOG.debug(I18n.msg(I18n.MSG_05129_NO_VALS_FOR_ATTRIBUTE, new Object[0]));
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05130_SOME_VALS_NEED_DECODING, new Object[0]));
        }
    }
}

