/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckLengthNotNull
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(CheckLengthNotNull.class);

    public CheckLengthNotNull() {
        super("Check that the length is not null");
    }

    @Override
    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        int expectedLength = tlv.getLength();
        if (expectedLength == 0) {
            String msg = I18n.err(I18n.ERR_08213_NULL_CONTROL_LENGTH, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
    }
}

