/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.request;

import org.apache.directory.api.dsmlv2.request.AbstractResultResponseRequestDsml;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareRequestImpl;
import org.apache.directory.api.ldap.model.message.CompareResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.dom4j.Element;

public class CompareRequestDsml
extends AbstractResultResponseRequestDsml<CompareRequest, CompareResponse>
implements CompareRequest {
    public CompareRequestDsml(LdapApiService codec) {
        super(codec, new CompareRequestImpl());
    }

    public CompareRequestDsml(LdapApiService codec, CompareRequest ldapMessage) {
        super(codec, ldapMessage);
    }

    @Override
    public MessageTypeEnum getType() {
        return ((CompareRequest)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        Element element = super.toDsml(root);
        CompareRequest request = (CompareRequest)this.getDecorated();
        if (request.getName() != null) {
            element.addAttribute("dn", request.getName().getName());
        }
        Element assertionElement = element.addElement("assertion");
        if (request.getAttributeId() != null) {
            assertionElement.addAttribute("name", request.getAttributeId());
        }
        if (request.getAssertionValue() != null) {
            assertionElement.addElement("value").setText(request.getAssertionValue().getValue());
        }
        return element;
    }

    @Override
    public Dn getName() {
        return ((CompareRequest)this.getDecorated()).getName();
    }

    @Override
    public CompareRequest setName(Dn entry) {
        ((CompareRequest)this.getDecorated()).setName(entry);
        return this;
    }

    public void setAssertionValue(Object assertionValue) {
        if (assertionValue instanceof String) {
            ((CompareRequest)this.getDecorated()).setAssertionValue((String)assertionValue);
        } else {
            ((CompareRequest)this.getDecorated()).setAssertionValue((byte[])assertionValue);
        }
    }

    public String getAttributeDesc() {
        return ((CompareRequest)this.getDecorated()).getAttributeId();
    }

    public void setAttributeDesc(String attributeDesc) {
        ((CompareRequest)this.getDecorated()).setAttributeId(attributeDesc);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return ((CompareRequest)this.getDecorated()).getResponseType();
    }

    @Override
    public CompareRequest setAssertionValue(String value) {
        ((CompareRequest)this.getDecorated()).setAssertionValue(value);
        return this;
    }

    @Override
    public CompareRequest setAssertionValue(byte[] value) {
        ((CompareRequest)this.getDecorated()).setAssertionValue(value);
        return this;
    }

    @Override
    public String getAttributeId() {
        return ((CompareRequest)this.getDecorated()).getAttributeId();
    }

    @Override
    public CompareRequest setAttributeId(String attrId) {
        ((CompareRequest)this.getDecorated()).setAttributeId(attrId);
        return this;
    }

    @Override
    public Value getAssertionValue() {
        return ((CompareRequest)this.getDecorated()).getAssertionValue();
    }

    @Override
    public CompareRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public CompareRequest addControl(Control control) {
        return (CompareRequest)super.addControl(control);
    }

    @Override
    public CompareRequest addAllControls(Control[] controls) {
        return (CompareRequest)super.addAllControls(controls);
    }

    @Override
    public CompareRequest removeControl(Control control) {
        return (CompareRequest)super.removeControl(control);
    }
}

