/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.drda;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;

public class NetServlet
extends HttpServlet {
    private static final int MAX_CONNECT_TRYS = 20;
    private static final String SERVLET_PROP_MESSAGES = "org.apache.derby.loc.drda.servlet";
    private static final String SERVLET_ADDRESS = "derbynet";
    private static final String[] knownLang = new String[]{"cs", "en", "es", "de_DE", "fr", "hu", "it", "ja_JP", "ko_KR", "pl", "pt_BR", "ru", "zh_CN", "zh_TW"};
    private String host = "localhost";
    private int portNumber = 1527;
    private volatile String tracingDirectory;
    private volatile boolean logStatus = false;
    private volatile boolean traceStatus = false;
    private static final int NOT_GIVEN = -2;
    private static final int INVALID = -3;
    private NetworkServerControl server;

    public void init(ServletConfig servletConfig) throws ServletException {
        boolean bl;
        String string;
        int n;
        String string2 = servletConfig.getInitParameter("portNumber");
        if (string2 != null && (n = Integer.parseInt(string2)) > 0) {
            this.portNumber = n;
        }
        if ((string = servletConfig.getInitParameter("host")) != null) {
            this.host = string;
        }
        this.tracingDirectory = servletConfig.getInitParameter("tracingDirectory");
        if (this.tracingDirectory == null) {
            this.tracingDirectory = "";
        }
        String string3 = servletConfig.getInitParameter("startNetworkServerOnInit");
        try {
            if (this.server == null) {
                this.server = new NetworkServerControl(InetAddress.getByName(this.host), this.portNumber);
                if (!this.tracingDirectory.trim().equals("")) {
                    this.server.setTraceDirectory(this.tracingDirectory);
                }
            }
            if (NetServlet.isServerStarted(this.server, 1)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null && (bl = Boolean.valueOf(string3).booleanValue())) {
            LocalizedResource localizedResource = new LocalizedResource(SERVLET_PROP_MESSAGES);
            this.runServer(localizedResource, null, null);
            return;
        }
    }

    public synchronized void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String[] stringArray = new String[1];
        LocalizedResource localizedResource = this.getCurrentAppUI(httpServletRequest, stringArray);
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        httpServletResponse.setHeader("Cache-Control", "no-cache,no-store");
        String string = httpServletRequest.getContextPath() + httpServletRequest.getServletPath();
        String string2 = "<form enctype='multipart/form-data; charset=UTF-8' action='" + string + "'>";
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), "UTF8"), true);
        String string3 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_LogOn", new Object[0]));
        String string4 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_LogOff", new Object[0]));
        String string5 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_TraceOn", new Object[0]));
        String string6 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_TraceOff", new Object[0]));
        String string7 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_Start", new Object[0]));
        String string8 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_Stop", new Object[0]));
        String string9 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_TraceSessButton", new Object[0]));
        String string10 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_TraceOnOff", new Object[0]));
        String string11 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_Return", new Object[0]));
        String string12 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_TraceDir", new Object[0]));
        String string13 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_NetParam", new Object[0]));
        this.printBanner(localizedResource, printWriter);
        if (this.server == null) {
            try {
                this.server = new NetworkServerControl();
            }
            catch (Exception exception) {
                this.printErrorForm(localizedResource, exception, string11, printWriter);
                return;
            }
        }
        this.server.setClientLocale(stringArray[0]);
        String string14 = this.getForm(httpServletRequest);
        String string15 = this.getDoAction(httpServletRequest);
        if (string15 != null) {
            string14 = string15.equals(string10) ? string9 : string15;
        }
        boolean bl = this.getServerStatus();
        if (string14 == null) {
            string14 = bl ? string7 : string8;
        } else if (string14.equals(string7)) {
            if (!bl) {
                this.runServer(localizedResource, string11, printWriter);
            }
        } else if (string14.equals(string8)) {
            if (bl) {
                this.shutdownServer(localizedResource, string11, printWriter);
            }
            this.setDefaults();
        } else if (string14.equals(string11)) {
            string14 = bl ? string7 : string8;
        }
        printWriter.println(string2);
        string14 = this.escapeSingleQuotes(string14);
        string15 = this.escapeSingleQuotes(string15);
        if (string14.equals(string7)) {
            String string16 = this.getLogging(httpServletRequest);
            String string17 = this.getTrace(httpServletRequest);
            if (string16 != null && string16.equals(string3) && this.logging(localizedResource, true, string11, printWriter)) {
                this.logStatus = true;
            }
            if (string16 != null && string16.equals(string4) && this.logging(localizedResource, false, string11, printWriter)) {
                this.logStatus = false;
            }
            if (string17 != null && string17.equals(string5) && this.traceAll(localizedResource, true, string11, printWriter)) {
                this.traceStatus = true;
            }
            if (string17 != null && string17.equals(string6) && this.traceAll(localizedResource, false, string11, printWriter)) {
                this.traceStatus = false;
            }
            this.displayCurrentStatus(localizedResource, string11, printWriter);
            printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_StopButton", new Object[0]) + "</h4>");
            printWriter.println("<INPUT type=submit name=form value='" + string8 + "'>");
            printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_LogButton2", new Object[0]) + "</h4>");
            if (this.logStatus) {
                printWriter.println("<INPUT type=submit name=logform value='" + string4 + "'>");
            } else {
                printWriter.println("<INPUT type=submit name=logform value='" + string3 + "'>");
            }
            printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_TraceButton2", new Object[0]) + "</h4>");
            if (this.traceStatus) {
                printWriter.println("<INPUT type=submit name=traceform value='" + string6 + "'>");
            } else {
                printWriter.println("<INPUT type=submit name=traceform value='" + string5 + "'>");
            }
            printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_TraceSession", new Object[0]) + "</h4>");
            printWriter.println("<INPUT type=submit name=form value='" + string9 + "'>");
            printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_TraceDirButton", new Object[0]) + "</h4>");
            printWriter.println("<INPUT type=submit name=form value='" + string12 + "'>");
            printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_ThreadButton", new Object[0]) + "</h4>");
            printWriter.println("<INPUT type=submit name=form value='" + string13 + "'>");
        } else if (string14.equals(string8)) {
            this.printAsContentHeader(localizedResource.getTextMessage("SRV_NotStarted", new Object[0]), printWriter);
            String string18 = this.getLogging(httpServletRequest);
            String string19 = this.getTrace(httpServletRequest);
            if (string18 != null && string18.equals(string3)) {
                this.logStatus = true;
            }
            if (string18 != null && string18.equals(string4)) {
                this.logStatus = false;
            }
            if (string19 != null && string19.equals(string5)) {
                this.traceStatus = true;
            }
            if (string19 != null && string19.equals(string6)) {
                this.traceStatus = false;
            }
            if (this.logStatus) {
                printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_LogOffButton", new Object[0]) + "</h4>");
                printWriter.println("<INPUT type=submit name=logform value='" + string4 + "'>");
            } else {
                printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_LogOnButton", new Object[0]) + "</h4>");
                printWriter.println("<INPUT type=submit name=logform value='" + string3 + "'>");
            }
            if (this.traceStatus) {
                printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_TraceOffButton", new Object[0]) + "</h4>");
                printWriter.println("<INPUT type=submit name=traceform value='" + string6 + "'>");
            } else {
                printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_TraceOnButton", new Object[0]) + "</h4>");
                printWriter.println("<INPUT type=submit name=traceform value='" + string5 + "'>");
            }
            printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_StartButton", new Object[0]) + "</h4>");
            printWriter.println("<INPUT type=submit name=form value='" + string7 + "'>");
        } else if (string14.equals(string9)) {
            if (string15 != null && string15.equals(string10)) {
                Properties properties;
                Integer n;
                String string20 = httpServletRequest.getParameter("sessionid");
                try {
                    n = Integer.valueOf(string20);
                }
                catch (NumberFormatException numberFormatException) {
                    this.printErrorForm(localizedResource, localizedResource.getTextMessage("SRV_InvalidVal", new Object[]{string20, localizedResource.getTextMessage("SRV_SessionID", new Object[0])}), string11, printWriter);
                    return;
                }
                try {
                    properties = this.server.getCurrentProperties();
                }
                catch (Exception exception) {
                    this.printErrorForm(localizedResource, exception, string11, printWriter);
                    return;
                }
                boolean bl2 = properties.getProperty("derby.drda.trace" + string20) == null;
                if (this.traceSession(localizedResource, bl2, n, string11, printWriter)) {
                    printWriter.println("<h4>" + localizedResource.getTextMessage(bl2 ? "SRV_StatusTraceNoOn" : "SRV_StatusTraceNoOff", new Object[]{n.toString()}) + "</h4>");
                } else {
                    return;
                }
            }
            this.printAsContentHeader(localizedResource.getTextMessage("SRV_TraceSessButton", new Object[0]), printWriter);
            printWriter.println("<h4>" + this.getHtmlLabelledMessageInstance(localizedResource, "SRV_SessionID", "sessionId") + "</h4>");
            printWriter.println("<INPUT type=text name=sessionid size=10 maxlength=10 id='sessionId' value=''>");
            printWriter.println("<h4> </h4>");
            printWriter.println("<INPUT type=submit name=doaction value='" + string10 + "'>");
            printWriter.println("<INPUT type=submit name=form value='" + string11 + "'>");
        } else if (string14.equals(string12)) {
            boolean bl3 = false;
            String string21 = null;
            this.printAsContentHeader(string12, printWriter);
            if (string15 != null && string15.equals(string12)) {
                string21 = this.getParam(httpServletRequest, "tracedirectory");
                if (this.traceDirectory(localizedResource, string21, string11, printWriter)) {
                    bl3 = true;
                } else {
                    return;
                }
            }
            if (bl3) {
                printWriter.println("<h2>" + localizedResource.getTextMessage("SRV_TraceDirDone", new Object[]{this.escapeHTML(string21)}) + "</h2>");
                printWriter.println("<INPUT type=submit name=form value='" + string11 + "'>");
            } else {
                printWriter.println("<h4>" + this.getHtmlLabelledMessageInstance(localizedResource, "SRV_TraceDir", "tracedir") + "</h4>");
                printWriter.println("<INPUT type=text name=tracedirectory size=60 maxlength=256 id='tracedir' value='" + this.escapeHTML(this.tracingDirectory) + "'>");
                printWriter.println("<h4> </h4>");
                printWriter.println("<INPUT type=submit name=doaction value='" + string12 + "'>");
                printWriter.println("<INPUT type=submit name=form value='" + string11 + "'>");
            }
        } else if (string14.equals(string13)) {
            int n;
            int n2;
            String string22 = localizedResource.getTextMessage("SRV_NewMaxThreads", new Object[0]);
            String string23 = localizedResource.getTextMessage("SRV_NewTimeSlice", new Object[0]);
            try {
                Properties properties = this.server.getCurrentProperties();
                String string24 = properties.getProperty("derby.drda.maxThreads");
                n2 = Integer.parseInt(string24);
                string24 = properties.getProperty("derby.drda.timeSlice");
                n = Integer.parseInt(string24);
            }
            catch (Exception exception) {
                this.printErrorForm(localizedResource, exception, string11, printWriter);
                return;
            }
            if (string15 != null && string15.equals(string13)) {
                int n3;
                int n4 = this.getIntParameter(httpServletRequest, "newmaxthreads", "SRV_NewMaxThreads", localizedResource, string11, printWriter);
                int n5 = n3 = n4 == -3 ? -2 : this.getIntParameter(httpServletRequest, "newtimeslice", "SRV_NewTimeSlice", localizedResource, string11, printWriter);
                if (n4 == -3 || n3 == -3) {
                    return;
                }
                if (n4 != -2 || n3 != -2) {
                    if (n4 != -2) {
                        n2 = n4;
                    }
                    if (n3 != -2) {
                        n = n3;
                    }
                    if (!this.setNetParam(localizedResource, n2, n, string11, printWriter)) {
                        return;
                    }
                }
            }
            printWriter.println(string2);
            this.printAsContentHeader(string13, printWriter);
            printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_MaxThreads", new Object[]{Integer.toString(n2) + "</h4>"}));
            printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_TimeSlice", new Object[]{Integer.toString(n) + "</h4>"}));
            printWriter.println("<h4> </h4>");
            printWriter.println("<h4> <label for='newmaxthreads'>" + string22 + "</label> </h4>");
            printWriter.println("<INPUT type=text name=newmaxthreads size=10 maxlength=10 id='newmaxthreads' value=''>");
            printWriter.println("<h4> <label for='newslice'>" + string23 + "</label> </h4>");
            printWriter.println("<INPUT type=text name=newtimeslice size=10 maxlength=10 id='newslice' value=''>");
            printWriter.println("<h4> </h4>");
            printWriter.println("<INPUT type=submit name=doaction value='" + string13 + "'>");
            printWriter.println("<INPUT type=submit name=form value='" + string11 + "'>");
        } else {
            System.out.println("Internal Error: Unknown form, " + string14);
            printWriter.println("Internal Error: Unknown form");
        }
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    private String getForm(HttpServletRequest httpServletRequest) throws IOException {
        return this.getParam(httpServletRequest, "form");
    }

    private String getDoAction(HttpServletRequest httpServletRequest) throws IOException {
        return this.getParam(httpServletRequest, "doaction");
    }

    private String getLogging(HttpServletRequest httpServletRequest) throws IOException {
        return this.getParam(httpServletRequest, "logform");
    }

    private String getTrace(HttpServletRequest httpServletRequest) throws IOException {
        return this.getParam(httpServletRequest, "traceform");
    }

    private String getParam(HttpServletRequest httpServletRequest, String string) throws IOException {
        String string2 = httpServletRequest.getParameter(string);
        if (string2 != null) {
            return new String(string2.getBytes("ISO-8859-1"), "UTF8");
        }
        return null;
    }

    private void runServer(LocalizedResource localizedResource, String string, PrintWriter printWriter) throws ServletException {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    NetworkServerControl networkServerControl = new NetworkServerControl(InetAddress.getByName(NetServlet.this.host), NetServlet.this.portNumber);
                    networkServerControl.start(null);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            }
        };
        Thread thread = null;
        try {
            thread = AccessController.doPrivileged(new PrivilegedExceptionAction<Thread>(){

                @Override
                public Thread run() throws Exception {
                    return new Thread(runnable);
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        thread.start();
        try {
            boolean bl = false;
            int n = 0;
            do {
                ++n;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    throw new ServletException(localizedResource.getTextMessage("SRV_Interupt", new Object[0]));
                }
                try {
                    if (!NetServlet.isServerStarted(this.server, 1)) continue;
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!bl && n < 20);
            if (n >= 20) {
                throw new Exception(localizedResource.getTextMessage("SRV_MaxTrys", new Object[]{Integer.toString(20)}));
            }
            if (this.logStatus) {
                this.server.logConnections(true);
            }
            if (this.traceStatus) {
                this.server.trace(true);
            }
        }
        catch (Exception exception) {
            if (printWriter != null) {
                this.printErrorForm(localizedResource, exception, string, printWriter);
            }
            throw new ServletException(exception.getMessage());
        }
    }

    private void printErrorForm(LocalizedResource localizedResource, Exception exception, String string, PrintWriter printWriter) {
        this.printAsContentHeader(localizedResource.getTextMessage("SRV_NetworkServerError", new Object[0]), printWriter);
        printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_Message", new Object[]{this.escapeHTML(exception.getMessage())}) + "</h4>");
        printWriter.println("<INPUT type=submit name=form value='" + string + "'>");
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    private void printErrorForm(LocalizedResource localizedResource, String string, String string2, PrintWriter printWriter) {
        this.printAsContentHeader(localizedResource.getTextMessage("SRV_NetworkServerError", new Object[0]), printWriter);
        printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_Message", new Object[]{this.escapeHTML(string)}) + "</h4>");
        printWriter.println("<INPUT type=submit name=form value='" + string2 + "'>");
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    private void displayCurrentStatus(LocalizedResource localizedResource, String string, PrintWriter printWriter) {
        try {
            this.printAsContentHeader(localizedResource.getTextMessage("SRV_Started", new Object[0]), printWriter);
            Properties properties = this.server.getCurrentProperties();
            String string2 = properties.getProperty("derby.drda.logConnections");
            this.logStatus = string2.equals("true");
            if (this.logStatus) {
                printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_StatusLogOn", new Object[0]) + "</h4>");
            } else {
                printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_StatusLogOff", new Object[0]) + "</h4>");
            }
            string2 = properties.getProperty("derby.drda.traceAll");
            this.traceStatus = string2.equals("true");
            if (this.traceStatus) {
                printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_StatusTraceOn", new Object[0]) + "</h4>");
            } else {
                printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_StatusTraceOff", new Object[0]) + "</h4>");
            }
            string2 = properties.getProperty("derby.drda.portNumber");
            printWriter.println("<h4>" + localizedResource.getTextMessage("SRV_PortNumber", new Object[]{string2}) + "</h4>");
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, exception, string, printWriter);
        }
    }

    private boolean getServerStatus() {
        try {
            if (NetServlet.isServerStarted(this.server, 1)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean shutdownServer(LocalizedResource localizedResource, String string, PrintWriter printWriter) {
        boolean bl = false;
        try {
            this.server.shutdown();
            bl = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, exception, string, printWriter);
        }
        return bl;
    }

    private boolean logging(LocalizedResource localizedResource, boolean bl, String string, PrintWriter printWriter) {
        boolean bl2 = false;
        try {
            this.server.logConnections(bl);
            bl2 = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, exception, string, printWriter);
        }
        return bl2;
    }

    private boolean traceAll(LocalizedResource localizedResource, boolean bl, String string, PrintWriter printWriter) {
        boolean bl2 = false;
        try {
            this.server.trace(bl);
            bl2 = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, exception, string, printWriter);
        }
        return bl2;
    }

    private boolean traceSession(LocalizedResource localizedResource, boolean bl, int n, String string, PrintWriter printWriter) {
        boolean bl2 = false;
        try {
            this.server.trace(n, bl);
            bl2 = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, exception, string, printWriter);
        }
        return bl2;
    }

    private boolean traceDirectory(LocalizedResource localizedResource, String string, String string2, PrintWriter printWriter) {
        boolean bl = false;
        if (string == null || string.equals("")) {
            this.printErrorForm(localizedResource, localizedResource.getTextMessage("SRV_MissingParam", new Object[]{localizedResource.getTextMessage("SRV_TraceDir", new Object[0])}), string2, printWriter);
            return bl;
        }
        try {
            this.tracingDirectory = string;
            this.server.setTraceDirectory(string);
            bl = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, exception, string2, printWriter);
        }
        return bl;
    }

    private boolean setNetParam(LocalizedResource localizedResource, int n, int n2, String string, PrintWriter printWriter) {
        boolean bl = false;
        try {
            this.server.setMaxThreads(n);
            this.server.setTimeSlice(n2);
            bl = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, exception, string, printWriter);
        }
        return bl;
    }

    private void setDefaults() {
        this.logStatus = false;
        this.traceStatus = false;
    }

    private int getIntParameter(HttpServletRequest httpServletRequest, String string, String string2, LocalizedResource localizedResource, String string3, PrintWriter printWriter) {
        int n;
        String string4 = httpServletRequest.getParameter(string);
        if (string4 == null || string4.equals("")) {
            return -2;
        }
        try {
            n = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, localizedResource.getTextMessage("SRV_InvalidVal", new Object[]{string4, localizedResource.getTextMessage(string2, new Object[0])}), string3, printWriter);
            return -3;
        }
        if (n < 0) {
            this.printErrorForm(localizedResource, localizedResource.getTextMessage("SRV_InvalidVal", new Object[]{string4, localizedResource.getTextMessage(string2, new Object[0])}), string3, printWriter);
            return -3;
        }
        return n;
    }

    private void printBanner(LocalizedResource localizedResource, PrintWriter printWriter) {
        printWriter.println("<!DOCTYPE html>");
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>" + localizedResource.getTextMessage("SRV_Banner", new Object[0]) + "</title>");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<a href=\"#navskip\">[ " + localizedResource.getTextMessage("SRV_SkipToContent", new Object[0]) + " ]</a>");
        printWriter.println("  -  <a href=\"derbynet\">[ " + localizedResource.getTextMessage("SRV_BackToMain", new Object[0]) + " ]</a>");
        printWriter.println("<hr>");
        printWriter.println("<h1>" + localizedResource.getTextMessage("SRV_Banner", new Object[0]) + "</h1>");
        printWriter.println("<hr>");
    }

    private LocalizedResource getCurrentAppUI(HttpServletRequest httpServletRequest, String[] stringArray) {
        String string = httpServletRequest.getHeader("Accept-Language");
        LocalizedResource localizedResource = new LocalizedResource(SERVLET_PROP_MESSAGES);
        stringArray[0] = null;
        if (string == null) {
            return localizedResource;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = this.translationAvailable(string2 = this.getLocStringFromLanguage(string2));
            if (n == -1) continue;
            localizedResource.init(null, string2, SERVLET_PROP_MESSAGES);
            stringArray[0] = string2;
            return localizedResource;
        }
        return localizedResource;
    }

    private String getLocStringFromLanguage(String string) {
        int n = string.indexOf(59);
        if (n != -1) {
            string = string.substring(0, n);
        }
        string = this.fixLanguageCode(string.trim());
        return string;
    }

    private int translationAvailable(String string) {
        for (int i = 0; i < knownLang.length; ++i) {
            if (!knownLang[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private String fixLanguageCode(String string) {
        int n = string.indexOf(45);
        if (n != -1) {
            return this.fixLanguageCode(string, n);
        }
        n = string.indexOf(95);
        if (n != -1) {
            return this.fixLanguageCode(string, n);
        }
        return string;
    }

    private String fixLanguageCode(String string, int n) {
        return string.substring(0, n) + "_" + string.substring(n + 1).toUpperCase(Locale.ENGLISH);
    }

    private String getHtmlLabelledMessageInstance(LocalizedResource localizedResource, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        return "<label for='" + string2 + "'>" + localizedResource.getTextMessage(string, new Object[0]) + "</label>";
    }

    private void printAsContentHeader(String string, PrintWriter printWriter) {
        printWriter.println("<a name=\"navskip\"></a><h2>" + string + "</h2>");
    }

    private String escapeSingleQuotes(String string) {
        if (string == null || string.indexOf("'") < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[5 * cArray.length];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\'') {
                cArray2[n++] = 38;
                cArray2[n++] = 35;
                cArray2[n++] = 51;
                cArray2[n++] = 57;
                cArray2[n++] = 59;
                continue;
            }
            cArray2[n++] = cArray[i];
        }
        return new String(cArray2, 0, n);
    }

    private String escapeHTML(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[5 * cArray.length];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            boolean bl = true;
            char c = cArray[i];
            switch (c) {
                case ';': {
                    cArray2[n++] = 38;
                    cArray2[n++] = 35;
                    cArray2[n++] = 53;
                    cArray2[n++] = 57;
                    break;
                }
                case '\\': {
                    cArray2[n++] = 38;
                    cArray2[n++] = 35;
                    cArray2[n++] = 57;
                    cArray2[n++] = 50;
                    break;
                }
                case '/': {
                    cArray2[n++] = 38;
                    cArray2[n++] = 35;
                    cArray2[n++] = 52;
                    cArray2[n++] = 55;
                    break;
                }
                case '<': {
                    cArray2[n++] = 38;
                    cArray2[n++] = 108;
                    cArray2[n++] = 116;
                    break;
                }
                case '>': {
                    cArray2[n++] = 38;
                    cArray2[n++] = 103;
                    cArray2[n++] = 116;
                    break;
                }
                case '\"': {
                    cArray2[n++] = 38;
                    cArray2[n++] = 35;
                    cArray2[n++] = 51;
                    cArray2[n++] = 52;
                    break;
                }
                case '\'': {
                    cArray2[n++] = 38;
                    cArray2[n++] = 35;
                    cArray2[n++] = 51;
                    cArray2[n++] = 57;
                    break;
                }
                case '=': {
                    cArray2[n++] = 38;
                    cArray2[n++] = 35;
                    cArray2[n++] = 54;
                    cArray2[n++] = 49;
                    break;
                }
                case '&': {
                    cArray2[n++] = 38;
                    cArray2[n++] = 97;
                    cArray2[n++] = 109;
                    cArray2[n++] = 112;
                    break;
                }
                default: {
                    cArray2[n++] = c;
                    bl = false;
                }
            }
            if (!bl) continue;
            cArray2[n++] = 59;
        }
        return String.copyValueOf(cArray2, 0, n);
    }

    private static boolean isServerStarted(NetworkServerControl networkServerControl, int n) {
        for (int i = 1; i <= n; ++i) {
            try {
                Thread.sleep(500L);
                networkServerControl.ping();
                return true;
            }
            catch (Exception exception) {
                if (i != n) continue;
                return false;
            }
        }
        return false;
    }
}

