/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.sql.Array;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.FailedProperties40;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.jdbc.ClientBaseDataSource;

public class NetConnection40
extends NetConnection {
    private PreparedStatement isValidStmt = null;

    public NetConnection40(NetLogWriter netLogWriter, String string, Properties properties) throws SqlException {
        super(netLogWriter, string, properties);
    }

    public NetConnection40(NetLogWriter netLogWriter, ClientBaseDataSource clientBaseDataSource, String string, String string2) throws SqlException {
        super(netLogWriter, clientBaseDataSource, string, string2);
    }

    public NetConnection40(NetLogWriter netLogWriter, int n, String string, int n2, String string2, Properties properties) throws SqlException {
        super(netLogWriter, n, string, n2, string2, properties);
    }

    public NetConnection40(NetLogWriter netLogWriter, String string, String string2, ClientBaseDataSource clientBaseDataSource, int n, boolean bl) throws SqlException {
        super(netLogWriter, string, string2, clientBaseDataSource, n, bl);
    }

    public NetConnection40(NetLogWriter netLogWriter, String string, int n, ClientBaseDataSource clientBaseDataSource, boolean bl) throws SqlException {
        super(netLogWriter, string, n, clientBaseDataSource, bl);
    }

    public NetConnection40(NetLogWriter netLogWriter, String string, String string2, ClientBaseDataSource clientBaseDataSource, int n, boolean bl, ClientPooledConnection clientPooledConnection) throws SqlException {
        super(netLogWriter, string, string2, clientBaseDataSource, n, bl, clientPooledConnection);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw SQLExceptionFactory.notImplemented("createArrayOf(String,Object[])");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw SQLExceptionFactory.notImplemented("createNClob ()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw SQLExceptionFactory.notImplemented("createSQLXML ()");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw SQLExceptionFactory.notImplemented("createStruct(String,Object[])");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(n), (Object)"timeout", "java.sql.Connection.isValid").getSQLException();
        }
        if (this.isClosed()) {
            return false;
        }
        NetConnection40 netConnection40 = this;
        synchronized (netConnection40) {
            try {
                int n2 = this.netAgent_.getTimeout();
                this.netAgent_.setTimeout(n);
                if (this.isValidStmt == null) {
                    this.isValidStmt = this.prepareStatement("VALUES (1)");
                }
                this.isValidStmt.setQueryTimeout(n);
                ResultSet resultSet = this.isValidStmt.executeQuery();
                resultSet.close();
                this.netAgent_.setTimeout(n2);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isValidStmt != null) {
            this.isValidStmt.close();
            this.isValidStmt = null;
        }
        super.close();
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        Properties properties = FailedProperties40.makeProperties(string, string2);
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw new SQLClientInfoException(sqlException.getMessage(), sqlException.getSQLState(), new FailedProperties40(properties).getProperties());
        }
        if (string == null && string2 == null) {
            return;
        }
        this.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        FailedProperties40 failedProperties40 = new FailedProperties40(properties);
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw new SQLClientInfoException(sqlException.getMessage(), sqlException.getSQLState(), failedProperties40.getProperties());
        }
        if (properties == null || properties.isEmpty()) {
            return;
        }
        SqlException sqlException = new SqlException(this.agent_.logWriter_, new ClientMessageId("XCY02.S"), (Object)failedProperties40.getFirstKey(), failedProperties40.getFirstValue());
        throw new SQLClientInfoException(sqlException.getMessage(), sqlException.getSQLState(), failedProperties40.getProperties());
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        try {
            this.checkForClosedConnection();
            return null;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            this.checkForClosedConnection();
            return new Properties();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        Map map = super.getTypeMap();
        if (map == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        for (Object k : map.keySet()) {
            hashMap.put((String)k, (Class)map.get(k));
        }
        return hashMap;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            this.checkForClosedConnection();
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), clazz).getSQLException();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }
}

