/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.UnitOfWorkListener;
import org.apache.derby.client.am.Utils;

public abstract class ResultSet
implements java.sql.ResultSet,
ResultSetCallbackInterface,
UnitOfWorkListener {
    public Statement statement_;
    public ColumnMetaData resultSetMetaData_;
    private SqlWarning warnings_;
    public Cursor cursor_;
    protected Agent agent_;
    public Section generatedSection_ = null;
    public final Connection connection_;
    public static final int scrollOrientation_relative__ = 1;
    public static final int scrollOrientation_absolute__ = 2;
    public static final int scrollOrientation_after__ = 3;
    public static final int scrollOrientation_before__ = 4;
    public static final int scrollOrientation_prior__ = 5;
    public static final int scrollOrientation_first__ = 6;
    public static final int scrollOrientation_last__ = 7;
    public static final int scrollOrientation_current__ = 8;
    public static final int scrollOrientation_next__ = 0;
    public static final int updatability_unknown__ = 0;
    public static final int updatability_readOnly__ = 1;
    public static final int updatability_delete__ = 2;
    public static final int updatability_update__ = 4;
    public static final int sensitivity_unknown__ = 0;
    public static final int sensitivity_insensitive__ = 1;
    public static final int sensitivity_sensitive_static__ = 2;
    public static final int sensitivity_sensitive_dynamic__ = 3;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;
    private static final int WAS_NULL_UNSET = 0;
    public static final int NEXT_ROWSET = 1;
    public static final int PREVIOUS_ROWSET = 2;
    public static final int ABSOLUTE_ROWSET = 3;
    public static final int FIRST_ROWSET = 4;
    public static final int LAST_ROWSET = 5;
    public static final int RELATIVE_ROWSET = 6;
    public static final int REFRESH_ROWSET = 7;
    public static final byte DDM_RETURN_CALLER = 1;
    public static final byte DDM_RETURN_CLIENT = 2;
    private int wasNull_ = 0;
    protected byte rsReturnability_ = (byte)2;
    boolean openOnClient_ = true;
    public boolean openOnServer_ = true;
    public Sqlca queryTerminatingSqlca_;
    boolean autoCommitted_ = false;
    public boolean isValidCursorPosition_ = false;
    public boolean cursorHold_;
    public long queryInstanceIdentifier_ = 0L;
    public int resultSetType_;
    public int resultSetConcurrency_;
    public int resultSetHoldability_;
    public boolean scrollable_ = false;
    public int sensitivity_;
    public boolean isRowsetCursor_ = false;
    public boolean isBeforeFirst_ = true;
    public boolean isAfterLast_ = false;
    public boolean isFirst_ = false;
    public boolean isLast_ = false;
    public boolean rowsetContainsLastRow_ = false;
    public Sqlca[] rowsetSqlca_;
    public int fetchSize_;
    public int fetchDirection_;
    public long rowCount_ = -1L;
    protected long absolutePosition_ = 0L;
    protected long firstRowInRowset_ = 0L;
    protected long lastRowInRowset_ = 0L;
    protected long currentRowInRowset_ = -1L;
    protected long absoluteRowNumberForTheIntendedRow_;
    protected boolean updateRowCalled_ = false;
    private boolean isOnInsertRow_ = false;
    protected boolean isOnCurrentRow_ = true;
    public int rowsReceivedInCurrentRowset_ = 0;
    public int rowsYetToBeReceivedForRowset_ = 0;
    private Object[] updatedColumns_;
    private boolean[] columnUpdated_;
    public PreparedStatement preparedStatementForUpdate_;
    public PreparedStatement preparedStatementForDelete_;
    public int nestingLevel_ = -1;
    public boolean cursorUnpositionedOnServer_ = false;
    boolean listenToUnitOfWork_ = false;

    protected ResultSet(Agent agent, Statement statement, Cursor cursor, int n, int n2, int n3) {
        this.agent_ = agent;
        this.statement_ = statement;
        this.connection_ = this.statement_.connection_;
        this.cursor_ = cursor;
        if (this.cursor_ != null) {
            this.cursor_.maxFieldSize_ = this.statement_.maxFieldSize_;
        }
        this.resultSetType_ = n;
        this.resultSetConcurrency_ = n2;
        this.resultSetHoldability_ = n3;
        this.fetchDirection_ = this.statement_.fetchDirection_;
        this.fetchSize_ = this.statement_.fetchSize_;
        if (this.resultSetType_ < this.statement_.resultSetType_) {
            this.statement_.accumulateWarning(new SqlWarning(this.agent_.logWriter_, "Unable to open resultSet type " + this.statement_.resultSetType_ + "." + " ResultSet type " + this.resultSetType_ + " opened."));
        }
        if (this.resultSetConcurrency_ < this.statement_.resultSetConcurrency_) {
            this.statement_.accumulateWarning(new SqlWarning(this.agent_.logWriter_, "Unable to open ResultSet with concurrency  " + this.statement_.resultSetConcurrency_ + "." + " ResultSet concurrency " + this.resultSetConcurrency_ + " is used."));
        }
        this.listenToUnitOfWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean next() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "next");
            }
            boolean bl = this.nextX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "next", bl);
            }
            return bl;
        }
    }

    boolean nextX() throws SqlException {
        this.checkForClosedResultSet();
        this.clearWarningsX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        if (this.resultSetType_ == 1003) {
            boolean bl = this.isValidCursorPosition_ = this.cursor_ == null ? false : this.cursor_.next();
            if (this.fetchSize_ != 0) {
                if (this.rowsYetToBeReceivedForRowset_ == 0) {
                    this.rowsYetToBeReceivedForRowset_ = this.fetchSize_;
                }
                if (this.isValidCursorPosition_) {
                    --this.rowsYetToBeReceivedForRowset_;
                }
            }
            if (!this.isValidCursorPosition_ && this.cursor_ != null || this.statement_.maxRows_ > 0 && this.cursor_.rowsRead_ > this.statement_.maxRows_) {
                this.isValidCursorPosition_ = false;
                SqlException sqlException = null;
                if (!this.openOnServer_) {
                    int n = Utils.getSqlcodeFromSqlca(this.queryTerminatingSqlca_);
                    if (n > 0 && n != 100) {
                        this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, this.queryTerminatingSqlca_));
                    } else if (n < 0) {
                        sqlException = new SqlException(this.agent_.logWriter_, this.queryTerminatingSqlca_);
                    }
                }
                try {
                    this.closeX();
                }
                catch (SqlException sqlException2) {
                    sqlException = Utils.accumulateSQLException(sqlException2, sqlException);
                }
                if (sqlException != null) {
                    throw sqlException;
                }
            }
        } else {
            this.isAfterLast_ = false;
            this.isLast_ = false;
            if (this.rowIsInCurrentRowset(this.firstRowInRowset_ + this.currentRowInRowset_ + 1L, 0)) {
                this.isValidCursorPosition_ = true;
                ++this.currentRowInRowset_;
            } else {
                this.checkAndThrowReceivedQueryTerminatingException();
                this.isValidCursorPosition_ = this.getNextRowset();
            }
            if (this.isValidCursorPosition_) {
                this.updateColumnInfoFromCache();
                this.checkRowsetSqlca();
                if (this.isBeforeFirst_) {
                    this.isFirst_ = true;
                }
                this.isBeforeFirst_ = false;
            } else {
                this.isFirst_ = false;
                return this.isValidCursorPosition_;
            }
        }
        if (!this.openOnClient_) {
            this.isValidCursorPosition_ = false;
        } else if (this.sensitivity_ != 3 && this.statement_.maxRows_ > 0 && this.firstRowInRowset_ + this.currentRowInRowset_ > (long)this.statement_.maxRows_) {
            this.isValidCursorPosition_ = false;
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "close");
            }
            this.closeX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeX() throws SqlException {
        if (!this.openOnClient_) {
            return;
        }
        try {
            if (this.openOnServer_) {
                this.flowCloseAndAutoCommitIfNotAutoCommitted();
            } else {
                this.flowAutoCommitIfNotAutoCommitted();
            }
        }
        finally {
            this.markClosed();
            this.connection_.CommitAndRollbackListeners_.remove(this);
        }
        this.flowAutoCommitIfLastOpenMultipleResultSetWasJustClosed();
        if (this.statement_.openOnClient_ && this.statement_.isCatalogQuery_) {
            this.statement_.closeX();
        }
        this.nullDataForGC();
    }

    public void nullDataForGC() {
        if (this.cursor_ != null && !this.statement_.isPreparedStatement_) {
            this.cursor_.nullDataForGC();
        }
        this.cursor_ = null;
        this.resultSetMetaData_ = null;
    }

    void flowCloseAndAutoCommitIfNotAutoCommitted() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        this.writeCloseAndAutoCommitIfNotAutoCommitted();
        this.agent_.flow(this.statement_);
        this.readCloseAndAutoCommitIfNotAutoCommitted();
        this.agent_.endReadChain();
    }

    private void writeCloseAndAutoCommitIfNotAutoCommitted() throws SqlException {
        this.autoCommitted_ = false;
        if (this.generatedSection_ == null) {
            this.writeCursorClose_(this.statement_.section_);
            this.writeAutoCommitIfNotAutoCommitted();
        } else {
            this.writeCursorClose_(this.generatedSection_);
        }
    }

    private void readCloseAndAutoCommitIfNotAutoCommitted() throws SqlException {
        if (this.generatedSection_ == null) {
            this.readCursorClose_();
            this.readAutoCommitIfNotAutoCommitted();
        } else {
            this.readCursorClose_();
        }
    }

    void writeClose() throws SqlException {
        this.autoCommitted_ = false;
        if (this.generatedSection_ == null) {
            this.writeCursorClose_(this.statement_.section_);
        } else {
            this.writeCursorClose_(this.generatedSection_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readClose() throws SqlException {
        try {
            if (this.generatedSection_ == null) {
                this.readCursorClose_();
            } else {
                this.readCursorClose_();
            }
        }
        finally {
            this.markClosed();
        }
    }

    void flowAutoCommitIfNotAutoCommitted() throws SqlException {
        if (this.generatedSection_ == null && this.connection_.autoCommit_ && !this.autoCommitted_) {
            this.connection_.flowAutoCommit();
            this.markAutoCommitted();
        }
    }

    private void writeAutoCommitIfNotAutoCommitted() throws SqlException {
        if (this.connection_.autoCommit_ && !this.autoCommitted_) {
            this.connection_.writeAutoCommit();
        }
    }

    private void readAutoCommitIfNotAutoCommitted() throws SqlException {
        if (this.connection_.autoCommit_ && !this.autoCommitted_) {
            this.connection_.readAutoCommit();
            this.markAutoCommitted();
        }
    }

    private void flowAutoCommitIfLastOpenMultipleResultSetWasJustClosed() throws SqlException {
        if (this.generatedSection_ != null && this.statement_ != null && this.statement_.resultSetList_ != null) {
            int n = 0;
            for (int i = 0; i < this.statement_.resultSetList_.length; ++i) {
                if (this.statement_.resultSetList_[i] != null) continue;
                ++n;
            }
            if (n == this.statement_.resultSetList_.length && this.connection_.autoCommit_ && !this.autoCommitted_) {
                this.connection_.flowAutoCommit();
                this.markAutoCommitted();
            }
        }
        this.generatedSection_ = null;
    }

    public boolean wasNull() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "wasNull");
        }
        this.checkForClosedResultSet();
        if (this.wasNull_ == 0) {
            throw new SqlException(this.agent_.logWriter_, "Invalid operation: wasNull() called with no data retrieved");
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "wasNull", this.wasNull_ == 1);
        }
        return this.wasNull_ == 1;
    }

    public boolean getBoolean(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBoolean", n);
        }
        this.checkGetterPreconditions(n);
        boolean bl = false;
        if (this.wasNonNullSensitiveUpdate(n)) {
            bl = this.agent_.crossConverters_.setBooleanFromObject(this.updatedColumns_[n - 1], this.resultSetMetaData_.types_[n - 1]);
        } else {
            boolean bl2 = bl = this.isNull(n) ? false : this.cursor_.getBoolean(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getBoolean", bl);
        }
        this.setWasNull(n);
        return bl;
    }

    public byte getByte(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getByte", n);
        }
        this.checkGetterPreconditions(n);
        byte by = 0;
        if (this.wasNonNullSensitiveUpdate(n)) {
            by = this.agent_.crossConverters_.setByteFromObject(this.updatedColumns_[n - 1], this.resultSetMetaData_.types_[n - 1]);
        } else {
            byte by2 = by = this.isNull(n) ? (byte)0 : this.cursor_.getByte(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getByte", by);
        }
        this.setWasNull(n);
        return by;
    }

    public short getShort(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getShort", n);
        }
        this.checkGetterPreconditions(n);
        short s = 0;
        if (this.wasNonNullSensitiveUpdate(n)) {
            s = (Short)this.agent_.crossConverters_.setObject(5, this.updatedColumns_[n - 1]);
        } else {
            short s2 = s = this.isNull(n) ? (short)0 : this.cursor_.getShort(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getShort", s);
        }
        this.setWasNull(n);
        return s;
    }

    public int getInt(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getInt", n);
        }
        this.checkGetterPreconditions(n);
        int n2 = 0;
        if (this.wasNonNullSensitiveUpdate(n)) {
            n2 = (Integer)this.agent_.crossConverters_.setObject(4, this.updatedColumns_[n - 1]);
        } else {
            int n3 = n2 = this.isNull(n) ? 0 : this.cursor_.getInt(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getInt", n2);
        }
        this.setWasNull(n);
        return n2;
    }

    public long getLong(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getLong", n);
        }
        this.checkGetterPreconditions(n);
        long l = 0L;
        if (this.wasNonNullSensitiveUpdate(n)) {
            l = (Long)this.agent_.crossConverters_.setObject(-5, this.updatedColumns_[n - 1]);
        } else {
            long l2 = l = this.isNull(n) ? 0L : this.cursor_.getLong(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getLong", l);
        }
        this.setWasNull(n);
        return l;
    }

    public float getFloat(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getFloat", n);
        }
        this.checkGetterPreconditions(n);
        float f = 0.0f;
        if (this.wasNonNullSensitiveUpdate(n)) {
            f = ((Float)this.agent_.crossConverters_.setObject(7, this.updatedColumns_[n - 1])).floatValue();
        } else {
            float f2 = f = this.isNull(n) ? 0.0f : this.cursor_.getFloat(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getFloat", f);
        }
        this.setWasNull(n);
        return f;
    }

    public double getDouble(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDouble", n);
        }
        this.checkGetterPreconditions(n);
        double d = 0.0;
        if (this.wasNonNullSensitiveUpdate(n)) {
            d = (Double)this.agent_.crossConverters_.setObject(8, this.updatedColumns_[n - 1]);
        } else {
            double d2 = d = this.isNull(n) ? 0.0 : this.cursor_.getDouble(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getDouble", d);
        }
        this.setWasNull(n);
        return d;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceDeprecatedEntry((Object)this, "getBigDecimal", n, n2);
        }
        this.checkGetterPreconditions(n);
        BigDecimal bigDecimal = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            bigDecimal = ((BigDecimal)this.agent_.crossConverters_.setObject(3, this.updatedColumns_[n - 1])).setScale(n2, 1);
        } else {
            BigDecimal bigDecimal2 = bigDecimal = this.isNull(n) ? null : this.cursor_.getBigDecimal(n).setScale(n2, 1);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceDeprecatedExit((Object)this, "getBigDecimal", bigDecimal);
        }
        this.setWasNull(n);
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBigDecimal", n);
        }
        this.checkGetterPreconditions(n);
        BigDecimal bigDecimal = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            bigDecimal = (BigDecimal)this.agent_.crossConverters_.setObject(3, this.updatedColumns_[n - 1]);
        } else {
            BigDecimal bigDecimal2 = bigDecimal = this.isNull(n) ? null : this.cursor_.getBigDecimal(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getBigDecimal", bigDecimal);
        }
        this.setWasNull(n);
        return bigDecimal;
    }

    public Date getDate(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDate", n);
        }
        this.checkGetterPreconditions(n);
        Date date = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            date = (Date)this.agent_.crossConverters_.setObject(91, this.updatedColumns_[n - 1]);
        } else {
            Date date2 = date = this.isNull(n) ? null : this.cursor_.getDate(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getDate", date);
        }
        this.setWasNull(n);
        return date;
    }

    public Date getDate(int n, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDate", n, (Object)calendar);
        }
        if (calendar == null) {
            throw new SqlException(this.agent_.logWriter_, "Invalid parameter: calendar is null");
        }
        Date date = this.getDate(n);
        if (date != null) {
            Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.setTime(date);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.clear();
            calendar3.setTime(date);
            long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
            date.setTime(date.getTime() - l);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getDate", date);
        }
        return date;
    }

    public Time getTime(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTime", n);
        }
        this.checkGetterPreconditions(n);
        Time time = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            time = (Time)this.agent_.crossConverters_.setObject(92, this.updatedColumns_[n - 1]);
        } else {
            Time time2 = time = this.isNull(n) ? null : this.cursor_.getTime(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getTime", time);
        }
        this.setWasNull(n);
        return time;
    }

    public Time getTime(int n, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTime", n, (Object)calendar);
        }
        if (calendar == null) {
            throw new SqlException(this.agent_.logWriter_, "Invalid parameter: calendar is null");
        }
        Time time = this.getTime(n);
        if (time != null) {
            Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.setTime(time);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.clear();
            calendar3.setTime(time);
            long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
            time.setTime(time.getTime() - l);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getTime", time);
        }
        return time;
    }

    public Timestamp getTimestamp(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", n);
        }
        this.checkGetterPreconditions(n);
        Timestamp timestamp = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            timestamp = (Timestamp)this.agent_.crossConverters_.setObject(93, this.updatedColumns_[n - 1]);
        } else {
            Timestamp timestamp2 = timestamp = this.isNull(n) ? null : this.cursor_.getTimestamp(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", timestamp);
        }
        this.setWasNull(n);
        return timestamp;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", n, (Object)calendar);
        }
        if (calendar == null) {
            throw new SqlException(this.agent_.logWriter_, "Invalid parameter: calendar is null");
        }
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp != null) {
            int n2 = timestamp.getNanos();
            Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.setTime(timestamp);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.clear();
            calendar3.setTime(timestamp);
            long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
            timestamp.setTime(timestamp.getTime() - l);
            timestamp.setNanos(n2);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", timestamp);
        }
        return timestamp;
    }

    public String getString(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getString", n);
        }
        this.checkGetterPreconditions(n);
        String string = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            string = (String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[n - 1]);
        } else {
            String string2 = string = this.isNull(n) ? null : this.cursor_.getString(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getString", string);
        }
        this.setWasNull(n);
        return string;
    }

    public byte[] getBytes(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBytes", n);
        }
        this.checkGetterPreconditions(n);
        byte[] byArray = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            byArray = (byte[])this.agent_.crossConverters_.setObject(-2, this.updatedColumns_[n - 1]);
        } else {
            byte[] byArray2 = byArray = this.isNull(n) ? null : this.cursor_.getBytes(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getBytes", byArray);
        }
        this.setWasNull(n);
        return byArray;
    }

    public InputStream getBinaryStream(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBinaryStream", n);
        }
        this.checkGetterPreconditions(n);
        InputStream inputStream = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            inputStream = new ByteArrayInputStream((byte[])this.agent_.crossConverters_.setObject(-2, this.updatedColumns_[n - 1]));
        } else {
            InputStream inputStream2 = inputStream = this.isNull(n) ? null : this.cursor_.getBinaryStream(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getBinaryStream", inputStream);
        }
        this.setWasNull(n);
        return inputStream;
    }

    public InputStream getAsciiStream(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getAsciiStream", n);
        }
        this.checkGetterPreconditions(n);
        InputStream inputStream = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            try {
                inputStream = new ByteArrayInputStream(((String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[n - 1])).getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, unsupportedEncodingException.getMessage());
            }
        } else {
            InputStream inputStream2 = inputStream = this.isNull(n) ? null : this.cursor_.getAsciiStream(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getAsciiStream", inputStream);
        }
        this.setWasNull(n);
        return inputStream;
    }

    public InputStream getUnicodeStream(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceDeprecatedEntry((Object)this, "getUnicodeStream", n);
        }
        this.checkGetterPreconditions(n);
        InputStream inputStream = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            try {
                inputStream = new ByteArrayInputStream(((String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[n - 1])).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, unsupportedEncodingException.getMessage());
            }
        } else {
            InputStream inputStream2 = inputStream = this.isNull(n) ? null : this.cursor_.getUnicodeStream(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceDeprecatedExit((Object)this, "getUnicodeStream", inputStream);
        }
        this.setWasNull(n);
        return inputStream;
    }

    public Reader getCharacterStream(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getCharacterStream", n);
        }
        this.checkGetterPreconditions(n);
        Reader reader = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            reader = new StringReader((String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[n - 1]));
        } else {
            Reader reader2 = reader = this.isNull(n) ? null : this.cursor_.getCharacterStream(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", reader);
        }
        this.setWasNull(n);
        return reader;
    }

    public Blob getBlob(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBlob", n);
        }
        this.checkGetterPreconditions(n);
        Blob blob = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            blob = (Blob)this.agent_.crossConverters_.setObject(2004, this.updatedColumns_[n - 1]);
        } else {
            Blob blob2 = blob = this.isNull(n) ? null : this.cursor_.getBlob(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getBlob", blob);
        }
        this.setWasNull(n);
        return blob;
    }

    public Clob getClob(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getClob", n);
        }
        this.checkGetterPreconditions(n);
        Clob clob = null;
        if (this.wasNonNullSensitiveUpdate(n)) {
            clob = (Clob)this.agent_.crossConverters_.setObject(2005, this.updatedColumns_[n - 1]);
        } else {
            Clob clob2 = clob = this.isNull(n) ? null : this.cursor_.getClob(n);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getClob", clob);
        }
        this.setWasNull(n);
        return clob;
    }

    public Ref getRef(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getRef", n);
        }
        this.checkGetterPreconditions(n);
        Ref ref = this.isNull(n) ? null : this.cursor_.getRef(n);
        throw new SqlException(this.agent_.logWriter_, "jdbc 2 method not yet implemented");
    }

    public Array getArray(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getArray", n);
        }
        this.checkGetterPreconditions(n);
        Array array = this.isNull(n) ? null : this.cursor_.getArray(n);
        throw new SqlException(this.agent_.logWriter_, "jdbc 2 method not yet implemented");
    }

    public Object getObject(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getObject", n);
        }
        Object object = this.getObjectX(n);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getObject", object);
        }
        return object;
    }

    Object getObjectX(int n) throws SqlException {
        this.checkGetterPreconditions(n);
        Object object = null;
        object = this.wasNonNullSensitiveUpdate(n) ? this.updatedColumns_[n - 1] : (this.isNull(n) ? null : this.cursor_.getObject(n));
        this.setWasNull(n);
        return object;
    }

    public Object getObject(int n, Map map) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getObject", n, (Object)map);
        }
        this.checkGetterPreconditions(n);
        Object object = null;
        object = this.wasNonNullSensitiveUpdate(n) ? this.updatedColumns_[n - 1] : (this.isNull(n) ? null : this.cursor_.getObject(n));
        throw new SqlException(this.agent_.logWriter_, "jdbc 2 method not yet implemented");
    }

    private boolean wasNonNullSensitiveUpdate(int n) {
        return this.updatedColumns_ != null && this.updatedColumns_[n - 1] != null;
    }

    private boolean wasNullSensitiveUpdate(int n) {
        return this.resultSetType_ == 1005 && this.updatedColumns_ != null && this.updatedColumns_[n - 1] == null && this.columnUpdated_[n - 1];
    }

    private void setWasNull(int n) {
        this.wasNull_ = this.wasNullSensitiveUpdate(n) ? 1 : (this.cursor_.isNull_ == null || this.cursor_.isNull_[n - 1] ? 1 : 2);
    }

    private boolean isNull(int n) {
        if (this.wasNullSensitiveUpdate(n)) {
            return true;
        }
        return this.cursor_.isUpdateDeleteHole_ || this.cursor_.isNull_[n - 1];
    }

    public final boolean getBoolean(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBoolean", string);
        }
        return this.getBoolean(this.findColumnX(string));
    }

    public final byte getByte(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getByte", string);
        }
        return this.getByte(this.findColumnX(string));
    }

    public final short getShort(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getShort", string);
        }
        return this.getShort(this.findColumnX(string));
    }

    public final int getInt(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getInt", string);
        }
        return this.getInt(this.findColumnX(string));
    }

    public final long getLong(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getLong", string);
        }
        return this.getLong(this.findColumnX(string));
    }

    public final float getFloat(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getFloat", string);
        }
        return this.getFloat(this.findColumnX(string));
    }

    public final double getDouble(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDouble", string);
        }
        return this.getDouble(this.findColumnX(string));
    }

    public final BigDecimal getBigDecimal(String string, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceDeprecatedEntry((Object)this, "getBigDecimal", string, n);
        }
        return this.getBigDecimal(this.findColumnX(string), n);
    }

    public final BigDecimal getBigDecimal(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBigDecimal", string);
        }
        return this.getBigDecimal(this.findColumnX(string));
    }

    public final Date getDate(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDate", string);
        }
        return this.getDate(this.findColumnX(string));
    }

    public final Date getDate(String string, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDate", (Object)string, (Object)calendar);
        }
        return this.getDate(this.findColumnX(string), calendar);
    }

    public final Time getTime(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTime", string);
        }
        return this.getTime(this.findColumnX(string));
    }

    public final Time getTime(String string, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTime", (Object)string, (Object)calendar);
        }
        return this.getTime(this.findColumnX(string), calendar);
    }

    public final Timestamp getTimestamp(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", string);
        }
        return this.getTimestamp(this.findColumnX(string));
    }

    public final Timestamp getTimestamp(String string, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", (Object)string, (Object)calendar);
        }
        return this.getTimestamp(this.findColumnX(string), calendar);
    }

    public final String getString(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getString", string);
        }
        return this.getString(this.findColumnX(string));
    }

    public final byte[] getBytes(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBytes", string);
        }
        return this.getBytes(this.findColumnX(string));
    }

    public final InputStream getBinaryStream(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBinaryStream", string);
        }
        return this.getBinaryStream(this.findColumnX(string));
    }

    public final InputStream getAsciiStream(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getAsciiStream", string);
        }
        return this.getAsciiStream(this.findColumnX(string));
    }

    public final InputStream getUnicodeStream(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceDeprecatedEntry((Object)this, "getUnicodeStream", string);
        }
        return this.getUnicodeStream(this.findColumnX(string));
    }

    public final Reader getCharacterStream(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getCharacterStream", string);
        }
        return this.getCharacterStream(this.findColumnX(string));
    }

    public final Blob getBlob(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBlob", string);
        }
        return this.getBlob(this.findColumnX(string));
    }

    public final Clob getClob(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getClob", string);
        }
        return this.getClob(this.findColumnX(string));
    }

    public final Array getArray(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getArray", string);
        }
        return this.getArray(this.findColumnX(string));
    }

    public final Ref getRef(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getRef", string);
        }
        return this.getRef(this.findColumnX(string));
    }

    public final Object getObject(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getObject", string);
        }
        return this.getObject(this.findColumnX(string));
    }

    public final Object getObject(String string, Map map) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getObject", (Object)string, (Object)map);
        }
        return this.getObject(this.findColumnX(string), map);
    }

    public final SQLWarning getWarnings() {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        return this.warnings_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearWarnings() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearWarnings");
            }
            this.warnings_ = null;
        }
    }

    public final void clearWarningsX() {
        this.warnings_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCursorName");
            }
            this.checkForClosedResultSet();
            if (this.generatedSection_ != null) {
                return "stored procedure generated cursor:" + this.generatedSection_.getServerCursorName();
            }
            if (this.statement_.cursorName_ == null) {
                this.statement_.cursorName_ = this.statement_.section_.getServerCursorName();
                if (this.statement_.section_ instanceof Section) {
                    this.agent_.sectionManager_.mapCursorNameToQuerySection(this.statement_.cursorName_, this.statement_.section_);
                }
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getCursorName", this.statement_.cursorName_);
            }
            return this.statement_.cursorName_;
        }
    }

    public ResultSetMetaData getMetaData() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getMetaData");
        }
        ColumnMetaData columnMetaData = this.getMetaDataX();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getMetaData", (Object)columnMetaData);
        }
        return columnMetaData;
    }

    ColumnMetaData getMetaDataX() throws SqlException {
        this.checkForClosedResultSet();
        return this.resultSetMetaData_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int findColumn(String string) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "findColumn", string);
            }
            int n = this.findColumnX(string);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "findColumn", n);
            }
            return n;
        }
    }

    private final int findColumnX(String string) throws SqlException {
        this.checkForClosedResultSet();
        return this.resultSetMetaData_.findColumnX(string);
    }

    public boolean isBeforeFirst() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "isBeforeFirst");
        }
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl = this.isBeforeFirstX();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isBeforeFirst", bl);
        }
        return bl;
    }

    private boolean isBeforeFirstX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isBeforeFirst_;
        }
        return this.currentRowInRowset_ == -1L && !this.resultSetContainsNoRows();
    }

    public boolean isAfterLast() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "isAfterLast");
        }
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl = this.isAfterLastX();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isAfterLast", bl);
        }
        return bl;
    }

    private boolean isAfterLastX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isAfterLast_;
        }
        return this.resultSetContainsNoRows() ? false : this.firstRowInRowset_ == this.currentRowInRowset_ && this.currentRowInRowset_ == this.lastRowInRowset_ && this.lastRowInRowset_ == 0L && this.absolutePosition_ == this.rowCount_ + 1L;
    }

    public boolean isFirst() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "isFirst");
        }
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl = this.isFirstX();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isFirst", bl);
        }
        return bl;
    }

    private boolean isFirstX() {
        if (this.sensitivity_ == 3) {
            return this.isFirst_;
        }
        return this.firstRowInRowset_ == 1L && this.currentRowInRowset_ == 0L;
    }

    public boolean isLast() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "isLast");
        }
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl = this.isLastX();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isLast", bl);
        }
        return bl;
    }

    private boolean isLastX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isLast_;
        }
        return this.resultSetContainsNoRows() ? false : this.firstRowInRowset_ + this.currentRowInRowset_ == this.rowCount_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "beforeFirst");
            }
            this.checkForClosedResultSet();
            this.checkThatResultSetTypeIsScrollable();
            this.clearWarningsX();
            this.beforeFirstX();
        }
    }

    private void beforeFirstX() throws SqlException {
        this.resetRowsetFlags();
        if (this.sensitivity_ == 3 || !this.resultSetContainsNoRows() && !this.isServersCursorPositionBeforeFirst()) {
            this.moveToBeforeFirst();
        }
        this.isBeforeFirst_ = true;
        this.setRowsetBeforeFirstEvent();
        this.cursor_.resetDataBuffer();
        this.resetRowsetSqlca();
        this.isValidCursorPosition_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "afterLast");
            }
            this.checkForClosedResultSet();
            this.checkThatResultSetTypeIsScrollable();
            this.clearWarningsX();
            this.afterLastX();
        }
    }

    private void afterLastX() throws SqlException {
        this.resetRowsetFlags();
        if (this.sensitivity_ == 3 || !this.resultSetContainsNoRows() && !this.isServerCursorPositionAfterLast()) {
            this.moveToAfterLast();
        }
        this.isAfterLast_ = true;
        this.setRowsetAfterLastEvent();
        this.cursor_.resetDataBuffer();
        this.resetRowsetSqlca();
        this.isValidCursorPosition_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "first");
            }
            boolean bl = this.firstX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "first", bl);
            }
            return bl;
        }
    }

    private boolean firstX() throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        if (this.rowIsInCurrentRowset(1L, 6)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = 0L;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getFirstRowset();
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.isFirst_ = true;
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "last");
            }
            boolean bl = this.lastX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "last", bl);
            }
            return bl;
        }
    }

    private boolean lastX() throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        long l = this.rowCount_;
        if (this.sensitivity_ != 3 && this.statement_.maxRows_ > 0 && this.rowCount_ > (long)this.statement_.maxRows_) {
            l = this.statement_.maxRows_;
        }
        if (this.rowIsInCurrentRowset(l, 7)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = l - this.firstRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getLastRowset(l);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.isLast_ = true;
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getRow");
            }
            int n = this.getRowX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getRow", n);
            }
            return n;
        }
    }

    private int getRowX() throws SqlException {
        long l;
        this.checkForClosedResultSet();
        this.checkThatResultSetIsNotDynamic();
        if (this.resultSetType_ == 1003) {
            l = this.cursor_.allRowsReceivedFromServer_ && this.cursor_.currentRowPositionIsEqualToNextRowPosition() ? 0L : (long)this.cursor_.rowsRead_;
        } else {
            if (this.rowCountIsUnknown()) {
                this.getRowCount();
            }
            l = this.rowCount_ == 0L || this.currentRowInRowset_ < 0L ? 0L : this.firstRowInRowset_ + this.currentRowInRowset_;
        }
        if (l > Integer.MAX_VALUE) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, "Value too large to fit in an int."));
        }
        return (int)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "absolute", n);
            }
            boolean bl = this.absoluteX(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "absolute", bl);
            }
            return bl;
        }
    }

    public boolean absoluteX(int n) throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        if (this.statement_.maxRows_ > 0) {
            if (n > 0 && n > this.statement_.maxRows_) {
                this.afterLastX();
                this.isValidCursorPosition_ = false;
                return this.isValidCursorPosition_;
            }
            if (n <= 0 && Math.abs(n) > this.statement_.maxRows_) {
                this.beforeFirstX();
                this.isValidCursorPosition_ = false;
                return this.isValidCursorPosition_;
            }
        }
        int n2 = 0;
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        if (this.sensitivity_ == 3) {
            n2 = n;
        } else {
            int n3 = n2 = n >= 0 ? n : (int)(this.rowCount_ + (long)n + 1L);
        }
        if (this.rowIsInCurrentRowset(n2, 2)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = (long)n2 - this.firstRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getAbsoluteRowset(n2);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            if (n == 1) {
                this.isFirst_ = true;
            }
            if (n == -1) {
                this.isLast_ = true;
            }
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "relative", n);
            }
            boolean bl = this.relativeX(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "relative", bl);
            }
            return bl;
        }
    }

    private boolean relativeX(int n) throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        if (this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, "Cursor is Not on a Valid Row");
        }
        if (this.resultSetContainsNoRows()) {
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (n == 0) {
            this.isValidCursorPosition_ = !this.isBeforeFirstX() && !this.isAfterLastX();
            return this.isValidCursorPosition_;
        }
        if (this.isBeforeFirstX()) {
            if (n > 0) {
                this.nextX();
                return this.relativeX(n - 1);
            }
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (this.isAfterLastX()) {
            if (n < 0) {
                this.previousX();
                return this.relativeX(n + 1);
            }
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        this.resetRowsetFlags();
        long l = this.firstRowInRowset_ + this.currentRowInRowset_;
        if (this.sensitivity_ != 3 && this.statement_.maxRows_ > 0 && n > 0 && l + (long)n > (long)this.statement_.maxRows_) {
            this.afterLastX();
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (this.rowIsInCurrentRowset(l + (long)n, 1)) {
            this.currentRowInRowset_ += (long)n;
            this.isValidCursorPosition_ = true;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            long l2 = this.sensitivity_ == 3 ? this.currentRowInRowset_ + (long)n : l + (long)n - this.absolutePosition_;
            this.isValidCursorPosition_ = this.getRelativeRowset(l2);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "previous");
            }
            boolean bl = this.previousX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "previous", bl);
            }
            return bl;
        }
    }

    private boolean previousX() throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.isBeforeFirst_ = false;
        this.isFirst_ = false;
        if (this.rowIsInCurrentRowset(this.firstRowInRowset_ + this.currentRowInRowset_ - 1L, 5)) {
            this.isValidCursorPosition_ = true;
            --this.currentRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getPreviousRowset();
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.checkRowsetSqlca();
            if (this.isAfterLast_) {
                this.isLast_ = true;
            }
        } else {
            return this.isValidCursorPosition_;
        }
        this.isAfterLast_ = false;
        if (this.sensitivity_ != 3 && this.statement_.maxRows_ > 0 && this.firstRowInRowset_ + this.currentRowInRowset_ > (long)this.statement_.maxRows_) {
            this.isValidCursorPosition_ = false;
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setFetchDirection", n);
            }
            this.checkForClosedResultSet();
            this.checkThatResultSetTypeIsScrollable();
            switch (n) {
                case 1000: 
                case 1001: 
                case 1002: {
                    this.fetchDirection_ = n;
                    break;
                }
                default: {
                    throw new SqlException(this.agent_.logWriter_, "Invalid fetch direction " + n);
                }
            }
        }
    }

    public int getFetchDirection() throws SqlException {
        this.checkForClosedResultSet();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getFetchDirection", this.fetchDirection_);
        }
        return this.fetchDirection_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setFetchSize", n);
            }
            this.checkForClosedResultSet();
            if (n < 0 || this.statement_.maxRows_ != 0 && n > this.statement_.maxRows_) {
                throw new SqlException(this.agent_.logWriter_, "Invalid fetch size " + n);
            }
            this.setFetchSize_(n);
        }
    }

    public int getFetchSize() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getFetchSize", this.fetchSize_);
        }
        this.checkForClosedResultSet();
        return this.fetchSize_;
    }

    public int getType() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getType", this.resultSetType_);
        }
        this.checkForClosedResultSet();
        return this.resultSetType_;
    }

    public int getConcurrency() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getConcurrency", this.resultSetConcurrency_);
        }
        this.checkForClosedResultSet();
        return this.resultSetConcurrency_;
    }

    public boolean rowUpdated() throws SqlException {
        boolean bl = false;
        this.checkForClosedResultSet();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "rowUpdated", bl);
        }
        return bl;
    }

    public boolean rowInserted() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "rowInserted");
        }
        this.checkForClosedResultSet();
        throw new SqlException(this.agent_.logWriter_, "under construction");
    }

    public boolean rowDeleted() throws SqlException {
        boolean bl = false;
        this.checkForClosedResultSet();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "rowDeleted", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNull(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateNull", n);
            }
            this.checkUpdatePreconditions(n);
            if (!this.resultSetMetaData_.nullable_[n - 1]) {
                throw new SqlException(this.agent_.logWriter_, "Invalid operation to update a non-nullable column to null.");
            }
            this.updateColumn(n, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoolean(int n, boolean bl) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBoolean", n, bl);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByte(int n, byte by) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateByte", n, by);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], by));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShort(int n, short s) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateShort", n, s);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInt(int n, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateInt", n, n2);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLong(int n, long l) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateLong", n, l);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloat(int n, float f) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateFloat", n, f);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDouble(int n, double d) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateDouble", n, d);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], d));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBigDecimal", n, (Object)bigDecimal);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], bigDecimal));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDate(int n, Date date) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateDate", n, (Object)date);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], date));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTime(int n, Time time) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateTime", n, (Object)time);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], time));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimestamp(int n, Timestamp timestamp) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateTimestamp", n, (Object)timestamp);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], timestamp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(int n, String string) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateString", n, (Object)string);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytes(int n, byte[] byArray) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBytes", n, byArray);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], byArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBinaryStream", n, (Object)inputStream, n2);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObjectFromBinaryStream(this.resultSetMetaData_.types_[n - 1], inputStream, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateAsciiStream", n, (Object)inputStream, n2);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObjectFromCharacterStream(this.resultSetMetaData_.types_[n - 1], inputStream, "US-ASCII", n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCharacterStream(int n, Reader reader, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateCharacterStream", n, (Object)reader, n2);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], reader, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int n, Object object, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateObject", n, object, n2);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int n, Object object) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateObject", n, object);
            }
            this.checkUpdatePreconditions(n);
            this.updateColumn(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n - 1], object));
        }
    }

    public void updateNull(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateNull", string);
        }
        this.updateNull(this.findColumnX(string));
    }

    public void updateBoolean(String string, boolean bl) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateBoolean", (Object)string, bl);
        }
        this.updateBoolean(this.findColumnX(string), bl);
    }

    public void updateByte(String string, byte by) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateByte", (Object)string, by);
        }
        this.updateByte(this.findColumnX(string), by);
    }

    public void updateShort(String string, short s) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateShort", (Object)string, s);
        }
        this.updateShort(this.findColumnX(string), s);
    }

    public void updateInt(String string, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateInt", (Object)string, n);
        }
        this.updateInt(this.findColumnX(string), n);
    }

    public void updateLong(String string, long l) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateLong", (Object)string, l);
        }
        this.updateLong(this.findColumnX(string), l);
    }

    public void updateFloat(String string, float f) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateFloat", (Object)string, f);
        }
        this.updateFloat(this.findColumnX(string), f);
    }

    public void updateDouble(String string, double d) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateDouble", (Object)string, d);
        }
        this.updateDouble(this.findColumnX(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateBigDecimal", (Object)string, (Object)bigDecimal);
        }
        this.updateBigDecimal(this.findColumnX(string), bigDecimal);
    }

    public void updateDate(String string, Date date) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateDate", (Object)string, (Object)date);
        }
        this.updateDate(this.findColumnX(string), date);
    }

    public void updateTime(String string, Time time) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateTime", (Object)string, (Object)time);
        }
        this.updateTime(this.findColumnX(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateTimestamp", (Object)string, (Object)timestamp);
        }
        this.updateTimestamp(this.findColumnX(string), timestamp);
    }

    public void updateString(String string, String string2) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateString", (Object)string, (Object)string2);
        }
        this.updateString(this.findColumnX(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateBytes", (Object)string, (Object)byArray);
        }
        this.updateBytes(this.findColumnX(string), byArray);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateBinaryStream", (Object)string, (Object)inputStream, n);
        }
        this.updateBinaryStream(this.findColumnX(string), inputStream, n);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateAsciiStream", (Object)string, (Object)inputStream, n);
        }
        this.updateAsciiStream(this.findColumnX(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateCharacterStream", (Object)string, (Object)reader, n);
        }
        this.updateCharacterStream(this.findColumnX(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateObject", (Object)string, object, n);
        }
        this.updateObject(this.findColumnX(string), object, n);
    }

    public void updateObject(String string, Object object) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "updateObject", (Object)string, object);
        }
        this.updateObject(this.findColumnX(string), object);
    }

    public void insertRow() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "insertRow");
            }
            this.checkForClosedResultSet();
            throw new SqlException(this.agent_.logWriter_, "Driver not capable: insertRow");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateRow");
            }
            if (this.updateRowX()) {
                this.isValidCursorPosition_ = false;
            }
        }
    }

    private boolean updateRowX() throws SQLException {
        int n;
        this.checkForClosedResultSet();
        if (this.isOnInsertRow_ || this.resultSetConcurrency_ == 1007) {
            throw new SqlException(this.agent_.logWriter_, "This method cannot be invoked while the cursor is on the insert row or if the concurrency of this ResultSet object is CONCUR_READ_ONLY.");
        }
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, "Invalid operation to update at current cursor position");
        }
        if (this.updatedColumns_ == null) {
            return false;
        }
        boolean bl = false;
        for (n = 0; n < this.updatedColumns_.length; ++n) {
            if (!this.columnUpdated_[n]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        this.getPreparedStatementForUpdate();
        n = 0;
        for (int i = 0; i < this.updatedColumns_.length; ++i) {
            if (this.resultSetMetaData_.sqlxUpdatable_[i] != 1 || !this.columnUpdated_[i]) continue;
            ++n;
            if (this.updatedColumns_[i] != null || this.updatedColumns_[i] == null && this.columnUpdated_[i]) {
                this.preparedStatementForUpdate_.setInput(n, this.updatedColumns_[i]);
                continue;
            }
            Object object = this.getObject(i + 1);
            if (object == null) {
                this.preparedStatementForUpdate_.setInput(n, null);
                continue;
            }
            this.preparedStatementForUpdate_.setInput(n, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[i], object));
        }
        try {
            if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
                this.update();
            } else {
                this.positionToCurrentRowAndUpdate();
            }
            this.updateRowCalled_ = true;
        }
        catch (SqlException sqlException) {
            this.cancelRowUpdates();
            throw sqlException;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "deleteRow");
            }
            this.deleteRowX();
            this.isValidCursorPosition_ = false;
        }
    }

    private void deleteRowX() throws SQLException {
        this.checkForClosedResultSet();
        this.resetUpdatedColumns();
        if (this.isOnInsertRow_ || this.resultSetConcurrency_ == 1007) {
            throw new SqlException(this.agent_.logWriter_, "This method cannot be invoked while the cursor is on the insert row or if the concurrency of this ResultSet object is CONCUR_READ_ONLY.");
        }
        if (this.preparedStatementForDelete_ == null) {
            this.getPreparedStatementForDelete();
        }
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            this.delete();
        } else {
            this.positionToCurrentRowAndDelete();
        }
        Boolean bl = Cursor.ROW_IS_NULL;
        if (this.resultSetType_ == 1003) {
            this.cursor_.isUpdateDeleteHole_ = true;
        } else {
            this.cursor_.isUpdateDeleteHoleCache_.set((int)this.currentRowInRowset_, bl);
            this.cursor_.isUpdateDeleteHole_ = (Boolean)this.cursor_.isUpdateDeleteHoleCache_.get((int)this.currentRowInRowset_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "refreshRow");
            }
            this.refreshRowX();
        }
    }

    private void refreshRowX() throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        if (this.isBeforeFirstX() || this.isAfterLastX() || this.isOnInsertRow_ || this.resultSetConcurrency_ == 1007) {
            throw new SqlException(this.agent_.logWriter_, "This method cannot be invoked while the cursor is on the insert row, if the cursor is not on a valid row, or if this ResultSet object has a concurrency of CONCUR_READ_ONLY.");
        }
        if (this.resultSetType_ == 1005) {
            this.isValidCursorPosition_ = this.getRefreshRowset();
            this.cancelRowUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "cancelRowUpdates");
            }
            this.checkForClosedResultSet();
            if (this.isOnInsertRow_ || this.resultSetConcurrency_ == 1007) {
                throw new SqlException(this.agent_.logWriter_, "This method cannot be invoked while the cursor is on the insert row or if this ResultSet object has a concurrency of CONCUR_READ_ONLY.");
            }
            if (!this.isValidCursorPosition_) {
                throw new SqlException(this.agent_.logWriter_, "Invalid operation at current cursor position.");
            }
            if (!this.updateRowCalled_) {
                this.resetUpdatedColumns();
            }
        }
    }

    public void moveToInsertRow() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "moveToInsertRow");
            }
            this.checkForClosedResultSet();
            throw new SqlException(this.agent_.logWriter_, "Driver not capable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "moveToCurrentRow");
            }
            this.checkForClosedResultSet();
            if (this.resultSetConcurrency_ == 1007) {
                throw new SqlException(this.agent_.logWriter_, "This method should only be called on ResultSet objects that are updatable(concurrency type CONCUR_UPDATABLE).");
            }
            if (this.isOnInsertRow_) {
                throw new SqlException(this.agent_.logWriter_, "Driver no capable");
            }
        }
    }

    public java.sql.Statement getStatement() {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getStatement", this.statement_);
        }
        return this.statement_;
    }

    public URL getURL(int n) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public URL getURL(String string) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void updateRef(int n, Ref ref) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void updateRef(String string, Ref ref) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void updateBlob(int n, Blob blob) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void updateBlob(String string, Blob blob) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void updateClob(int n, Clob clob) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void updateClob(String string, Clob clob) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void updateArray(int n, Array array) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void updateArray(String string, Array array) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public boolean repositionScrollableResultSetBeforeJDBC1PositionedUpdateDelete() throws SqlException {
        boolean bl = false;
        long l = this.getRowUncast() - this.absolutePosition_;
        if (l != 0L || this.cursorUnpositionedOnServer_) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_, 1, l);
            this.absolutePosition_ += l;
            bl = true;
        }
        return bl;
    }

    public void flowPositioningFetch(int n, int n2) throws DisconnectException {
        try {
            this.agent_.beginWriteChain(this.statement_);
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_, n, n2);
            this.agent_.flow(this.statement_);
            this.readPositioningFetch_();
            this.agent_.endReadChain();
        }
        catch (SqlException sqlException) {
            throw new DisconnectException(this.agent_, sqlException);
        }
    }

    protected void positionToCurrentRowAndUpdate() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        long l = this.getRowUncast() - this.absolutePosition_;
        if (this.resultSetType_ != 1003 && (l != 0L || l == 0L && this.cursorUnpositionedOnServer_)) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_, 1, l);
        }
        if (!this.preparedStatementForUpdate_.openOnServer_) {
            this.preparedStatementForUpdate_.materialPreparedStatement_.writePrepare_(this.preparedStatementForUpdate_.sql_, this.preparedStatementForUpdate_.section_);
        }
        boolean bl = this.connection_.willAutoCommitGenerateFlow();
        this.writeUpdateRow(bl);
        if (bl) {
            this.connection_.writeCommit();
        }
        this.agent_.flow(this.statement_);
        this.absolutePosition_ += l;
        if (this.resultSetType_ != 1003 && (l != 0L || l == 0L && this.cursorUnpositionedOnServer_)) {
            this.readPositioningFetch_();
            this.cursorUnpositionedOnServer_ = false;
            this.listenToUnitOfWork();
        }
        if (!this.preparedStatementForUpdate_.openOnServer_) {
            this.preparedStatementForUpdate_.materialPreparedStatement_.readPrepare_();
        }
        this.readUpdateRow();
        if (bl) {
            this.connection_.readCommit();
        }
        this.agent_.endReadChain();
    }

    protected void update() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        if (!this.preparedStatementForUpdate_.openOnServer_) {
            this.preparedStatementForUpdate_.materialPreparedStatement_.writePrepare_(this.preparedStatementForUpdate_.sql_, this.preparedStatementForUpdate_.section_);
        }
        if (this.isRowsetCursor_) {
            this.preparedStatementForUpdate_.setInt(this.updatedColumns_.length + 1, (int)(this.currentRowInRowset_ + 1L));
        }
        boolean bl = this.connection_.willAutoCommitGenerateFlow();
        this.writeUpdateRow(bl);
        if (bl) {
            this.connection_.writeCommit();
        }
        this.agent_.flow(this.statement_);
        if (!this.preparedStatementForUpdate_.openOnServer_) {
            this.preparedStatementForUpdate_.materialPreparedStatement_.readPrepare_();
        }
        this.readUpdateRow();
        if (bl) {
            this.connection_.readCommit();
        }
        this.agent_.endReadChain();
    }

    protected void positionToCurrentRowAndDelete() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        long l = this.getRowUncast() - this.absolutePosition_;
        if (this.resultSetType_ != 1003 && (l != 0L || l == 0L && this.cursorUnpositionedOnServer_)) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_, 1, l);
        }
        if (!this.preparedStatementForDelete_.openOnServer_) {
            this.preparedStatementForDelete_.materialPreparedStatement_.writePrepare_(this.preparedStatementForDelete_.sql_, this.preparedStatementForDelete_.section_);
        }
        this.writeDeleteRow();
        if (this.connection_.autoCommit_) {
            this.connection_.writeAutoCommit();
        }
        this.agent_.flow(this.statement_);
        this.absolutePosition_ += l;
        if (this.resultSetType_ != 1003 && (l != 0L || l == 0L && this.cursorUnpositionedOnServer_)) {
            this.readPositioningFetch_();
            this.cursorUnpositionedOnServer_ = false;
            this.listenToUnitOfWork();
        }
        if (!this.preparedStatementForDelete_.openOnServer_) {
            this.preparedStatementForDelete_.materialPreparedStatement_.readPrepare_();
        }
        this.readDeleteRow();
        if (this.connection_.autoCommit_) {
            this.connection_.readAutoCommit();
        }
        this.agent_.endReadChain();
    }

    protected void delete() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        if (!this.preparedStatementForDelete_.openOnServer_) {
            this.preparedStatementForDelete_.materialPreparedStatement_.writePrepare_(this.preparedStatementForDelete_.sql_, this.preparedStatementForDelete_.section_);
        }
        if (this.isRowsetCursor_) {
            this.preparedStatementForDelete_.setInt(1, (int)(this.currentRowInRowset_ + 1L));
        }
        this.writeDeleteRow();
        if (this.connection_.autoCommit_) {
            this.connection_.writeAutoCommit();
        }
        this.agent_.flow(this.statement_);
        if (!this.preparedStatementForDelete_.openOnServer_) {
            this.preparedStatementForDelete_.materialPreparedStatement_.readPrepare_();
        }
        this.readDeleteRow();
        if (this.connection_.autoCommit_) {
            this.connection_.readAutoCommit();
        }
        this.agent_.endReadChain();
    }

    public void setRowsetAfterLastEvent() throws SqlException {
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = this.rowCount_ + 1L;
        this.currentRowInRowset_ = 0L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    public void setRowsetBeforeFirstEvent() throws SqlException {
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = 0L;
        this.currentRowInRowset_ = -1L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    public void setRowsetNoRowsEvent() {
        this.rowCount_ = 0L;
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = 0L;
        this.currentRowInRowset_ = -1L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    private boolean isServersCursorPositionBeforeFirst() throws SqlException {
        return this.isBeforeFirstX() && this.firstRowInRowset_ == 0L && this.lastRowInRowset_ == 0L && this.absolutePosition_ == 0L;
    }

    private boolean isServerCursorPositionAfterLast() throws SqlException {
        return this.absolutePosition_ == this.rowCount_ + 1L;
    }

    public void setValidCursorPosition(boolean bl) {
        this.isValidCursorPosition_ = bl;
    }

    protected void moveToAfterLast() throws DisconnectException {
        this.flowPositioningFetch(3, 0);
    }

    protected void moveToBeforeFirst() throws DisconnectException {
        this.flowPositioningFetch(4, 0);
    }

    public void flowFetch() throws DisconnectException, SqlException {
        this.agent_.beginWriteChain(this.statement_);
        this.writeFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_);
        this.agent_.flow(this.statement_);
        this.readFetch_();
        this.agent_.endReadChain();
    }

    public void writeUpdateRow(boolean bl) throws SqlException {
        this.preparedStatementForUpdate_.materialPreparedStatement_.writeExecute_(this.preparedStatementForUpdate_.section_, this.preparedStatementForUpdate_.parameterMetaData_, this.preparedStatementForUpdate_.parameters_, this.preparedStatementForUpdate_.parameterMetaData_.getColumnCount(), false, bl);
    }

    public void writeDeleteRow() throws SqlException {
        if (this.isRowsetCursor_) {
            this.preparedStatementForDelete_.materialPreparedStatement_.writeExecute_(this.preparedStatementForDelete_.section_, this.preparedStatementForDelete_.parameterMetaData_, this.preparedStatementForDelete_.parameters_, this.preparedStatementForDelete_.parameterMetaData_.getColumnCount(), false, false);
        } else {
            this.preparedStatementForDelete_.materialPreparedStatement_.writeExecute_(this.preparedStatementForDelete_.section_, null, null, 0, false, false);
        }
    }

    public void readUpdateRow() throws DisconnectException, SqlException {
        this.preparedStatementForUpdate_.materialPreparedStatement_.readExecute_();
    }

    public void readDeleteRow() throws DisconnectException, SqlException {
        this.preparedStatementForDelete_.materialPreparedStatement_.readExecute_();
    }

    public void listenToUnitOfWork() {
        if (!this.listenToUnitOfWork_) {
            this.listenToUnitOfWork_ = true;
            this.connection_.CommitAndRollbackListeners_.add(this);
        }
    }

    public void completeLocalCommit(Iterator iterator) {
        this.cursorUnpositionedOnServer_ = true;
        this.markAutoCommitted();
        if (!this.cursorHold_) {
            this.markClosed();
            this.nullOutReferenceInStatement();
            iterator.remove();
            this.listenToUnitOfWork_ = false;
        }
    }

    public void completeLocalRollback(Iterator iterator) {
        this.markAutoCommitted();
        this.markClosed();
        this.nullOutReferenceInStatement();
        iterator.remove();
        this.listenToUnitOfWork_ = false;
    }

    private void nullOutReferenceInStatement() {
        if (this.statement_.resultSet_ == this) {
            this.statement_.resultSet_ = null;
        }
        if (this.statement_.resultSetList_ != null) {
            for (int i = 0; i < this.statement_.resultSetList_.length; ++i) {
                if (this.statement_.resultSetList_[i] != this) continue;
                this.statement_.resultSetList_[i] = null;
            }
        }
    }

    void markClosed() {
        this.openOnClient_ = false;
        this.openOnServer_ = false;
        this.statement_.resetCursorNameAndRemoveFromWhereCurrentOfMappings();
        this.statement_.removeClientCursorNameFromCache();
        this.markPositionedUpdateDeletePreparedStatementsClosed();
    }

    void markClosedOnServer() {
        this.openOnServer_ = false;
    }

    void markAutoCommitted() {
        this.autoCommitted_ = true;
    }

    public void earlyCloseComplete(Sqlca sqlca) {
        this.markClosedOnServer();
        this.queryTerminatingSqlca_ = sqlca;
        this.cursor_.setAllRowsReceivedFromServer(true);
    }

    public int completeSqlca(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        int n = sqlca.getSqlCode();
        if (n == 100 || n == 20237) {
            this.cursor_.setAllRowsReceivedFromServer(true);
        } else if (n < 0) {
            this.connection_.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
        } else if (n > 0) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
        }
        return n;
    }

    public void setCloseOnlyStateForSingletonCursors() {
        this.markClosedOnServer();
    }

    public void setAutoCommitStateForSingletonCursors() {
        if (this.connection_.autoCommit_) {
            this.markAutoCommitted();
        }
    }

    public void setRowCountEvent(long l) throws DisconnectException {
        if (this.rowCount_ == -1L) {
            this.rowCount_ = l;
        }
    }

    public void accumulateWarning(SqlWarning sqlWarning) {
        if (this.warnings_ == null) {
            this.warnings_ = sqlWarning;
        } else {
            this.warnings_.setNextException(sqlWarning);
        }
    }

    protected boolean rowCountIsUnknown() {
        if (this.sensitivity_ == 3) {
            return false;
        }
        return this.rowCount_ == -1L;
    }

    protected boolean rowCountIsKnown() {
        return this.rowCount_ != -1L;
    }

    private void updateColumn(int n, Object object) {
        if (this.updatedColumns_ == null) {
            this.updatedColumns_ = new Object[this.resultSetMetaData_.columns_];
        }
        if (this.columnUpdated_ == null) {
            this.columnUpdated_ = new boolean[this.resultSetMetaData_.columns_];
        }
        this.updatedColumns_[n - 1] = object;
        this.columnUpdated_[n - 1] = true;
    }

    private String buildUpdateString() throws SqlException {
        int n = 0;
        boolean bl = false;
        String string = "UPDATE " + this.getTableName() + " SET ";
        for (int i = 1; i <= this.resultSetMetaData_.columns_; ++i) {
            if (!this.columnUpdated_[i - 1]) continue;
            if (bl) {
                string = string + ",";
            }
            string = string + "\"" + this.resultSetMetaData_.getColumnName(i) + "\" = ? ";
            ++n;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        string = string + " WHERE CURRENT OF " + this.getServerCursorName();
        if (this.isRowsetCursor_) {
            string = string + " FOR ROW ? OF ROWSET";
        }
        return string;
    }

    private String buildDeleteString() throws SqlException {
        String string = "DELETE FROM ";
        string = string + this.getTableName() + " WHERE CURRENT OF \"" + this.getServerCursorName() + "\"";
        if (this.isRowsetCursor_) {
            string = string + " FOR ROW ? OF ROWSET";
        }
        return string;
    }

    private String getTableName() throws SqlException {
        int n;
        String string = "";
        int n2 = this.resultSetMetaData_.getColumnCount();
        for (n = 0; n < n2 && this.resultSetMetaData_.sqlxBasename_[n] == null; ++n) {
        }
        if (n == n2) {
            n = 0;
        }
        if (this.resultSetMetaData_.sqlxSchema_[n] != null && !this.resultSetMetaData_.sqlxSchema_[n].equals("")) {
            string = string + "\"" + this.resultSetMetaData_.sqlxSchema_[n] + "\".";
        }
        if (this.resultSetMetaData_.sqlxBasename_[n] != null) {
            string = string + "\"" + this.resultSetMetaData_.sqlxBasename_[n] + "\"";
        }
        return string;
    }

    private String getServerCursorName() throws SqlException {
        return this.statement_.section_.getServerCursorName();
    }

    private void getPreparedStatementForUpdate() throws SQLException {
        String string = this.buildUpdateString();
        if (string == null) {
            throw new SqlException(this.agent_.logWriter_, "No updateXXX issued on this row.");
        }
        this.preparedStatementForUpdate_ = this.statement_.connection_.preparePositionedUpdateStatement(string, this.statement_.section_.getPositionedUpdateSection());
    }

    private void getPreparedStatementForDelete() throws SQLException {
        String string = this.buildDeleteString();
        this.preparedStatementForDelete_ = this.statement_.connection_.preparePositionedUpdateStatement(string, this.statement_.section_.getPositionedUpdateSection());
    }

    private final void resetUpdatedColumns() {
        int n;
        if (this.updatedColumns_ != null) {
            for (n = 0; n < this.updatedColumns_.length; ++n) {
                this.updatedColumns_[n] = null;
            }
        }
        if (this.columnUpdated_ != null) {
            for (n = 0; n < this.columnUpdated_.length; ++n) {
                this.columnUpdated_[n] = false;
            }
        }
        this.updateRowCalled_ = false;
    }

    private final long getRowUncast() {
        return this.firstRowInRowset_ + this.currentRowInRowset_;
    }

    private final void checkGetterPreconditions(int n) throws SqlException {
        this.checkForClosedResultSet();
        this.checkForValidColumnIndex(n);
        this.checkForValidCursorPosition();
    }

    private final void checkUpdatePreconditions(int n) throws SqlException {
        this.checkForClosedResultSet();
        this.checkForValidColumnIndex(n);
        if (this.resultSetConcurrency_ != 1008) {
            throw new SqlException(this.agent_.logWriter_, "ResultSet is not updatable.");
        }
        if (!this.isOnCurrentRow_ && !this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, "This method must be called to update values in the current row or the insert row");
        }
        if (this.resultSetMetaData_.sqlxUpdatable_ == null || this.resultSetMetaData_.sqlxUpdatable_[n - 1] != 1) {
            throw new SqlException(this.agent_.logWriter_, "Column not updatable");
        }
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, "Invalid operation to update at current cursor position");
        }
    }

    final void checkForValidColumnIndex(int n) throws SqlException {
        if (n < 1 || n > this.resultSetMetaData_.columns_) {
            throw new SqlException(this.agent_.logWriter_, "Invalid argument: parameter index " + n + " is out of range.");
        }
    }

    protected final void checkForClosedResultSet() throws SqlException {
        if (!this.openOnClient_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, "Invalid operation: result set closed");
        }
        this.agent_.checkForDeferredExceptions();
    }

    private final void checkForValidCursorPosition() throws SqlException {
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, "Invalid operation to read at current cursor position.");
        }
    }

    private final void checkThatResultSetTypeIsScrollable() throws SqlException {
        if (this.resultSetType_ == 1003) {
            throw new SqlException(this.agent_.logWriter_, "This method should only be called on ResultSet objects that are scrollable(type TYPE_SCROLL_SENSITIVE or TYPE_SCROLL_INSENSITIVE)");
        }
    }

    private final void checkThatResultSetIsNotDynamic() throws SqlException {
        if (this.sensitivity_ == 3) {
            throw new SqlException(this.agent_.logWriter_, "This method should not be called on sensitive dynamic cursors.");
        }
    }

    private boolean resultSetContainsNoRows() throws SqlException {
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        return this.rowCount_ == 0L;
    }

    private boolean rowIsInCurrentRowset(long l, int n) throws SqlException {
        if (this.sensitivity_ == 3) {
            switch (n) {
                case 0: {
                    if (this.isAfterLast_) {
                        return false;
                    }
                    return this.currentRowInRowset_ + 1L < (long)this.rowsReceivedInCurrentRowset_;
                }
                case 5: {
                    if (this.isBeforeFirst_) {
                        return false;
                    }
                    return this.currentRowInRowset_ - 1L >= 0L;
                }
                case 1: {
                    return l < (long)this.rowsReceivedInCurrentRowset_ && l >= 0L;
                }
                case 2: 
                case 6: 
                case 7: {
                    return false;
                }
            }
            return false;
        }
        return this.rowIsInCurrentRowset(l);
    }

    private boolean rowIsInCurrentRowset(long l) throws SqlException {
        if (this.firstRowInRowset_ == this.lastRowInRowset_ && this.firstRowInRowset_ == 0L) {
            return false;
        }
        return l >= this.firstRowInRowset_ && l <= this.lastRowInRowset_;
    }

    private void markPositionedUpdateDeletePreparedStatementsClosed() {
        if (this.preparedStatementForUpdate_ != null) {
            this.preparedStatementForUpdate_.markClosed();
            this.preparedStatementForUpdate_ = null;
        }
        if (this.preparedStatementForDelete_ != null) {
            this.preparedStatementForDelete_.markClosed();
            this.preparedStatementForDelete_ = null;
        }
    }

    protected void updateColumnInfoFromCache() {
        this.cursor_.columnDataPosition_ = (int[])this.cursor_.columnDataPositionCache_.get((int)this.currentRowInRowset_);
        this.cursor_.columnDataComputedLength_ = (int[])this.cursor_.columnDataLengthCache_.get((int)this.currentRowInRowset_);
        this.cursor_.isNull_ = (boolean[])this.cursor_.columnDataIsNullCache_.get((int)this.currentRowInRowset_);
        this.cursor_.isUpdateDeleteHole_ = (Boolean)this.cursor_.isUpdateDeleteHoleCache_.get((int)this.currentRowInRowset_);
    }

    protected final void checkAndThrowReceivedQueryTerminatingException() throws SqlException {
        if (!this.openOnServer_) {
            SQLException sQLException = null;
            int n = Utils.getSqlcodeFromSqlca(this.queryTerminatingSqlca_);
            if (n < 0) {
                sQLException = new SqlException(this.agent_.logWriter_, this.queryTerminatingSqlca_);
            } else if (n > 0 && n != 100) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, this.queryTerminatingSqlca_));
            }
            try {
                this.closeX();
            }
            catch (SqlException sqlException) {
                sQLException.setNextException(sqlException);
            }
            if (sQLException != null) {
                throw sQLException;
            }
        }
    }

    public void parseScrollableRowset() throws SqlException {
        if (this.cursor_.dataBufferHasUnprocessedData() && this.scrollable_) {
            this.parseRowset_();
            this.adjustFirstRowset();
            if (this.cursor_.allRowsReceivedFromServer_ && this.rowsReceivedInCurrentRowset_ == 0) {
                this.setRowsetNoRowsEvent();
            }
        }
    }

    public byte getRSReturnability() {
        return this.rsReturnability_;
    }

    public void setRSReturnability(byte by) {
        this.rsReturnability_ = by == 1 || by == 2 ? by : (byte)1;
    }

    protected void getRowCount() throws SqlException {
        this.checkAndThrowReceivedQueryTerminatingException();
        this.agent_.beginWriteChain(this.statement_);
        Section section = this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_;
        this.writePositioningFetch_(section, 3, 0L);
        if (this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L) {
            this.writePositioningFetch_(section, 2, this.firstRowInRowset_);
        }
        this.agent_.flow(this.statement_);
        this.readPositioningFetch_();
        if (this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L) {
            this.readPositioningFetch_();
        }
        this.agent_.endReadChain();
        if (this.rowCount_ == -1L) {
            this.checkAndThrowReceivedQueryTerminatingException();
        }
        this.absolutePosition_ = this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L ? this.firstRowInRowset_ : this.rowCount_ + 1L;
    }

    private void flowGetRowset(int n, long l) throws SqlException {
        this.cursor_.resetDataBuffer();
        this.agent_.beginWriteChain(this.statement_);
        this.writeScrollableFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_, this.fetchSize_, n, l, true);
        this.rowsReceivedInCurrentRowset_ = 0;
        this.agent_.flow(this.statement_);
        this.readScrollableFetch_();
        this.agent_.endReadChain();
    }

    private boolean getNextRowset() throws SqlException {
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            int n = this.checkRowsetSqlca((int)this.currentRowInRowset_ + 2);
            if (n == 100) {
                this.isAfterLast_ = true;
                return false;
            }
            this.flowGetRowset(0, 0L);
        } else {
            if (this.resultSetContainsNoRows() || this.isAfterLastX()) {
                return false;
            }
            if (this.firstRowInRowset_ + this.currentRowInRowset_ == this.lastRowInRowset_ && this.cursor_.allRowsReceivedFromServer_) {
                this.isAfterLast_ = true;
                this.setRowsetAfterLastEvent();
                return false;
            }
            long l = 1L;
            int n = 1;
            if (this.absolutePosition_ < this.lastRowInRowset_) {
                l = this.lastRowInRowset_ - this.absolutePosition_ + 1L;
                this.absolutePosition_ = this.lastRowInRowset_;
            } else if (this.absolutePosition_ > this.lastRowInRowset_) {
                l = this.lastRowInRowset_ + 1L;
                n = 2;
            }
            this.flowGetRowset(n, l);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer_) {
            this.isAfterLast_ = true;
            this.setRowsetAfterLastEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustNextRowset();
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustNextRowset() {
        this.firstRowInRowset_ = this.lastRowInRowset_ + 1L;
        this.lastRowInRowset_ += (long)this.rowsReceivedInCurrentRowset_;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getPreviousRowset() throws SqlException {
        int n = 1;
        long l = 0L;
        boolean bl = false;
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            if (this.currentRowInRowset_ == 0L && this.rowsetSqlca_ != null && this.rowsetSqlca_[0] != null && this.rowsetSqlca_[0].getSqlCode() == 20237) {
                this.isBeforeFirst_ = true;
                this.setRowsetBeforeFirstEvent();
                return false;
            }
            this.flowGetRowset(5, 0L);
        } else {
            if (this.resultSetContainsNoRows() || this.isBeforeFirstX()) {
                return false;
            }
            l = this.firstRowInRowset_ - this.absolutePosition_ - (long)this.fetchSize_;
            bl = this.isAfterLastX();
            if (this.isFirstX()) {
                l = 0L;
                n = 2;
            } else if (bl) {
                l = -1 * this.fetchSize_;
            }
            if (l * -1L >= this.absolutePosition_) {
                l = 1L;
                n = 2;
            }
            this.flowGetRowset(n, l);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer_) {
            this.isBeforeFirst_ = true;
            this.setRowsetBeforeFirstEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustPreviousRowset(n, l, bl);
        } else {
            this.currentRowInRowset_ = this.rowsReceivedInCurrentRowset_ - 1;
        }
        return true;
    }

    private void adjustPreviousRowset(int n, long l, boolean bl) throws SqlException {
        if (n == 2 && l == 1L) {
            this.currentRowInRowset_ = bl ? this.absolutePosition_ - 2L : this.firstRowInRowset_ - 2L;
            this.firstRowInRowset_ = 1L;
            this.lastRowInRowset_ = this.rowsReceivedInCurrentRowset_;
            this.absolutePosition_ = bl ? this.lastRowInRowset_ + 1L : this.lastRowInRowset_;
        } else {
            this.lastRowInRowset_ = bl ? this.rowCount_ : this.firstRowInRowset_ - 1L;
            this.firstRowInRowset_ = this.lastRowInRowset_ - (long)this.rowsReceivedInCurrentRowset_ + 1L;
            this.absolutePosition_ = this.lastRowInRowset_;
            this.currentRowInRowset_ = this.lastRowInRowset_ - this.firstRowInRowset_;
        }
    }

    private boolean getAbsoluteRowset(long l) throws SqlException {
        int n = 2;
        if (this.isRowsetCursor_ && l == 0L) {
            n = 4;
        } else if (this.sensitivity_ != 3 && l < 0L) {
            l = 0L;
        }
        this.flowGetRowset(n, l);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer_ || n == 4) {
            if (l > 0L) {
                this.setRowsetAfterLastEvent();
                this.isAfterLast_ = true;
            } else {
                this.setRowsetBeforeFirstEvent();
                this.isBeforeFirst_ = true;
            }
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustAbsoluteRowset(l);
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustAbsoluteRowset(long l) {
        this.firstRowInRowset_ = l;
        this.lastRowInRowset_ = this.firstRowInRowset_ + (long)this.rowsReceivedInCurrentRowset_ - 1L;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getRelativeRowset(long l) throws SqlException {
        if (l == 0L && (this.cursor_.allRowsReceivedFromServer_ || this.absolutePosition_ > this.rowCount_)) {
            this.setRowsetAfterLastEvent();
            this.isAfterLast_ = true;
            return false;
        }
        this.flowGetRowset(1, l);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer_) {
            if (l > 0L) {
                this.setRowsetAfterLastEvent();
                this.isAfterLast_ = true;
            } else {
                this.setRowsetBeforeFirstEvent();
                this.isBeforeFirst_ = true;
            }
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustRelativeRowset(l);
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustRelativeRowset(long l) {
        this.firstRowInRowset_ = this.absolutePosition_ + l;
        this.lastRowInRowset_ = this.firstRowInRowset_ + (long)this.rowsReceivedInCurrentRowset_ - 1L;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getFirstRowset() throws SqlException {
        this.flowGetRowset(2, 1L);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer_) {
            this.resetRowsetFlags();
            this.setRowsetNoRowsEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustFirstRowset();
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustFirstRowset() {
        this.firstRowInRowset_ = 1L;
        this.lastRowInRowset_ = this.rowsReceivedInCurrentRowset_;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getLastRowset(long l) throws SqlException {
        if (this.sensitivity_ != 3 && this.rowCount_ == 0L) {
            this.isAfterLast_ = false;
            this.isBeforeFirst_ = false;
            this.setRowsetNoRowsEvent();
            return false;
        }
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            this.flowGetRowset(7, 0L);
        } else {
            long l2 = (long)this.fetchSize_ < l ? (long)(-1 * this.fetchSize_) : 1L;
            this.flowGetRowset(2, l2);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer_) {
            this.isAfterLast_ = true;
            this.setRowsetAfterLastEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustLastRowset(l);
        } else {
            this.currentRowInRowset_ = this.rowsReceivedInCurrentRowset_ - 1;
        }
        return true;
    }

    private void adjustLastRowset(long l) {
        this.lastRowInRowset_ = l;
        this.firstRowInRowset_ = this.lastRowInRowset_ - (long)this.rowsReceivedInCurrentRowset_ + 1L;
        this.setAbsolutePositionBasedOnAllRowsReceived();
        this.currentRowInRowset_ = this.lastRowInRowset_ - this.firstRowInRowset_;
    }

    private boolean getRefreshRowset() throws SqlException {
        if (this.isRowsetCursor_) {
            this.flowGetRowset(8, 0L);
        } else {
            this.flowGetRowset(1, -1L * (this.absolutePosition_ - this.firstRowInRowset_));
        }
        this.parseRowset_();
        if (this.sensitivity_ != 3) {
            this.adjustRefreshRowset();
        }
        return true;
    }

    private void adjustRefreshRowset() {
        this.setAbsolutePositionBasedOnAllRowsReceived();
        this.updateColumnInfoFromCache();
    }

    private void setAbsolutePositionBasedOnAllRowsReceived() {
        this.absolutePosition_ = this.cursor_.allRowsReceivedFromServer_ ? this.lastRowInRowset_ + 1L : this.lastRowInRowset_;
    }

    public abstract void writeFetch_(Section var1) throws SqlException;

    public abstract void readFetch_() throws SqlException;

    public abstract void writeScrollableFetch_(Section var1, int var2, int var3, long var4, boolean var6) throws SqlException;

    public abstract void readScrollableFetch_() throws SqlException;

    public abstract void writePositioningFetch_(Section var1, int var2, long var3) throws SqlException;

    public abstract void readPositioningFetch_() throws SqlException;

    public abstract void writeCursorClose_(Section var1) throws SqlException;

    public abstract void readCursorClose_() throws SqlException;

    protected abstract void parseRowset_() throws SqlException;

    public abstract void setFetchSize_(int var1);

    public ConnectionCallbackInterface getConnectionCallbackInterface() {
        return this.connection_;
    }

    public StatementCallbackInterface getStatementCallbackInterface() {
        return this.statement_;
    }

    public void expandRowsetSqlca() {
        if (this.isRowsetCursor_ && (this.rowsetSqlca_ == null || this.rowsetSqlca_.length < this.fetchSize_ + 2)) {
            this.rowsetSqlca_ = new Sqlca[this.fetchSize_ + 2];
        }
    }

    private final int checkRowsetSqlca() throws SqlException {
        return this.checkRowsetSqlca((int)this.currentRowInRowset_ + 1);
    }

    private final int checkRowsetSqlca(int n) throws SqlException {
        int n2 = 0;
        if (!this.isRowsetCursor_ || this.rowsetSqlca_ == null || this.rowsetSqlca_[n] == null) {
            this.warnings_ = null;
            return n2;
        }
        Sqlca sqlca = this.rowsetSqlca_[n];
        if (sqlca != null) {
            n2 = sqlca.getSqlCode();
            if (n2 < 0) {
                throw new SqlException(this.agent_.logWriter_, sqlca);
            }
            if (n2 > 0 && n2 != 100 && n2 != 20237) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            }
        }
        return n2;
    }

    private void resetRowsetFlags() {
        this.isBeforeFirst_ = false;
        this.isAfterLast_ = false;
        this.isFirst_ = false;
        this.isLast_ = false;
    }

    private void resetRowsetSqlca() {
        if (this.rowsetSqlca_ != null) {
            for (int i = 0; i < this.rowsetSqlca_.length; ++i) {
                this.rowsetSqlca_[i] = null;
            }
        }
    }
}

