/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.transaction;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.transaction.UserTransaction;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.api.provider.DependentProvider;
import org.apache.deltaspike.core.impl.util.JndiUtils;
import org.apache.deltaspike.jpa.api.config.base.JpaBaseConfig;
import org.apache.deltaspike.jpa.impl.transaction.ManagedUserTransactionResolver;

@Dependent
public class UserTransactionResolver
implements Serializable {
    private static final long serialVersionUID = -1432802805095533499L;
    @Inject
    private BeanManager beanManager;

    public UserTransaction resolveUserTransaction() {
        String[] jndiNames;
        UserTransaction userTransaction;
        try {
            DependentProvider provider = BeanProvider.getDependent((BeanManager)this.beanManager, ManagedUserTransactionResolver.class, (Annotation[])new Annotation[0]);
            userTransaction = ((ManagedUserTransactionResolver)provider.get()).resolveUserTransaction();
            provider.destroy();
        }
        catch (Throwable t) {
            userTransaction = null;
        }
        if (userTransaction != null) {
            return userTransaction;
        }
        String jndiName = JpaBaseConfig.UserTransaction.JNDI_NAME;
        for (String currentJndiName : jndiNames = jndiName.split(",")) {
            try {
                userTransaction = (UserTransaction)JndiUtils.lookup((String)currentJndiName, UserTransaction.class);
                if (userTransaction == null) continue;
                break;
            }
            catch (Exception e) {
                userTransaction = null;
            }
        }
        return userTransaction;
    }
}

