/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.transaction;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.jpa.api.transaction.Transactional;
import org.apache.deltaspike.jpa.impl.entitymanager.EntityManagerMetadata;
import org.apache.deltaspike.jpa.impl.transaction.TransactionStrategyHelper;
import org.apache.deltaspike.jpa.impl.transaction.context.EntityManagerEntry;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionBeanStorage;
import org.apache.deltaspike.jpa.spi.entitymanager.ActiveEntityManagerHolder;
import org.apache.deltaspike.jpa.spi.entitymanager.QualifierBackedEntityManagerResolver;
import org.apache.deltaspike.jpa.spi.transaction.TransactionStrategy;

@Dependent
public class ResourceLocalTransactionStrategy
implements TransactionStrategy {
    private static final long serialVersionUID = -1432802805095533499L;
    private static final Logger LOGGER = Logger.getLogger(ResourceLocalTransactionStrategy.class.getName());
    @Inject
    private BeanManager beanManager;
    @Inject
    private TransactionStrategyHelper transactionHelper;
    @Inject
    private ActiveEntityManagerHolder emHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(InvocationContext invocationContext) throws Exception {
        boolean commitFailed;
        Object i$;
        Exception firstException;
        TransactionBeanStorage transactionBeanStorage;
        block39: {
            block40: {
                EntityTransaction transaction;
                boolean rollbackOnly;
                Set<EntityManagerEntry> entityManagerEntryList;
                EntityManagerMetadata metadata = this.transactionHelper.createEntityManagerMetadata(invocationContext);
                Transactional transactionalAnnotation = this.transactionHelper.extractTransactionalAnnotation(invocationContext);
                Class targetClass = ProxyUtils.getUnproxiedClass(invocationContext.getTarget().getClass());
                Set<Class<Object>> emQualifiers = this.emHolder.isSet() ? new HashSet<Class>(Arrays.asList(Default.class)) : this.transactionHelper.resolveEntityManagerQualifiers(metadata, targetClass);
                transactionBeanStorage = TransactionBeanStorage.getInstance();
                boolean isOutermostInterceptor = transactionBeanStorage.isEmpty();
                boolean outermostTransactionAlreadyExisted = false;
                if (isOutermostInterceptor) {
                    transactionBeanStorage.startTransactionScope();
                }
                int transactionLayer = transactionBeanStorage.incrementRefCounter();
                firstException = null;
                try {
                    for (Class<Object> emQualifier : emQualifiers) {
                        EntityManager entityManager = this.resolveEntityManagerForQualifier(emQualifier);
                        EntityManagerEntry entityManagerEntry = this.createEntityManagerEntry(entityManager, emQualifier);
                        transactionBeanStorage.storeUsedEntityManager(entityManagerEntry);
                        EntityTransaction transaction2 = this.getTransaction(entityManagerEntry);
                        if (!transaction2.isActive()) {
                            this.beforeBegin(invocationContext, entityManagerEntry, transaction2);
                            transaction2.begin();
                        } else if (isOutermostInterceptor) {
                            outermostTransactionAlreadyExisted = true;
                        }
                        this.beforeProceed(invocationContext, entityManagerEntry, transaction2);
                    }
                    i$ = invocationContext.proceed();
                    commitFailed = false;
                    if (!isOutermostInterceptor) break block39;
                    if (outermostTransactionAlreadyExisted || firstException != null) break block40;
                    entityManagerEntryList = transactionBeanStorage.getUsedEntityManagerEntries();
                    boolean bl = rollbackOnly = metadata.isReadOnly() || this.isRollbackOnly(transactionalAnnotation);
                }
                catch (Exception e) {
                    try {
                        firstException = e;
                        if (isOutermostInterceptor) {
                            Set<EntityManagerEntry> entityManagerEntryList2 = transactionBeanStorage.getUsedEntityManagerEntries();
                            if (!outermostTransactionAlreadyExisted) {
                                this.rollbackAllTransactions(entityManagerEntryList2);
                            }
                            transactionBeanStorage.cleanUsedEntityManagers();
                        }
                        e = this.prepareException(e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        boolean commitFailed2 = false;
                        if (isOutermostInterceptor) {
                            if (!outermostTransactionAlreadyExisted && firstException == null) {
                                EntityTransaction transaction3;
                                boolean rollbackOnly2;
                                Set<EntityManagerEntry> entityManagerEntryList3 = transactionBeanStorage.getUsedEntityManagerEntries();
                                boolean bl = rollbackOnly2 = metadata.isReadOnly() || this.isRollbackOnly(transactionalAnnotation);
                                if (!rollbackOnly2 && entityManagerEntryList3.size() > 1) {
                                    for (EntityManagerEntry currentEntityManagerEntry : entityManagerEntryList3) {
                                        transaction3 = this.getTransaction(currentEntityManagerEntry);
                                        if (transaction3 == null || !transaction3.isActive()) continue;
                                        try {
                                            if (commitFailed2) continue;
                                            currentEntityManagerEntry.getEntityManager().flush();
                                            if (rollbackOnly2 || !transaction3.getRollbackOnly()) continue;
                                            rollbackOnly2 = true;
                                        }
                                        catch (Exception e2) {
                                            firstException = e2;
                                            commitFailed2 = true;
                                            break;
                                        }
                                    }
                                }
                                if (rollbackOnly2) {
                                    commitFailed2 = true;
                                }
                                for (EntityManagerEntry currentEntityManagerEntry : entityManagerEntryList3) {
                                    transaction3 = this.getTransaction(currentEntityManagerEntry);
                                    if (transaction3 == null || !transaction3.isActive()) continue;
                                    try {
                                        if (commitFailed2 || transaction3.getRollbackOnly()) {
                                            this.beforeRollback(invocationContext, currentEntityManagerEntry, transaction3);
                                            transaction3.rollback();
                                            continue;
                                        }
                                        this.beforeCommit(invocationContext, currentEntityManagerEntry, transaction3);
                                        transaction3.commit();
                                    }
                                    catch (Exception e3) {
                                        firstException = e3;
                                        commitFailed2 = true;
                                    }
                                    finally {
                                        this.afterProceed(invocationContext, currentEntityManagerEntry, firstException);
                                    }
                                }
                            }
                            transactionBeanStorage.endTransactionScope();
                            this.onCloseTransactionScope();
                        }
                        transactionBeanStorage.decrementRefCounter();
                        if (commitFailed2 && firstException != null) {
                            this.throwException(firstException);
                        }
                        throw throwable;
                    }
                }
                if (!rollbackOnly && entityManagerEntryList.size() > 1) {
                    for (EntityManagerEntry currentEntityManagerEntry : entityManagerEntryList) {
                        transaction = this.getTransaction(currentEntityManagerEntry);
                        if (transaction == null || !transaction.isActive()) continue;
                        try {
                            if (commitFailed) continue;
                            currentEntityManagerEntry.getEntityManager().flush();
                            if (rollbackOnly || !transaction.getRollbackOnly()) continue;
                            rollbackOnly = true;
                        }
                        catch (Exception e) {
                            firstException = e;
                            commitFailed = true;
                            break;
                        }
                    }
                }
                if (rollbackOnly) {
                    commitFailed = true;
                }
                for (EntityManagerEntry currentEntityManagerEntry : entityManagerEntryList) {
                    transaction = this.getTransaction(currentEntityManagerEntry);
                    if (transaction == null || !transaction.isActive()) continue;
                    try {
                        if (commitFailed || transaction.getRollbackOnly()) {
                            this.beforeRollback(invocationContext, currentEntityManagerEntry, transaction);
                            transaction.rollback();
                            continue;
                        }
                        this.beforeCommit(invocationContext, currentEntityManagerEntry, transaction);
                        transaction.commit();
                    }
                    catch (Exception e) {
                        firstException = e;
                        commitFailed = true;
                    }
                    finally {
                        this.afterProceed(invocationContext, currentEntityManagerEntry, firstException);
                    }
                }
            }
            transactionBeanStorage.endTransactionScope();
            this.onCloseTransactionScope();
        }
        transactionBeanStorage.decrementRefCounter();
        if (commitFailed && firstException != null) {
            this.throwException(firstException);
        }
        return i$;
    }

    protected void beforeBegin(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, EntityTransaction transaction) {
    }

    protected void beforeProceed(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, EntityTransaction transaction) {
    }

    protected void beforeCommit(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, EntityTransaction transaction) {
    }

    protected void beforeRollback(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, EntityTransaction transaction) {
    }

    protected void afterProceed(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, Exception exception) {
    }

    protected void throwException(Exception exception) throws Exception {
        throw exception;
    }

    @Deprecated
    protected boolean isRollbackOnly(Transactional transactionalAnnotation) {
        return transactionalAnnotation != null && transactionalAnnotation.readOnly();
    }

    private void rollbackAllTransactions(Set<EntityManagerEntry> entityManagerEntryList) {
        for (EntityManagerEntry currentEntityManagerEntry : entityManagerEntryList) {
            EntityTransaction transaction = this.getTransaction(currentEntityManagerEntry);
            if (transaction == null || !transaction.isActive()) continue;
            try {
                transaction.rollback();
            }
            catch (Exception eRollback) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, "Got additional Exception while subsequently rolling back other SQL transactions", eRollback);
            }
        }
    }

    protected EntityManagerEntry createEntityManagerEntry(EntityManager entityManager, Class<? extends Annotation> qualifier) {
        return new EntityManagerEntry(entityManager, qualifier);
    }

    protected EntityTransaction getTransaction(EntityManagerEntry entityManagerEntry) {
        return entityManagerEntry.getEntityManager().getTransaction();
    }

    private EntityManager resolveEntityManagerForQualifier(Class<? extends Annotation> emQualifier) {
        if (this.emHolder.isSet()) {
            return this.emHolder.get();
        }
        return new QualifierBackedEntityManagerResolver(this.beanManager, new Class[]{emQualifier}).resolveEntityManager();
    }

    protected Exception prepareException(Exception e) {
        return e;
    }

    protected void onCloseTransactionScope() {
        TransactionBeanStorage.close();
    }
}

