/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta.unit;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.deltaspike.data.impl.meta.RepositoryEntity;
import org.apache.deltaspike.data.impl.meta.unit.EntityDescriptor;
import org.apache.deltaspike.data.impl.meta.unit.PersistenceUnit;
import org.apache.deltaspike.data.impl.meta.unit.PersistenceUnitReader;

public final class PersistenceUnits {
    private static PersistenceUnits instance = new PersistenceUnits();
    private List<PersistenceUnit> persistenceUnits = Collections.emptyList();

    private PersistenceUnits() {
    }

    public static PersistenceUnits instance() {
        return instance;
    }

    public void init() {
        this.persistenceUnits = this.readPersistenceXmls();
    }

    public boolean isEntity(Class<?> entityClass) {
        return this.find(entityClass) != null;
    }

    public String primaryKeyField(Class<?> entityClass) {
        EntityDescriptor entity = this.find(entityClass);
        if (entity != null) {
            return entity.getId();
        }
        return null;
    }

    public Class<?> primaryKeyIdClass(Class<?> entityClass) {
        EntityDescriptor entity = this.find(entityClass);
        if (entity != null && entity.getIdClass() != null) {
            return entity.getIdClass();
        }
        return null;
    }

    public String entityName(Class<?> entityClass) {
        EntityDescriptor entity = this.find(entityClass);
        if (entity != null) {
            return entity.getName();
        }
        return null;
    }

    public RepositoryEntity lookupMetadata(Class<?> entityClass) {
        EntityDescriptor entity = this.find(entityClass);
        if (entity != null) {
            return new RepositoryEntity(entityClass, entity.getIdClass());
        }
        return null;
    }

    private List<PersistenceUnit> readPersistenceXmls() {
        try {
            PersistenceUnitReader reader = new PersistenceUnitReader();
            return reader.readAll();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read persistence unit info", e);
        }
    }

    private EntityDescriptor find(Class<?> entityClass) {
        for (PersistenceUnit unit : this.persistenceUnits) {
            EntityDescriptor entity = unit.find(entityClass);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public String entityTableName(Class<?> entityClass) {
        EntityDescriptor entity = this.find(entityClass);
        if (entity != null) {
            return entity.getTableName();
        }
        return null;
    }
}

