/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.handler;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.apache.deltaspike.core.api.literal.DefaultLiteral;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.api.provider.DependentProvider;
import org.apache.deltaspike.data.api.EntityManagerResolver;
import org.apache.deltaspike.data.impl.meta.RepositoryComponent;

public class EntityManagerLookup {
    @Inject
    @Any
    private Instance<EntityManager> entityManager;
    private DependentProvider<? extends EntityManagerResolver> dependentResolverProvider;

    public EntityManager lookupFor(RepositoryComponent repository) {
        EntityManager result = null;
        if (repository.hasEntityManagerResolver()) {
            Class<? extends EntityManagerResolver> emrc = repository.getEntityManagerResolverClass();
            if (!repository.isEntityManagerResolverIsNormalScope()) {
                DependentProvider<? extends EntityManagerResolver> resolver = this.lookupResolver(emrc);
                this.dependentResolverProvider = resolver;
                result = ((EntityManagerResolver)resolver.get()).resolveEntityManager();
            } else {
                result = ((EntityManagerResolver)BeanProvider.getContextualReference(emrc, (Annotation[])new Annotation[0])).resolveEntityManager();
            }
        } else {
            result = (EntityManager)this.entityManager.select(new Annotation[]{new DefaultLiteral()}).get();
        }
        if (repository.hasEntityManagerFlushMode()) {
            result.setFlushMode(repository.getEntityManagerFlushMode());
        }
        return result;
    }

    public void release() {
        if (this.dependentResolverProvider != null) {
            this.dependentResolverProvider.destroy();
        }
    }

    private DependentProvider<? extends EntityManagerResolver> lookupResolver(Class<? extends EntityManagerResolver> resolverClass) {
        return BeanProvider.getDependent(resolverClass, (Annotation[])new Annotation[0]);
    }
}

