/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.cdise.api;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.deltaspike.cdise.api.CdiContainer;

public final class CdiContainerLoader {
    private static CdiContainer cdiContainer = null;

    private CdiContainerLoader() {
    }

    public static synchronized CdiContainer getCdiContainer() {
        if (cdiContainer == null) {
            ServiceLoader<CdiContainer> cdiContainerLoader = ServiceLoader.load(CdiContainer.class);
            Iterator<CdiContainer> cdiIt = cdiContainerLoader.iterator();
            if (!cdiIt.hasNext()) {
                throw new IllegalStateException("Could not find an implementation of " + CdiContainer.class.getName() + " available in the classpath!");
            }
            cdiContainer = cdiIt.next();
            if (cdiIt.hasNext()) {
                String foundContainers = CdiContainerLoader.getContainerDetails();
                throw new IllegalStateException("Too many implementations of " + CdiContainer.class.getName() + " found in the classpath! Details: " + foundContainers);
            }
        }
        return cdiContainer;
    }

    private static String getContainerDetails() {
        StringBuilder result = new StringBuilder();
        for (CdiContainer cdiContainer : ServiceLoader.load(CdiContainer.class)) {
            Class<?> containerClass = cdiContainer.getClass();
            result.append(containerClass.getProtectionDomain().getCodeSource().getLocation().toExternalForm());
            result.append(containerClass.getName());
            result.append(System.getProperty("line.separator"));
        }
        return result.toString();
    }
}

