/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.tuple.DataToArrayOfDoublesSketchBase;
import org.apache.datasketches.pig.tuple.Util;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUnion;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.log4j.Logger;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

abstract class DataToArrayOfDoublesSketchAlgebraicIntermediateFinal
extends EvalFunc<Tuple> {
    private final int sketchSize_;
    private final float samplingProbability_;
    private final int numValues_;
    private boolean isFirstCall_ = true;

    DataToArrayOfDoublesSketchAlgebraicIntermediateFinal() {
        this(4096, 1);
    }

    DataToArrayOfDoublesSketchAlgebraicIntermediateFinal(int numValues) {
        this(4096, numValues);
    }

    DataToArrayOfDoublesSketchAlgebraicIntermediateFinal(int sketchSize, int numValues) {
        this(sketchSize, 1.0f, numValues);
    }

    DataToArrayOfDoublesSketchAlgebraicIntermediateFinal(int sketchSize, float samplingProbability, int numValues) {
        this.sketchSize_ = sketchSize;
        this.samplingProbability_ = samplingProbability;
        this.numValues_ = numValues;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"algebraic is used");
            this.isFirstCall_ = false;
        }
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().setNominalEntries(this.sketchSize_).setNumberOfValues(this.numValues_).buildUnion();
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            throw new IllegalArgumentException("InputTuple.Field0: Bag may not be null");
        }
        for (Tuple dataTuple : bag) {
            Object item = dataTuple.get(0);
            if (item instanceof DataBag) {
                ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(this.sketchSize_).setSamplingProbability(this.samplingProbability_).setNumberOfValues(this.numValues_).build();
                DataToArrayOfDoublesSketchBase.updateSketch((DataBag)item, sketch, this.numValues_);
                union.union((ArrayOfDoublesSketch)sketch);
                continue;
            }
            if (item instanceof DataByteArray) {
                DataByteArray dba = (DataByteArray)item;
                union.union(ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])dba.get())));
                continue;
            }
            throw new IllegalArgumentException("InputTuple.Field0: Bag contains unrecognized types: " + item.getClass().getName());
        }
        return Util.tupleFactory.newTuple((Object)new DataByteArray(union.getResult().toByteArray()));
    }
}

