/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.pig.tuple.Util;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Union;
import org.apache.log4j.Logger;
import org.apache.pig.Accumulator;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public abstract class UnionSketch<S extends Summary>
extends EvalFunc<Tuple>
implements Accumulator<Tuple> {
    private final int sketchSize_;
    private final SummarySetOperations<S> summarySetOps_;
    private final SummaryDeserializer<S> summaryDeserializer_;
    private Union<S> union_;
    private boolean isFirstCall_ = true;

    public UnionSketch(SummarySetOperations<S> summarySetOps, SummaryDeserializer<S> summaryDeserializer) {
        this(4096, summarySetOps, summaryDeserializer);
    }

    public UnionSketch(int sketchSize, SummarySetOperations<S> summarySetOps, SummaryDeserializer<S> summaryDeserializer) {
        this.sketchSize_ = sketchSize;
        this.summarySetOps_ = summarySetOps;
        this.summaryDeserializer_ = summaryDeserializer;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"exec is used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            return null;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        Union union = new Union(this.sketchSize_, this.summarySetOps_);
        UnionSketch.updateUnion(bag, union, this.summaryDeserializer_);
        return Util.tupleFactory.newTuple((Object)new DataByteArray(union.getResult().toByteArray()));
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"accumulator is used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() != 1) {
            return;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null || bag.size() == 0L) {
            return;
        }
        if (this.union_ == null) {
            this.union_ = new Union(this.sketchSize_, this.summarySetOps_);
        }
        UnionSketch.updateUnion(bag, this.union_, this.summaryDeserializer_);
    }

    public Tuple getValue() {
        if (this.union_ == null) {
            return Util.tupleFactory.newTuple((Object)new DataByteArray(Sketches.createEmptySketch().toByteArray()));
        }
        return Util.tupleFactory.newTuple((Object)new DataByteArray(this.union_.getResult().toByteArray()));
    }

    public void cleanup() {
        if (this.union_ != null) {
            this.union_.reset();
        }
    }

    private static <S extends Summary> void updateUnion(DataBag bag, Union<S> union, SummaryDeserializer<S> summaryDeserializer) throws ExecException {
        for (Tuple innerTuple : bag) {
            if (innerTuple.size() != 1 || innerTuple.get(0) == null) continue;
            Sketch<S> incomingSketch = Util.deserializeSketchFromTuple(innerTuple, summaryDeserializer);
            union.update(incomingSketch);
        }
    }
}

