/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.tuple.Util;
import org.apache.datasketches.tuple.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.ArrayOfDoublesUnion;
import org.apache.log4j.Logger;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

abstract class UnionArrayOfDoublesSketchAlgebraicIntermediateFinal
extends EvalFunc<Tuple> {
    private final int sketchSize_;
    private final int numValues_;
    private boolean isFirstCall_ = true;

    UnionArrayOfDoublesSketchAlgebraicIntermediateFinal() {
        this(4096, 1);
    }

    UnionArrayOfDoublesSketchAlgebraicIntermediateFinal(int numValues) {
        this(4096, numValues);
    }

    UnionArrayOfDoublesSketchAlgebraicIntermediateFinal(int sketchSize, int numValues) {
        this.sketchSize_ = sketchSize;
        this.numValues_ = numValues;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"algebraic is used");
            this.isFirstCall_ = false;
        }
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().setNominalEntries(this.sketchSize_).setNumberOfValues(this.numValues_).buildUnion();
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            throw new IllegalArgumentException("InputTuple.Field0: Bag may not be null");
        }
        for (Tuple dataTuple : bag) {
            Object item = dataTuple.get(0);
            if (item instanceof DataBag) {
                for (Tuple innerTuple : (DataBag)item) {
                    DataByteArray dba = (DataByteArray)innerTuple.get(0);
                    union.update(ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])dba.get())));
                }
                continue;
            }
            if (item instanceof DataByteArray) {
                DataByteArray dba = (DataByteArray)item;
                union.update(ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])dba.get())));
                continue;
            }
            throw new IllegalArgumentException("InputTuple.Field0: Bag contains unrecognized types: " + item.getClass().getName());
        }
        return Util.tupleFactory.newTuple((Object)new DataByteArray(union.getResult().toByteArray()));
    }
}

