/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.inference.TTest;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.tuple.ArrayOfDoublesSketchStats;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketches;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class ArrayOfDoublesSketchesToPValueEstimates
extends EvalFunc<Tuple> {
    public Tuple exec(Tuple input) throws IOException {
        if (input == null || input.size() != 2) {
            return null;
        }
        DataByteArray dbaA = (DataByteArray)input.get(0);
        DataByteArray dbaB = (DataByteArray)input.get(1);
        ArrayOfDoublesSketch sketchA = ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])dbaA.get()));
        ArrayOfDoublesSketch sketchB = ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])dbaB.get()));
        if (sketchA.getNumValues() != sketchB.getNumValues()) {
            throw new IllegalArgumentException("Both sketches must have the same number of values");
        }
        int numMetrics = sketchA.getNumValues();
        if (sketchA.getRetainedEntries() < 2 || sketchB.getRetainedEntries() < 2) {
            return null;
        }
        SummaryStatistics[] summariesA = ArrayOfDoublesSketchStats.sketchToSummaryStatistics(sketchA);
        SummaryStatistics[] summariesB = ArrayOfDoublesSketchStats.sketchToSummaryStatistics(sketchB);
        TTest tTest = new TTest();
        Tuple pValues = TupleFactory.getInstance().newTuple(numMetrics);
        for (int i = 0; i < numMetrics; ++i) {
            pValues.set(i, (Object)tTest.tTest((StatisticalSummary)summariesA[i], (StatisticalSummary)summariesB[i]));
        }
        return pValues;
    }
}

