/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchBuilder;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.ArrayOfDoublesSketches;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class ArrayOfDoublesSketchToQuantilesSketch
extends EvalFunc<DataByteArray> {
    private final int k;

    public ArrayOfDoublesSketchToQuantilesSketch() {
        this.k = 0;
    }

    public ArrayOfDoublesSketchToQuantilesSketch(String k) {
        this.k = Integer.parseInt(k);
    }

    public DataByteArray exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        DataByteArray dba = (DataByteArray)input.get(0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])dba.get()));
        int column = 1;
        if (input.size() > 1 && ((column = ((Integer)input.get(1)).intValue()) < 1 || column > sketch.getNumValues())) {
            throw new IllegalArgumentException("Column number out of range. The given sketch has " + sketch.getNumValues() + " columns");
        }
        DoublesSketchBuilder builder = DoublesSketch.builder();
        if (this.k > 0) {
            builder.setK(this.k);
        }
        UpdateDoublesSketch qs = builder.build();
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        while (it.next()) {
            qs.update(it.getValues()[column - 1]);
        }
        return new DataByteArray(qs.compact().toByteArray());
    }
}

