/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.theta.PigUtil;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class Union
extends EvalFunc<Tuple>
implements Accumulator<Tuple>,
Algebraic {
    private final int nomEntries_;
    private final float p_;
    private final long seed_;
    private final Tuple emptyCompactOrderedSketchTuple_;
    private org.apache.datasketches.theta.Union accumUnion_;

    public Union() {
        this(4096, 1.0f, 9001L);
    }

    public Union(String nomEntriesStr) {
        this(Integer.parseInt(nomEntriesStr), 1.0f, 9001L);
    }

    public Union(String nomEntriesStr, String pStr) {
        this(Integer.parseInt(nomEntriesStr), Float.parseFloat(pStr), 9001L);
    }

    public Union(String nomEntriesStr, String pStr, String seedStr) {
        this(Integer.parseInt(nomEntriesStr), Float.parseFloat(pStr), Long.parseLong(seedStr));
    }

    public Union(int nomEntries, float p, long seed) {
        this.nomEntries_ = nomEntries;
        this.p_ = p;
        this.seed_ = seed;
        this.emptyCompactOrderedSketchTuple_ = PigUtil.emptySketchTuple(seed);
        Util.checkIfPowerOf2((int)nomEntries, (String)"nomEntries");
        Util.checkProbability((double)p, (String)"p");
        if (nomEntries < 16) {
            throw new IllegalArgumentException("NomEntries too small: " + nomEntries + ", required: " + 16);
        }
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        org.apache.datasketches.theta.Union union = SetOperation.builder().setP(this.p_).setSeed(this.seed_).setResizeFactor(PigUtil.RF).setNominalEntries(this.nomEntries_).buildUnion();
        DataBag bag = PigUtil.extractBag(inputTuple);
        if (bag == null) {
            return this.emptyCompactOrderedSketchTuple_;
        }
        Union.updateUnion(bag, union);
        CompactSketch compactSketch = union.getResult(true, null);
        return PigUtil.compactOrderedSketchToTuple(compactSketch);
    }

    public Schema outputSchema(Schema input) {
        if (input != null) {
            try {
                Schema tupleSchema = new Schema();
                tupleSchema.add(new Schema.FieldSchema("Sketch", 50));
                return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 110));
            }
            catch (FrontendException frontendException) {
                // empty catch block
            }
        }
        return null;
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        DataBag bag;
        if (this.accumUnion_ == null) {
            this.accumUnion_ = SetOperation.builder().setP(this.p_).setSeed(this.seed_).setResizeFactor(PigUtil.RF).setNominalEntries(this.nomEntries_).buildUnion();
        }
        if ((bag = PigUtil.extractBag(inputTuple)) == null) {
            return;
        }
        Union.updateUnion(bag, this.accumUnion_);
    }

    public Tuple getValue() {
        if (this.accumUnion_ == null) {
            return this.emptyCompactOrderedSketchTuple_;
        }
        CompactSketch compactSketch = this.accumUnion_.getResult(true, null);
        return PigUtil.compactOrderedSketchToTuple(compactSketch);
    }

    public void cleanup() {
        this.accumUnion_ = null;
    }

    public String getInitial() {
        return Initial.class.getName();
    }

    public String getIntermed() {
        return IntermediateFinal.class.getName();
    }

    public String getFinal() {
        return IntermediateFinal.class.getName();
    }

    private static void updateUnion(DataBag bag, org.apache.datasketches.theta.Union union) {
        for (Tuple innerTuple : bag) {
            Byte type;
            Object f0 = PigUtil.extractFieldAtIndex(innerTuple, 0);
            if (f0 == null || (type = PigUtil.extractTypeAtIndex(innerTuple, 0)) == null) continue;
            if (type == 50) {
                DataByteArray dba = (DataByteArray)f0;
                if (dba.size() <= 0) continue;
                union.update(Memory.wrap((byte[])dba.get()));
                continue;
            }
            throw new IllegalArgumentException("Field type was not DataType.BYTEARRAY: " + type);
        }
    }

    public static class IntermediateFinal
    extends EvalFunc<Tuple> {
        private final int myNomEntries_;
        private final float myP_;
        private final long mySeed_;
        private final Tuple myEmptyCompactOrderedSketchTuple_;

        public IntermediateFinal() {
            this(Integer.toString(4096), "1.0", Long.toString(9001L));
        }

        public IntermediateFinal(String nomEntriesStr) {
            this(nomEntriesStr, "1.0", Long.toString(9001L));
        }

        public IntermediateFinal(String nomEntriesStr, String pStr) {
            this(nomEntriesStr, pStr, Long.toString(9001L));
        }

        public IntermediateFinal(String nomEntriesStr, String pStr, String seedStr) {
            this(Integer.parseInt(nomEntriesStr), Float.parseFloat(pStr), Long.parseLong(seedStr));
        }

        public IntermediateFinal(int nomEntries, float p, long seed) {
            this.myNomEntries_ = nomEntries;
            this.myP_ = p;
            this.mySeed_ = seed;
            this.myEmptyCompactOrderedSketchTuple_ = PigUtil.emptySketchTuple(seed);
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            org.apache.datasketches.theta.Union union = SetOperation.builder().setP(this.myP_).setSeed(this.mySeed_).setResizeFactor(PigUtil.RF).setNominalEntries(this.myNomEntries_).buildUnion();
            DataBag outerBag = PigUtil.extractBag(inputTuple);
            if (outerBag == null) {
                return this.myEmptyCompactOrderedSketchTuple_;
            }
            for (Tuple dataTuple : outerBag) {
                Object f0 = PigUtil.extractFieldAtIndex(dataTuple, 0);
                if (f0 == null) continue;
                if (f0 instanceof DataBag) {
                    DataBag innerBag = (DataBag)f0;
                    if (innerBag.size() == 0L) continue;
                    Union.updateUnion(innerBag, union);
                    continue;
                }
                if (f0 instanceof DataByteArray) {
                    DataByteArray dba = (DataByteArray)f0;
                    Memory srcMem = Memory.wrap((byte[])dba.get());
                    union.update(srcMem);
                    continue;
                }
                throw new IllegalArgumentException("dataTuple.Field0: Is not a DataByteArray: " + f0.getClass().getName());
            }
            CompactSketch compactSketch = union.getResult(true, null);
            return PigUtil.compactOrderedSketchToTuple(compactSketch);
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        public Initial() {
            this(Integer.toString(4096), "1.0", Long.toString(9001L));
        }

        public Initial(String nomEntriesStr) {
            this(nomEntriesStr, "1.0", Long.toString(9001L));
        }

        public Initial(String nomEntriesStr, String pStr) {
            this(nomEntriesStr, pStr, Long.toString(9001L));
        }

        public Initial(String nomEntriesStr, String pStr, String seedStr) {
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            return inputTuple;
        }
    }
}

