/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.theta.PigUtil;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class Intersect
extends EvalFunc<Tuple>
implements Accumulator<Tuple>,
Algebraic {
    private final long seed_;
    private final Tuple emptyCompactOrderedSketchTuple_;
    private Intersection accumIntersection_;

    public Intersect() {
        this(9001L);
    }

    public Intersect(String seedStr) {
        this(Long.parseLong(seedStr));
    }

    public Intersect(long seed) {
        this.seed_ = seed;
        this.emptyCompactOrderedSketchTuple_ = PigUtil.emptySketchTuple(seed);
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        Intersection intersection = SetOperation.builder().setSeed(this.seed_).buildIntersection();
        DataBag bag = PigUtil.extractBag(inputTuple);
        if (bag == null) {
            return this.emptyCompactOrderedSketchTuple_;
        }
        Intersect.updateIntersection(bag, intersection, this.seed_);
        CompactSketch compactSketch = intersection.getResult(true, null);
        return PigUtil.compactOrderedSketchToTuple(compactSketch);
    }

    public Schema outputSchema(Schema input) {
        if (input != null) {
            try {
                Schema tupleSchema = new Schema();
                tupleSchema.add(new Schema.FieldSchema("Sketch", 50));
                return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 110));
            }
            catch (FrontendException frontendException) {
                // empty catch block
            }
        }
        return null;
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        DataBag bag;
        if (this.accumIntersection_ == null) {
            this.accumIntersection_ = SetOperation.builder().setSeed(this.seed_).buildIntersection();
        }
        if ((bag = PigUtil.extractBag(inputTuple)) == null) {
            return;
        }
        Intersect.updateIntersection(bag, this.accumIntersection_, this.seed_);
    }

    public Tuple getValue() {
        if (this.accumIntersection_ == null || !this.accumIntersection_.hasResult()) {
            throw new IllegalStateException("The accumulate(Tuple) method must be called at least once with a valid inputTuple.bag.SketchTuple prior to calling getValue().");
        }
        CompactSketch compactSketch = this.accumIntersection_.getResult(true, null);
        return PigUtil.compactOrderedSketchToTuple(compactSketch);
    }

    public void cleanup() {
        this.accumIntersection_ = null;
    }

    public String getInitial() {
        return Initial.class.getName();
    }

    public String getIntermed() {
        return IntermediateFinal.class.getName();
    }

    public String getFinal() {
        return IntermediateFinal.class.getName();
    }

    private static void updateIntersection(DataBag bag, Intersection intersection, long seed) {
        for (Tuple innerTuple : bag) {
            Object f0 = PigUtil.extractFieldAtIndex(innerTuple, 0);
            if (f0 == null) continue;
            Byte type = PigUtil.extractTypeAtIndex(innerTuple, 0);
            if (type == 50) {
                DataByteArray dba = (DataByteArray)f0;
                Memory srcMem = Memory.wrap((byte[])dba.get());
                Sketch sketch = Sketch.wrap((Memory)srcMem, (long)seed);
                intersection.update(sketch);
                continue;
            }
            throw new IllegalArgumentException("Field type was not DataType.BYTEARRAY: " + type);
        }
    }

    public static class IntermediateFinal
    extends EvalFunc<Tuple> {
        private final long mySeed_;
        private final Tuple myEmptyCompactOrderedSketchTuple_;

        public IntermediateFinal() {
            this(9001L);
        }

        public IntermediateFinal(String seedStr) {
            this(Long.parseLong(seedStr));
        }

        public IntermediateFinal(long seed) {
            this.mySeed_ = seed;
            this.myEmptyCompactOrderedSketchTuple_ = PigUtil.emptySketchTuple(seed);
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            Intersection intersection = SetOperation.builder().setSeed(this.mySeed_).buildIntersection();
            DataBag outerBag = PigUtil.extractBag(inputTuple);
            if (outerBag == null) {
                return this.myEmptyCompactOrderedSketchTuple_;
            }
            for (Tuple dataTuple : outerBag) {
                Object f0 = PigUtil.extractFieldAtIndex(dataTuple, 0);
                if (f0 == null) continue;
                if (f0 instanceof DataBag) {
                    DataBag innerBag = (DataBag)f0;
                    if (innerBag.size() == 0L) continue;
                    Intersect.updateIntersection(innerBag, intersection, this.mySeed_);
                    continue;
                }
                if (f0 instanceof DataByteArray) {
                    DataByteArray dba = (DataByteArray)f0;
                    Memory srcMem = Memory.wrap((byte[])dba.get());
                    Sketch sketch = Sketch.wrap((Memory)srcMem, (long)this.mySeed_);
                    intersection.update(sketch);
                    continue;
                }
                throw new IllegalArgumentException("dataTuple.Field0: Is not a DataByteArray: " + f0.getClass().getName());
            }
            CompactSketch compactSketch = intersection.getResult(true, null);
            return PigUtil.compactOrderedSketchToTuple(compactSketch);
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        public Initial() {
            this(Long.toString(9001L));
        }

        public Initial(String seedStr) {
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            return inputTuple;
        }
    }
}

