/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.theta.PigUtil;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class AexcludeB
extends EvalFunc<Tuple> {
    private final long seed_;

    public AexcludeB() {
        this(9001L);
    }

    public AexcludeB(String seedStr) {
        this(Long.parseLong(seedStr));
    }

    public AexcludeB(long seed) {
        this.seed_ = seed;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        Object objA = PigUtil.extractFieldAtIndex(inputTuple, 0);
        Sketch sketchA = null;
        if (objA != null) {
            DataByteArray dbaA = (DataByteArray)objA;
            Memory srcMem = Memory.wrap((byte[])dbaA.get());
            sketchA = Sketch.wrap((Memory)srcMem, (long)this.seed_);
        }
        Object objB = PigUtil.extractFieldAtIndex(inputTuple, 1);
        Sketch sketchB = null;
        if (objB != null) {
            DataByteArray dbaB = (DataByteArray)objB;
            Memory srcMem = Memory.wrap((byte[])dbaB.get());
            sketchB = Sketch.wrap((Memory)srcMem, (long)this.seed_);
        }
        AnotB aNOTb = SetOperation.builder().setSeed(this.seed_).buildANotB();
        aNOTb.update(sketchA, sketchB);
        CompactSketch compactSketch = aNOTb.getResult(true, null);
        return PigUtil.compactOrderedSketchToTuple(compactSketch);
    }

    public Schema outputSchema(Schema input) {
        if (input != null) {
            try {
                Schema tupleSchema = new Schema();
                tupleSchema.add(new Schema.FieldSchema("Sketch", 50));
                return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 110));
            }
            catch (FrontendException frontendException) {
                // empty catch block
            }
        }
        return null;
    }
}

