/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.io.File;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.internal.WritableMemoryImpl;

public interface WritableMemory
extends Memory {
    public static WritableMemory writableWrap(ByteBuffer byteBuffer) {
        return WritableMemory.writableWrap(byteBuffer, byteBuffer.order(), null);
    }

    public static WritableMemory writableWrap(ByteBuffer byteBuffer, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        return WritableMemoryImpl.wrapByteBuffer(byteBuffer, false, byteOrder, memReqSvr);
    }

    public static WritableMemory writableMap(File file) throws IOException {
        return WritableMemoryImpl.wrapMap(file, 0L, file.length(), ByteOrder.nativeOrder(), false, Arena.ofConfined());
    }

    public static WritableMemory writableMap(File file, long fileOffsetBytes, long capacityBytes, ByteOrder byteOrder) throws IOException {
        return WritableMemoryImpl.wrapMap(file, fileOffsetBytes, capacityBytes, byteOrder, false, Arena.ofConfined());
    }

    public static WritableMemory writableMap(File file, long fileOffsetBytes, long capacityBytes, ByteOrder byteOrder, Arena arena) throws IOException {
        return WritableMemoryImpl.wrapMap(file, fileOffsetBytes, capacityBytes, byteOrder, false, arena);
    }

    public static WritableMemory allocateDirect(long capacityBytes) {
        return WritableMemory.allocateDirect(capacityBytes, 8L, ByteOrder.nativeOrder(), new DefaultMemoryRequestServer(), Arena.ofConfined());
    }

    public static WritableMemory allocateDirect(long capacityBytes, Arena arena) {
        return WritableMemory.allocateDirect(capacityBytes, 8L, ByteOrder.nativeOrder(), new DefaultMemoryRequestServer(), arena);
    }

    public static WritableMemory allocateDirect(long capacityBytes, long alignmentBytes, ByteOrder byteOrder, MemoryRequestServer memReqSvr, Arena arena) {
        return WritableMemoryImpl.wrapDirect(capacityBytes, alignmentBytes, byteOrder, memReqSvr, arena);
    }

    default public WritableMemory writableRegion(long offsetBytes, long capacityBytes) {
        return this.writableRegion(offsetBytes, capacityBytes, this.getTypeByteOrder());
    }

    public WritableMemory writableRegion(long var1, long var3, ByteOrder var5);

    default public WritableBuffer asWritableBuffer() {
        return this.asWritableBuffer(this.getTypeByteOrder());
    }

    public WritableBuffer asWritableBuffer(ByteOrder var1);

    public static WritableMemory allocate(int capacityBytes) {
        return WritableMemory.allocate(capacityBytes, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory allocate(int capacityBytes, ByteOrder byteOrder) {
        return WritableMemory.allocate(capacityBytes, byteOrder, null);
    }

    public static WritableMemory allocate(int capacityBytes, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        byte[] arr = new byte[capacityBytes];
        return WritableMemory.writableWrap(arr, 0, capacityBytes, byteOrder, memReqSvr);
    }

    public static WritableMemory writableWrap(byte[] array) {
        return WritableMemory.writableWrap(array, 0, array.length, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(byte[] array, ByteOrder byteOrder) {
        return WritableMemory.writableWrap(array, 0, array.length, byteOrder, null);
    }

    public static WritableMemory writableWrap(byte[] array, int offsetBytes, int lengthBytes, ByteOrder byteOrder) {
        return WritableMemory.writableWrap(array, offsetBytes, lengthBytes, byteOrder, null);
    }

    public static WritableMemory writableWrap(byte[] array, int offsetBytes, int lengthBytes, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        MemorySegment slice = MemorySegment.ofArray(array).asSlice((long)offsetBytes, lengthBytes);
        return WritableMemoryImpl.wrapSegmentAsArray(slice, byteOrder, memReqSvr);
    }

    public static WritableMemory writableWrap(char[] array) {
        MemorySegment seg = MemorySegment.ofArray(array);
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(short[] array) {
        MemorySegment seg = MemorySegment.ofArray(array);
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(int[] array) {
        MemorySegment seg = MemorySegment.ofArray(array);
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(long[] array) {
        MemorySegment seg = MemorySegment.ofArray(array);
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(float[] array) {
        MemorySegment seg = MemorySegment.ofArray(array);
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(double[] array) {
        MemorySegment seg = MemorySegment.ofArray(array);
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public void putBoolean(long var1, boolean var3);

    public void putByte(long var1, byte var3);

    public void putByteArray(long var1, byte[] var3, int var4, int var5);

    public void putChar(long var1, char var3);

    public void putCharArray(long var1, char[] var3, int var4, int var5);

    public void putDouble(long var1, double var3);

    public void putDoubleArray(long var1, double[] var3, int var4, int var5);

    public void putFloat(long var1, float var3);

    public void putFloatArray(long var1, float[] var3, int var4, int var5);

    public void putInt(long var1, int var3);

    public void putIntArray(long var1, int[] var3, int var4, int var5);

    public void putLong(long var1, long var3);

    public void putLongArray(long var1, long[] var3, int var4, int var5);

    public void putShort(long var1, short var3);

    public void putShortArray(long var1, short[] var3, int var4, int var5);

    public void clear();

    public void clear(long var1, long var3);

    public void clearBits(long var1, byte var3);

    public void fill(byte var1);

    public void fill(long var1, long var3, byte var5);

    public void setBits(long var1, byte var3);

    public byte[] getArray();
}

