/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import sun.misc.Unsafe;

public final class UnsafeUtil {
    public static final Unsafe unsafe;
    public static final String JDK;
    public static final int JDK_MAJOR;
    public static final int ADDRESS_SIZE;
    public static final long ARRAY_BOOLEAN_BASE_OFFSET;
    public static final long ARRAY_BYTE_BASE_OFFSET;
    public static final long ARRAY_SHORT_BASE_OFFSET;
    public static final long ARRAY_CHAR_BASE_OFFSET;
    public static final long ARRAY_INT_BASE_OFFSET;
    public static final long ARRAY_LONG_BASE_OFFSET;
    public static final long ARRAY_FLOAT_BASE_OFFSET;
    public static final long ARRAY_DOUBLE_BASE_OFFSET;
    public static final long ARRAY_OBJECT_BASE_OFFSET;
    public static final int ARRAY_BOOLEAN_INDEX_SCALE = 1;
    public static final int ARRAY_BYTE_INDEX_SCALE = 1;
    public static final long ARRAY_SHORT_INDEX_SCALE = 2L;
    public static final long ARRAY_CHAR_INDEX_SCALE = 2L;
    public static final long ARRAY_INT_INDEX_SCALE = 4L;
    public static final long ARRAY_LONG_INDEX_SCALE = 8L;
    public static final long ARRAY_FLOAT_INDEX_SCALE = 4L;
    public static final long ARRAY_DOUBLE_INDEX_SCALE = 8L;
    public static final long ARRAY_OBJECT_INDEX_SCALE;
    public static final int BOOLEAN_SHIFT = 0;
    public static final int BYTE_SHIFT = 0;
    public static final long SHORT_SHIFT = 1L;
    public static final long CHAR_SHIFT = 1L;
    public static final long INT_SHIFT = 2L;
    public static final long LONG_SHIFT = 3L;
    public static final long FLOAT_SHIFT = 2L;
    public static final long DOUBLE_SHIFT = 3L;
    public static final long OBJECT_SHIFT;
    public static final String LS;

    private UnsafeUtil() {
    }

    public static int[] parseJavaVersion(String jdkVer) {
        int p1;
        int p0;
        try {
            String[] parts = jdkVer.trim().split("[^0-9\\.]");
            parts = parts[0].split("\\.");
            p0 = Integer.parseInt(parts[0]);
            p1 = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException("Improper Java -version string: " + jdkVer + LS + e);
        }
        UnsafeUtil.checkJavaVersion(jdkVer, p0, p1);
        return new int[]{p0, p1};
    }

    public static void checkJavaVersion(String jdkVer, int p0, int p1) {
        boolean ok;
        boolean bl = ok = p0 == 1 && p1 == 8 || p0 == 8 || p0 == 11 || p0 == 17;
        if (!ok) {
            throw new IllegalArgumentException("Unsupported Runtime JDK Major Version, must be one of 1.8, 8, 11, 17: " + jdkVer);
        }
    }

    public static long getFieldOffset(Class<?> c, String fieldName) {
        try {
            return unsafe.objectFieldOffset(c.getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e + ": " + fieldName);
        }
    }

    public static long getArrayBaseOffset(Class<?> c) {
        if (c == byte[].class) {
            return ARRAY_BYTE_BASE_OFFSET;
        }
        if (c == int[].class) {
            return ARRAY_INT_BASE_OFFSET;
        }
        if (c == long[].class) {
            return ARRAY_LONG_BASE_OFFSET;
        }
        if (c == float[].class) {
            return ARRAY_FLOAT_BASE_OFFSET;
        }
        if (c == double[].class) {
            return ARRAY_DOUBLE_BASE_OFFSET;
        }
        if (c == boolean[].class) {
            return ARRAY_BOOLEAN_BASE_OFFSET;
        }
        if (c == short[].class) {
            return ARRAY_SHORT_BASE_OFFSET;
        }
        if (c == char[].class) {
            return ARRAY_CHAR_BASE_OFFSET;
        }
        if (c == Object[].class) {
            return ARRAY_OBJECT_BASE_OFFSET;
        }
        return unsafe.arrayBaseOffset(c);
    }

    static {
        LS = System.getProperty("line.separator");
        try {
            Constructor unsafeConstructor = Unsafe.class.getDeclaredConstructor(new Class[0]);
            unsafeConstructor.setAccessible(true);
            unsafe = (Unsafe)unsafeConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to acquire Unsafe. " + e);
        }
        ADDRESS_SIZE = unsafe.addressSize();
        ARRAY_BOOLEAN_BASE_OFFSET = unsafe.arrayBaseOffset(boolean[].class);
        ARRAY_BYTE_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
        ARRAY_SHORT_BASE_OFFSET = unsafe.arrayBaseOffset(short[].class);
        ARRAY_CHAR_BASE_OFFSET = unsafe.arrayBaseOffset(char[].class);
        ARRAY_INT_BASE_OFFSET = unsafe.arrayBaseOffset(int[].class);
        ARRAY_LONG_BASE_OFFSET = unsafe.arrayBaseOffset(long[].class);
        ARRAY_FLOAT_BASE_OFFSET = unsafe.arrayBaseOffset(float[].class);
        ARRAY_DOUBLE_BASE_OFFSET = unsafe.arrayBaseOffset(double[].class);
        ARRAY_OBJECT_BASE_OFFSET = unsafe.arrayBaseOffset(Object[].class);
        ARRAY_OBJECT_INDEX_SCALE = unsafe.arrayIndexScale(Object[].class);
        OBJECT_SHIFT = ARRAY_OBJECT_INDEX_SCALE == 4L ? 2L : 3L;
        String jdkVer = System.getProperty("java.version");
        int[] p = UnsafeUtil.parseJavaVersion(jdkVer);
        JDK = p[0] + "." + p[1];
        JDK_MAJOR = p[0] == 1 ? p[1] : p[0];
    }
}

