/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryBoundsException;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.ReadOnlyException;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.internal.CompareAndCopy;
import org.apache.datasketches.memory.internal.PositionalImpl;
import org.apache.datasketches.memory.internal.UnsafeUtil;
import org.apache.datasketches.memory.internal.Util;
import org.apache.datasketches.memory.internal.XxHash64;

public abstract class ResourceImpl
implements Resource {
    static final String JDK;
    static final int JDK_MAJOR;
    static final int BOOLEAN_SHIFT = 0;
    static final int BYTE_SHIFT = 0;
    static final long SHORT_SHIFT = 1L;
    static final long CHAR_SHIFT = 1L;
    static final long INT_SHIFT = 2L;
    static final long LONG_SHIFT = 3L;
    static final long FLOAT_SHIFT = 2L;
    static final long DOUBLE_SHIFT = 3L;
    static final int WRITABLE = 0;
    static final int READONLY = 1;
    static final int REGION = 2;
    static final int DUPLICATE = 4;
    static final int HEAP = 0;
    static final int DIRECT = 8;
    static final int MAP = 16;
    static final int NATIVE_BO = 0;
    static final int NONNATIVE_BO = 32;
    static final int MEMORY = 0;
    static final int BUFFER = 64;
    static final int BYTEBUF = 128;
    public static final String LS;
    static final String NOT_MAPPED_FILE_RESOURCE = "This is not a memory-mapped file resource";
    static final String THREAD_EXCEPTION_TEXT = "Attempted access outside owning thread";
    long capacityBytes;
    long cumOffsetBytes;
    long offsetBytes;
    int typeId;
    Thread owner = null;
    MemoryRequestServer memReqSvr = null;

    ResourceImpl() {
    }

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        return this.memReqSvr;
    }

    @Override
    public boolean hasMemoryRequestServer() {
        return this.memReqSvr != null;
    }

    @Override
    public void setMemoryRequestServer(MemoryRequestServer memReqSvr) {
        this.memReqSvr = memReqSvr;
    }

    public static void checkBounds(long reqOff, long reqLen, long allocSize) {
        if ((reqOff | reqLen | reqOff + reqLen | allocSize - (reqOff + reqLen)) < 0L) {
            throw new MemoryBoundsException("reqOffset: " + reqOff + ", reqLength: " + reqLen + ", (reqOff + reqLen): " + (reqOff + reqLen) + ", allocSize: " + allocSize);
        }
    }

    static void checkJavaVersion(String jdkVer, int p0, int p1) {
        boolean ok;
        boolean bl = ok = p0 == 1 && p1 == 8 || p0 == 8 || p0 == 11 || p0 == 17;
        if (!ok) {
            throw new IllegalArgumentException("Unsupported JDK Major Version. It must be one of 1.8, 8, 11, 17: " + jdkVer);
        }
    }

    void checkNotReadOnly() {
        if (this.isReadOnly()) {
            throw new ReadOnlyException("Cannot write to a read-only Resource.");
        }
    }

    static final void checkThread(Thread owner) {
        if (owner != Thread.currentThread()) {
            throw new IllegalStateException(THREAD_EXCEPTION_TEXT);
        }
    }

    void checkValid() {
        if (!this.isAlive()) {
            throw new IllegalStateException("this Resource is AutoCloseable, and already closed, i.e., not <em>alive</em>.");
        }
    }

    public final void checkValidAndBounds(long offsetBytes, long lengthBytes) {
        this.checkValid();
        ResourceImpl.checkBounds(offsetBytes, lengthBytes, this.getCapacity());
    }

    final void checkValidAndBoundsForWrite(long offsetBytes, long lengthBytes) {
        this.checkValid();
        ResourceImpl.checkBounds(offsetBytes, lengthBytes, this.getCapacity());
        if (this.isReadOnly()) {
            throw new ReadOnlyException("Memory is read-only.");
        }
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("This resource is not AutoCloseable.");
    }

    @Override
    public final boolean equalTo(long thisOffsetBytes, Resource that, long thatOffsetBytes, long lengthBytes) {
        if (that == null) {
            return false;
        }
        return CompareAndCopy.equals(this, thisOffsetBytes, (ResourceImpl)that, thatOffsetBytes, lengthBytes);
    }

    @Override
    public void force() {
        throw new UnsupportedOperationException(NOT_MAPPED_FILE_RESOURCE);
    }

    ByteBuffer getByteBuffer() {
        return null;
    }

    @Override
    public final ByteOrder getTypeByteOrder() {
        return ResourceImpl.isNativeOrder(this.getTypeId()) ? Util.NATIVE_BYTE_ORDER : Util.NON_NATIVE_BYTE_ORDER;
    }

    @Override
    public long getCapacity() {
        this.checkValid();
        return this.capacityBytes;
    }

    @Override
    public long getCumulativeOffset(long addOffsetBytes) {
        return this.cumOffsetBytes + addOffsetBytes;
    }

    @Override
    public long getRelativeOffset() {
        return this.offsetBytes;
    }

    int getTypeId() {
        return this.typeId;
    }

    Object getUnsafeObject() {
        return null;
    }

    @Override
    public boolean hasByteBuffer() {
        return (this.getTypeId() & 0x80) > 0;
    }

    @Override
    public final boolean isByteOrderCompatible(ByteOrder byteOrder) {
        ByteOrder typeBO = this.getTypeByteOrder();
        return typeBO == ByteOrder.nativeOrder() && typeBO == byteOrder;
    }

    static final boolean isBuffer(int typeId) {
        return (typeId & 0x40) > 0;
    }

    @Override
    public boolean isCloseable() {
        return (this.getTypeId() & 0x18) > 0 && this.isAlive();
    }

    @Override
    public final boolean isDirect() {
        return this.getUnsafeObject() == null;
    }

    @Override
    public boolean isDuplicate() {
        return (this.getTypeId() & 4) > 0;
    }

    @Override
    public final boolean isHeap() {
        this.checkValid();
        return this.getUnsafeObject() != null;
    }

    @Override
    public boolean isLoaded() {
        throw new IllegalStateException(NOT_MAPPED_FILE_RESOURCE);
    }

    @Override
    public boolean isMapped() {
        return (this.getTypeId() & 0x10) > 0;
    }

    @Override
    public boolean isMemory() {
        return (this.getTypeId() & 0x40) == 0;
    }

    static final boolean isNativeOrder(int typeId) {
        return (typeId & 0x20) == 0;
    }

    @Override
    public boolean isNonNativeOrder() {
        return (this.getTypeId() & 0x20) > 0;
    }

    @Override
    public final boolean isReadOnly() {
        this.checkValid();
        return (this.getTypeId() & 1) > 0;
    }

    @Override
    public boolean isRegionView() {
        return (this.getTypeId() & 2) > 0;
    }

    @Override
    public boolean isSameResource(Resource that) {
        this.checkValid();
        if (that == null) {
            return false;
        }
        ResourceImpl that1 = (ResourceImpl)that;
        that1.checkValid();
        if (this == that1) {
            return true;
        }
        return this.getCumulativeOffset(0L) == that1.getCumulativeOffset(0L) && this.getCapacity() == that1.getCapacity() && this.getUnsafeObject() == that1.getUnsafeObject() && this.getByteBuffer() == that1.getByteBuffer();
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    public void load() {
        throw new IllegalStateException(NOT_MAPPED_FILE_RESOURCE);
    }

    private static String pad(String s, int fieldLen) {
        return Util.characterPad(s, fieldLen, ' ', true);
    }

    static int[] parseJavaVersion(String jdkVer) {
        int p1;
        int p0;
        try {
            String[] parts = jdkVer.trim().split("^0-9\\.");
            parts = parts[0].split("\\.");
            p0 = Integer.parseInt(parts[0]);
            p1 = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException("Improper Java -version string: " + jdkVer + LS + e);
        }
        ResourceImpl.checkJavaVersion(jdkVer, p0, p1);
        return new int[]{p0, p1};
    }

    static void reachabilityFence(Object obj) {
    }

    static final int removeNnBuf(int typeId) {
        return typeId & 0xFFFFFFDF & 0xFFFFFFBF;
    }

    static final int setReadOnlyBit(int typeId, boolean readOnly) {
        return readOnly ? typeId | 1 : typeId & 0xFFFFFFFE;
    }

    static final String toHex(ResourceImpl state, String preamble, long offsetBytes, int lengthBytes, boolean withData) {
        long uObjHeader;
        String uObjStr;
        long capacity = state.getCapacity();
        ResourceImpl.checkBounds(offsetBytes, lengthBytes, capacity);
        StringBuilder sb = new StringBuilder();
        Object uObj = state.getUnsafeObject();
        if (uObj == null) {
            uObjStr = "null";
            uObjHeader = 0L;
        } else {
            uObjStr = uObj.getClass().getSimpleName() + ", " + ((long)uObj.hashCode() & 0xFFFFFFFFL);
            uObjHeader = UnsafeUtil.getArrayBaseOffset(uObj.getClass());
        }
        ByteBuffer bb = state.getByteBuffer();
        String bbStr = bb == null ? "null" : bb.getClass().getSimpleName() + ", " + ((long)bb.hashCode() & 0xFFFFFFFFL);
        MemoryRequestServer memReqSvr = state.getMemoryRequestServer();
        String memReqStr = memReqSvr != null ? memReqSvr.getClass().getSimpleName() + ", " + ((long)memReqSvr.hashCode() & 0xFFFFFFFFL) : "null";
        long cumBaseOffset = state.getCumulativeOffset(0L);
        sb.append(preamble).append(LS);
        sb.append("UnsafeObj, hashCode : ").append(uObjStr).append(LS);
        sb.append("UnsafeObjHeader     : ").append(uObjHeader).append(LS);
        sb.append("ByteBuf, hashCode   : ").append(bbStr).append(LS);
        sb.append("RegionOffset        : ").append(state.getRelativeOffset()).append(LS);
        if (ResourceImpl.isBuffer(state.typeId)) {
            sb.append("Start               : ").append(((PositionalImpl)state).getStart()).append(LS);
            sb.append("Position            : ").append(((PositionalImpl)state).getPosition()).append(LS);
            sb.append("End                 : ").append(((PositionalImpl)state).getEnd()).append(LS);
        }
        sb.append("Capacity            : ").append(capacity).append(LS);
        sb.append("CumBaseOffset       : ").append(cumBaseOffset).append(LS);
        sb.append("MemReqSvr, hashCode : ").append(memReqStr).append(LS);
        sb.append("is Alive            : ").append(state.isAlive()).append(LS);
        sb.append("Read Only           : ").append(state.isReadOnly()).append(LS);
        sb.append("Type Byte Order     : ").append(state.getTypeByteOrder().toString()).append(LS);
        sb.append("Native Byte Order   : ").append(ByteOrder.nativeOrder().toString()).append(LS);
        sb.append("JDK Runtime Version : ").append(UnsafeUtil.JDK).append(LS);
        if (withData) {
            sb.append("Data, bytes         :  0  1  2  3  4  5  6  7");
            for (long i = 0L; i < (long)lengthBytes; ++i) {
                int b = UnsafeUtil.unsafe.getByte(uObj, cumBaseOffset + offsetBytes + i) & 0xFF;
                if (i % 8L == 0L) {
                    sb.append(String.format("%n%20s: ", offsetBytes + i));
                }
                sb.append(String.format("%02x ", b));
            }
            sb.append(LS);
        }
        sb.append("### END SUMMARY");
        return sb.toString();
    }

    @Override
    public final String toString(String header, long offsetBytes, int lengthBytes, boolean withData) {
        this.checkValid();
        String klass = this.getClass().getSimpleName();
        String s1 = String.format("(..., %d, %d)", offsetBytes, lengthBytes);
        long hcode = (long)this.hashCode() & 0xFFFFFFFFL;
        String call = ".toHexString" + s1 + ", hashCode: " + hcode;
        StringBuilder sb = new StringBuilder();
        sb.append("### ").append(klass).append(" SUMMARY ###").append(LS);
        sb.append("Type Info           : ").append(ResourceImpl.typeDecode(this.typeId)).append(LS + LS);
        sb.append("Header Comment      : ").append(header).append(LS);
        sb.append("Call Parameters     : ").append(call);
        return ResourceImpl.toHex(this, sb.toString(), offsetBytes, lengthBytes, withData);
    }

    @Override
    public final String toString() {
        return this.toString("", 0L, (int)this.getCapacity(), false);
    }

    static final String typeDecode(int typeId) {
        StringBuilder sb = new StringBuilder();
        int group1 = typeId & 7;
        switch (group1) {
            case 0: {
                sb.append(ResourceImpl.pad("Writable + ", 32));
                break;
            }
            case 1: {
                sb.append(ResourceImpl.pad("ReadOnly + ", 32));
                break;
            }
            case 2: {
                sb.append(ResourceImpl.pad("Writable + Region + ", 32));
                break;
            }
            case 3: {
                sb.append(ResourceImpl.pad("ReadOnly + Region + ", 32));
                break;
            }
            case 4: {
                sb.append(ResourceImpl.pad("Writable + Duplicate + ", 32));
                break;
            }
            case 5: {
                sb.append(ResourceImpl.pad("ReadOnly + Duplicate + ", 32));
                break;
            }
            case 6: {
                sb.append(ResourceImpl.pad("Writable + Region + Duplicate + ", 32));
                break;
            }
            case 7: {
                sb.append(ResourceImpl.pad("ReadOnly + Region + Duplicate + ", 32));
                break;
            }
        }
        int group2 = typeId >>> 3 & 3;
        switch (group2) {
            case 0: {
                sb.append(ResourceImpl.pad("Heap + ", 15));
                break;
            }
            case 1: {
                sb.append(ResourceImpl.pad("Direct + ", 15));
                break;
            }
            case 2: {
                sb.append(ResourceImpl.pad("Map + Direct + ", 15));
                break;
            }
            case 3: {
                sb.append(ResourceImpl.pad("Map + Direct + ", 15));
                break;
            }
        }
        int group3 = typeId >>> 5 & 1;
        switch (group3) {
            case 0: {
                sb.append(ResourceImpl.pad("NativeOrder + ", 17));
                break;
            }
            case 1: {
                sb.append(ResourceImpl.pad("NonNativeOrder + ", 17));
                break;
            }
        }
        int group4 = typeId >>> 6 & 1;
        switch (group4) {
            case 0: {
                sb.append(ResourceImpl.pad("Memory + ", 9));
                break;
            }
            case 1: {
                sb.append(ResourceImpl.pad("Buffer + ", 9));
                break;
            }
        }
        int group5 = typeId >>> 7 & 1;
        switch (group5) {
            case 0: {
                sb.append(ResourceImpl.pad("", 10));
                break;
            }
            case 1: {
                sb.append(ResourceImpl.pad("ByteBuffer", 10));
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public final long xxHash64(long offsetBytes, long lengthBytes, long seed) {
        this.checkValid();
        return XxHash64.hash(this.getUnsafeObject(), this.getCumulativeOffset(0L) + offsetBytes, lengthBytes, seed);
    }

    @Override
    public final long xxHash64(long in, long seed) {
        return XxHash64.hash(in, seed);
    }

    static {
        LS = System.getProperty("line.separator");
        String jdkVer = System.getProperty("java.version");
        int[] p = ResourceImpl.parseJavaVersion(jdkVer);
        JDK = p[0] + "." + p[1];
        JDK_MAJOR = p[0] == 1 ? p[1] : p[0];
    }
}

