/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseBuffer;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableBuffer;

public abstract class Buffer
extends BaseBuffer {
    Buffer(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes);
    }

    public static Buffer wrap(ByteBuffer byteBuf) {
        return Buffer.wrap(byteBuf, byteBuf.order());
    }

    public static Buffer wrap(ByteBuffer byteBuf, ByteOrder byteOrder) {
        BaseWritableMemoryImpl wmem = BaseWritableMemoryImpl.wrapByteBuffer(byteBuf, true, byteOrder);
        WritableBuffer wbuf = wmem.asWritableBufferImpl(true, byteOrder);
        wbuf.setStartPositionEnd(0L, byteBuf.position(), byteBuf.limit());
        return wbuf;
    }

    public abstract Buffer duplicate();

    public abstract Buffer duplicate(ByteOrder var1);

    public abstract Buffer region();

    public abstract Buffer region(long var1, long var3, ByteOrder var5);

    public abstract Memory asMemory();

    public abstract boolean getBoolean();

    public abstract boolean getBoolean(long var1);

    public abstract void getBooleanArray(boolean[] var1, int var2, int var3);

    public abstract byte getByte();

    public abstract byte getByte(long var1);

    public abstract void getByteArray(byte[] var1, int var2, int var3);

    public abstract char getChar();

    public abstract char getChar(long var1);

    public abstract void getCharArray(char[] var1, int var2, int var3);

    public abstract double getDouble();

    public abstract double getDouble(long var1);

    public abstract void getDoubleArray(double[] var1, int var2, int var3);

    public abstract float getFloat();

    public abstract float getFloat(long var1);

    public abstract void getFloatArray(float[] var1, int var2, int var3);

    public abstract int getInt();

    public abstract int getInt(long var1);

    public abstract void getIntArray(int[] var1, int var2, int var3);

    public abstract long getLong();

    public abstract long getLong(long var1);

    public abstract void getLongArray(long[] var1, int var2, int var3);

    public abstract short getShort();

    public abstract short getShort(long var1);

    public abstract void getShortArray(short[] var1, int var2, int var3);

    public abstract int compareTo(long var1, long var3, Buffer var5, long var6, long var8);
}

