/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import org.apache.datasketches.cpc.CompressedState;
import org.apache.datasketches.cpc.CompressionData;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.Flavor;
import org.apache.datasketches.cpc.PairTable;

final class CpcCompression {
    static final int NEXT_WORD_IDX = 0;
    static final int BIT_BUF = 1;
    static final int BUF_BITS = 2;

    CpcCompression() {
    }

    static void writeUnary(int[] compressedWords, long[] ptrArr, int theValue) {
        int remaining;
        int nextWordIndex = (int)ptrArr[0];
        assert ((long)nextWordIndex == ptrArr[0]);
        long bitBuf = ptrArr[1];
        int bufBits = (int)ptrArr[2];
        assert (compressedWords != null);
        assert (nextWordIndex >= 0);
        assert (bitBuf >= 0L);
        assert (bufBits >= 0 && bufBits <= 31);
        for (remaining = theValue; remaining >= 16; remaining -= 16) {
            if ((bufBits += 16) < 32) continue;
            compressedWords[nextWordIndex++] = (int)bitBuf;
            bitBuf >>>= 32;
            bufBits -= 32;
        }
        assert (remaining >= 0 && remaining <= 15);
        long theUnaryCode = 1L << remaining;
        bitBuf |= theUnaryCode << bufBits;
        if ((bufBits += 1 + remaining) >= 32) {
            compressedWords[nextWordIndex++] = (int)bitBuf;
            bitBuf >>>= 32;
            bufBits -= 32;
        }
        ptrArr[0] = nextWordIndex;
        assert ((long)nextWordIndex == ptrArr[0]);
        ptrArr[1] = bitBuf;
        ptrArr[2] = bufBits;
    }

    static long readUnary(int[] compressedWords, long[] ptrArr) {
        int trailingZeros;
        int nextWordIndex = (int)ptrArr[0];
        assert ((long)nextWordIndex == ptrArr[0]);
        long bitBuf = ptrArr[1];
        int bufBits = (int)ptrArr[2];
        assert (compressedWords != null);
        assert (nextWordIndex >= 0);
        assert (bitBuf >= 0L);
        assert (bufBits >= 0);
        long subTotal = 0L;
        while (true) {
            if (bufBits < 8) {
                bitBuf |= ((long)compressedWords[nextWordIndex++] & 0xFFFFFFFFL) << bufBits;
                bufBits += 32;
            }
            int peek8 = (int)(bitBuf & 0xFFL);
            trailingZeros = Math.min(8, Integer.numberOfTrailingZeros(peek8));
            assert (trailingZeros >= 0 && trailingZeros <= 8) : "TZ+ " + trailingZeros;
            if (trailingZeros != 8) break;
            subTotal += 8L;
            bufBits -= 8;
            bitBuf >>>= 8;
        }
        bufBits -= 1 + trailingZeros;
        bitBuf >>>= 1 + trailingZeros;
        ptrArr[0] = nextWordIndex;
        assert ((long)nextWordIndex == ptrArr[0]);
        ptrArr[1] = bitBuf;
        ptrArr[2] = bufBits;
        return subTotal + (long)trailingZeros;
    }

    static int lowLevelCompressBytes(byte[] byteArray, int numBytesToEncode, short[] encodingTable, int[] compressedWords) {
        int nextWordIndex = 0;
        long bitBuf = 0L;
        int bufBits = 0;
        for (int byteIndex = 0; byteIndex < numBytesToEncode; ++byteIndex) {
            int theByte = byteArray[byteIndex] & 0xFF;
            long codeInfo = (long)encodingTable[theByte] & 0xFFFFL;
            long codeVal = codeInfo & 0xFFFL;
            int codeWordLength = (int)(codeInfo >>> 12);
            bitBuf |= codeVal << bufBits;
            if ((bufBits += codeWordLength) < 32) continue;
            compressedWords[nextWordIndex++] = (int)bitBuf;
            bitBuf >>>= 32;
            bufBits -= 32;
        }
        if ((bufBits += 11) >= 32) {
            compressedWords[nextWordIndex++] = (int)bitBuf;
            bitBuf >>>= 32;
            bufBits -= 32;
        }
        if (bufBits > 0) {
            assert (bufBits < 32);
            compressedWords[nextWordIndex++] = (int)bitBuf;
        }
        return nextWordIndex;
    }

    static void lowLevelUncompressBytes(byte[] byteArray, int numBytesToDecode, short[] decodingTable, int[] compressedWords, long numCompressedWords) {
        int byteIndex = 0;
        int nextWordIndex = 0;
        long bitBuf = 0L;
        int bufBits = 0;
        assert (byteArray != null);
        assert (decodingTable != null);
        assert (compressedWords != null);
        for (byteIndex = 0; byteIndex < numBytesToDecode; ++byteIndex) {
            byte decodedByte;
            if (bufBits < 12) {
                bitBuf |= ((long)compressedWords[nextWordIndex++] & 0xFFFFFFFFL) << bufBits;
                bufBits += 32;
            }
            int peek12 = (int)(bitBuf & 0xFFFL);
            int lookup = decodingTable[peek12] & 0xFFFF;
            int codeWordLength = lookup >>> 8;
            byteArray[byteIndex] = decodedByte = (byte)(lookup & 0xFF);
            bitBuf >>>= codeWordLength;
            bufBits -= codeWordLength;
        }
        assert ((long)nextWordIndex <= numCompressedWords);
    }

    static long lowLevelCompressPairs(int[] pairArray, int numPairsToEncode, int numBaseBits, int[] compressedWords) {
        int pairIndex = 0;
        long[] ptrArr = new long[3];
        int nextWordIndex = 0;
        long bitBuf = 0L;
        int bufBits = 0;
        long golombLoMask = (1L << numBaseBits) - 1L;
        int predictedRowIndex = 0;
        int predictedColIndex = 0;
        for (pairIndex = 0; pairIndex < numPairsToEncode; ++pairIndex) {
            int rowCol = pairArray[pairIndex];
            int rowIndex = rowCol >>> 6;
            int colIndex = rowCol & 0x3F;
            if (rowIndex != predictedRowIndex) {
                predictedColIndex = 0;
            }
            assert (rowIndex >= predictedRowIndex);
            assert (colIndex >= predictedColIndex);
            long yDelta = rowIndex - predictedRowIndex;
            int xDelta = colIndex - predictedColIndex;
            predictedRowIndex = rowIndex;
            predictedColIndex = colIndex + 1;
            long codeInfo = (long)CompressionData.lengthLimitedUnaryEncodingTable65[xDelta] & 0xFFFFL;
            long codeVal = codeInfo & 0xFFFL;
            int codeLen = (int)(codeInfo >>> 12);
            bitBuf |= codeVal << bufBits;
            if ((bufBits += codeLen) >= 32) {
                compressedWords[nextWordIndex++] = (int)bitBuf;
                bitBuf >>>= 32;
                bufBits -= 32;
            }
            long golombLo = yDelta & golombLoMask;
            long golombHi = yDelta >>> numBaseBits;
            ptrArr[0] = nextWordIndex;
            ptrArr[1] = bitBuf;
            ptrArr[2] = bufBits;
            assert ((long)nextWordIndex == ptrArr[0]);
            CpcCompression.writeUnary(compressedWords, ptrArr, (int)golombHi);
            nextWordIndex = (int)ptrArr[0];
            bitBuf = ptrArr[1];
            bufBits = (int)ptrArr[2];
            assert ((long)nextWordIndex == ptrArr[0]);
            bitBuf |= golombLo << bufBits;
            if ((bufBits += numBaseBits) < 32) continue;
            compressedWords[nextWordIndex++] = (int)bitBuf;
            bitBuf >>>= 32;
            bufBits -= 32;
        }
        int padding = 10 - numBaseBits;
        if (padding < 0) {
            padding = 0;
        }
        if ((bufBits += padding) >= 32) {
            compressedWords[nextWordIndex++] = (int)bitBuf;
            bitBuf >>>= 32;
            bufBits -= 32;
        }
        if (bufBits > 0) {
            assert (bufBits < 32);
            compressedWords[nextWordIndex++] = (int)bitBuf;
        }
        return nextWordIndex;
    }

    static void lowLevelUncompressPairs(int[] pairArray, int numPairsToDecode, int numBaseBits, int[] compressedWords, long numCompressedWords) {
        int pairIndex = 0;
        long[] ptrArr = new long[3];
        int nextWordIndex = 0;
        long bitBuf = 0L;
        int bufBits = 0;
        long golombLoMask = (1L << numBaseBits) - 1L;
        int predictedRowIndex = 0;
        int predictedColIndex = 0;
        for (pairIndex = 0; pairIndex < numPairsToDecode; ++pairIndex) {
            int rowCol;
            if (bufBits < 12) {
                bitBuf |= ((long)compressedWords[nextWordIndex++] & 0xFFFFFFFFL) << bufBits;
                bufBits += 32;
            }
            int peek12 = (int)(bitBuf & 0xFFFL);
            int lookup = CompressionData.lengthLimitedUnaryDecodingTable65[peek12] & 0xFFFF;
            int codeWordLength = lookup >>> 8;
            int xDelta = lookup & 0xFF;
            ptrArr[0] = nextWordIndex;
            ptrArr[1] = bitBuf >>>= codeWordLength;
            ptrArr[2] = bufBits -= codeWordLength;
            assert ((long)nextWordIndex == ptrArr[0]);
            long golombHi = CpcCompression.readUnary(compressedWords, ptrArr);
            nextWordIndex = (int)ptrArr[0];
            bitBuf = ptrArr[1];
            bufBits = (int)ptrArr[2];
            assert ((long)nextWordIndex == ptrArr[0]);
            if (bufBits < numBaseBits) {
                bitBuf |= ((long)compressedWords[nextWordIndex++] & 0xFFFFFFFFL) << bufBits;
                bufBits += 32;
            }
            long golombLo = bitBuf & golombLoMask;
            bitBuf >>>= numBaseBits;
            bufBits -= numBaseBits;
            long yDelta = golombHi << numBaseBits | golombLo;
            if (yDelta > 0L) {
                predictedColIndex = 0;
            }
            int rowIndex = predictedRowIndex + (int)yDelta;
            int colIndex = predictedColIndex + xDelta;
            pairArray[pairIndex] = rowCol = rowIndex << 6 | colIndex;
            predictedRowIndex = rowIndex;
            predictedColIndex = colIndex + 1;
        }
        assert ((long)nextWordIndex <= numCompressedWords) : "nextWdIdx: " + nextWordIndex + ", #CompWds: " + numCompressedWords;
    }

    private static int safeLengthForCompressedPairBuf(long k, long numPairs, long numBaseBits) {
        assert (numPairs > 0L);
        long ybits = numPairs * (1L + numBaseBits) + (k >>> (int)numBaseBits);
        long xbits = 12L * numPairs;
        long padding = 10L - numBaseBits;
        if (padding < 0L) {
            padding = 0L;
        }
        long bits = xbits + ybits + padding;
        long words = CpcCompression.divideBy32RoundingUp(bits);
        assert (words < 0x80000000L);
        return (int)words;
    }

    private static int safeLengthForCompressedWindowBuf(long k) {
        long bits = 12L * k + 11L;
        return (int)CpcCompression.divideBy32RoundingUp(bits);
    }

    private static int determinePseudoPhase(int lgK, long numCoupons) {
        long c = numCoupons;
        long k = 1L << lgK;
        if (1000L * c < 2375L * k) {
            if (4L * c < 3L * k) {
                return 16;
            }
            if (10L * c < 11L * k) {
                return 17;
            }
            if (100L * c < 132L * k) {
                return 18;
            }
            if (3L * c < 5L * k) {
                return 19;
            }
            if (1000L * c < 1965L * k) {
                return 20;
            }
            if (1000L * c < 2275L * k) {
                return 21;
            }
            return 6;
        }
        assert (lgK >= 4);
        long tmp = c >>> lgK - 4;
        int phase = (int)(tmp & 0xFL);
        assert (phase >= 0 && phase < 16);
        return phase;
    }

    private static void compressTheWindow(CompressedState target, CpcSketch source) {
        int srcLgK = source.lgK;
        int srcK = 1 << srcLgK;
        int windowBufLen = CpcCompression.safeLengthForCompressedWindowBuf(srcK);
        int[] windowBuf = new int[windowBufLen];
        int pseudoPhase = CpcCompression.determinePseudoPhase(srcLgK, source.numCoupons);
        target.cwLengthInts = CpcCompression.lowLevelCompressBytes(source.slidingWindow, srcK, CompressionData.encodingTablesForHighEntropyByte[pseudoPhase], windowBuf);
        target.cwStream = windowBuf;
    }

    private static void uncompressTheWindow(CpcSketch target, CompressedState source) {
        int srcLgK = source.lgK;
        int srcK = 1 << srcLgK;
        byte[] window = new byte[srcK];
        assert (target.slidingWindow == null);
        target.slidingWindow = window;
        int pseudoPhase = CpcCompression.determinePseudoPhase(srcLgK, source.numCoupons);
        assert (source.cwStream != null);
        CpcCompression.lowLevelUncompressBytes(target.slidingWindow, srcK, CompressionData.decodingTablesForHighEntropyByte[pseudoPhase], source.cwStream, source.cwLengthInts);
    }

    private static void compressTheSurprisingValues(CompressedState target, CpcSketch source, int[] pairs, int numPairs) {
        assert (numPairs > 0);
        target.numCsv = numPairs;
        int srcK = 1 << source.lgK;
        int numBaseBits = CpcCompression.golombChooseNumberOfBaseBits(srcK + numPairs, numPairs);
        int pairBufLen = CpcCompression.safeLengthForCompressedPairBuf(srcK, numPairs, numBaseBits);
        int[] pairBuf = new int[pairBufLen];
        target.csvLengthInts = (int)CpcCompression.lowLevelCompressPairs(pairs, numPairs, numBaseBits, pairBuf);
        target.csvStream = pairBuf;
    }

    private static int[] uncompressTheSurprisingValues(CompressedState source) {
        int srcK = 1 << source.lgK;
        int numPairs = source.numCsv;
        assert (numPairs > 0);
        int[] pairs = new int[numPairs];
        int numBaseBits = CpcCompression.golombChooseNumberOfBaseBits(srcK + numPairs, numPairs);
        CpcCompression.lowLevelUncompressPairs(pairs, numPairs, numBaseBits, source.csvStream, source.csvLengthInts);
        return pairs;
    }

    private static void compressSparseFlavor(CompressedState target, CpcSketch source) {
        assert (source.slidingWindow == null);
        PairTable srcPairTable = source.pairTable;
        int srcNumPairs = srcPairTable.getNumPairs();
        int[] srcPairArr = PairTable.unwrappingGetItems(srcPairTable, srcNumPairs);
        PairTable.introspectiveInsertionSort(srcPairArr, 0, srcNumPairs - 1);
        CpcCompression.compressTheSurprisingValues(target, source, srcPairArr, srcNumPairs);
    }

    private static void uncompressSparseFlavor(CpcSketch target, CompressedState source) {
        PairTable table;
        assert (source.cwStream == null);
        assert (source.csvStream != null);
        int[] srcPairArr = CpcCompression.uncompressTheSurprisingValues(source);
        int numPairs = source.numCsv;
        target.pairTable = table = PairTable.newInstanceFromPairsArray(srcPairArr, numPairs, source.lgK);
    }

    private static int[] trickyGetPairsFromWindow(byte[] window, int k, int numPairsToGet, int emptySpace) {
        int outputLength = emptySpace + numPairsToGet;
        int[] pairs = new int[outputLength];
        int rowIndex = 0;
        int pairIndex = emptySpace;
        for (rowIndex = 0; rowIndex < k; ++rowIndex) {
            int colIndex;
            for (int wByte = window[rowIndex] & 0xFF; wByte != 0; wByte ^= 1 << colIndex) {
                colIndex = Integer.numberOfTrailingZeros(wByte);
                pairs[pairIndex++] = rowIndex << 6 | colIndex;
            }
        }
        assert (pairIndex == outputLength);
        return pairs;
    }

    private static void compressHybridFlavor(CompressedState target, CpcSketch source) {
        int srcK = 1 << source.lgK;
        PairTable srcPairTable = source.pairTable;
        int srcNumPairs = srcPairTable.getNumPairs();
        int[] srcPairArr = PairTable.unwrappingGetItems(srcPairTable, srcNumPairs);
        PairTable.introspectiveInsertionSort(srcPairArr, 0, srcNumPairs - 1);
        byte[] srcSlidingWindow = source.slidingWindow;
        int srcWindowOffset = source.windowOffset;
        long srcNumCoupons = source.numCoupons;
        assert (srcSlidingWindow != null);
        assert (srcWindowOffset == 0);
        long numPairs = srcNumCoupons - (long)srcNumPairs;
        assert (numPairs < Integer.MAX_VALUE);
        int numPairsFromArray = (int)numPairs;
        assert ((long)(numPairsFromArray + srcNumPairs) == srcNumCoupons);
        int[] allPairs = CpcCompression.trickyGetPairsFromWindow(srcSlidingWindow, srcK, numPairsFromArray, srcNumPairs);
        PairTable.merge(srcPairArr, 0, srcNumPairs, allPairs, srcNumPairs, numPairsFromArray, allPairs, 0);
        CpcCompression.compressTheSurprisingValues(target, source, allPairs, (int)srcNumCoupons);
    }

    private static void uncompressHybridFlavor(CpcSketch target, CompressedState source) {
        PairTable table;
        assert (source.cwStream == null);
        assert (source.csvStream != null);
        int[] pairs = CpcCompression.uncompressTheSurprisingValues(source);
        int numPairs = source.numCsv;
        int srcLgK = source.lgK;
        int k = 1 << srcLgK;
        byte[] window = new byte[k];
        int nextTruePair = 0;
        for (int i = 0; i < numPairs; ++i) {
            int rowCol = pairs[i];
            assert (rowCol != -1);
            int col = rowCol & 0x3F;
            if (col < 8) {
                int row;
                int n = row = rowCol >>> 6;
                window[n] = (byte)(window[n] | 1 << col);
                continue;
            }
            pairs[nextTruePair++] = rowCol;
        }
        assert (source.getWindowOffset() == 0);
        target.windowOffset = 0;
        target.pairTable = table = PairTable.newInstanceFromPairsArray(pairs, nextTruePair, srcLgK);
        target.slidingWindow = window;
    }

    private static void compressPinnedFlavor(CompressedState target, CpcSketch source) {
        CpcCompression.compressTheWindow(target, source);
        PairTable srcPairTable = source.pairTable;
        int numPairs = srcPairTable.getNumPairs();
        if (numPairs > 0) {
            int[] pairs = PairTable.unwrappingGetItems(srcPairTable, numPairs);
            int i = 0;
            while (i < numPairs) {
                assert ((pairs[i] & 0x3F) >= 8);
                int n = i++;
                pairs[n] = pairs[n] - 8;
            }
            PairTable.introspectiveInsertionSort(pairs, 0, numPairs - 1);
            CpcCompression.compressTheSurprisingValues(target, source, pairs, numPairs);
        }
    }

    private static void uncompressPinnedFlavor(CpcSketch target, CompressedState source) {
        assert (source.cwStream != null);
        CpcCompression.uncompressTheWindow(target, source);
        int srcLgK = source.lgK;
        int numPairs = source.numCsv;
        if (numPairs == 0) {
            target.pairTable = new PairTable(2, 6 + srcLgK);
        } else {
            PairTable table;
            assert (numPairs > 0);
            assert (source.csvStream != null);
            int[] pairs = CpcCompression.uncompressTheSurprisingValues(source);
            int i = 0;
            while (i < numPairs) {
                assert ((pairs[i] & 0x3F) < 56);
                int n = i++;
                pairs[n] = pairs[n] + 8;
            }
            target.pairTable = table = PairTable.newInstanceFromPairsArray(pairs, numPairs, srcLgK);
        }
    }

    private static void compressSlidingFlavor(CompressedState target, CpcSketch source) {
        CpcCompression.compressTheWindow(target, source);
        PairTable srcPairTable = source.pairTable;
        int numPairs = srcPairTable.getNumPairs();
        if (numPairs > 0) {
            int[] pairs = PairTable.unwrappingGetItems(srcPairTable, numPairs);
            int pseudoPhase = CpcCompression.determinePseudoPhase(source.lgK, source.numCoupons);
            assert (pseudoPhase < 16);
            byte[] permutation = CompressionData.columnPermutationsForEncoding[pseudoPhase];
            int offset = source.windowOffset;
            assert (offset > 0 && offset <= 56);
            for (int i = 0; i < numPairs; ++i) {
                int rowCol = pairs[i];
                int row = rowCol >>> 6;
                int col = rowCol & 0x3F;
                col = col + 56 - offset & 0x3F;
                assert (col >= 0 && col < 56);
                col = permutation[col];
                pairs[i] = row << 6 | col;
            }
            PairTable.introspectiveInsertionSort(pairs, 0, numPairs - 1);
            CpcCompression.compressTheSurprisingValues(target, source, pairs, numPairs);
        }
    }

    private static void uncompressSlidingFlavor(CpcSketch target, CompressedState source) {
        assert (source.cwStream != null);
        CpcCompression.uncompressTheWindow(target, source);
        int srcLgK = source.lgK;
        int numPairs = source.numCsv;
        if (numPairs == 0) {
            target.pairTable = new PairTable(2, 6 + srcLgK);
        } else {
            PairTable table;
            assert (numPairs > 0);
            assert (source.csvStream != null);
            int[] pairs = CpcCompression.uncompressTheSurprisingValues(source);
            int pseudoPhase = CpcCompression.determinePseudoPhase(srcLgK, source.numCoupons);
            assert (pseudoPhase < 16);
            byte[] permutation = CompressionData.columnPermutationsForDecoding[pseudoPhase];
            int offset = source.getWindowOffset();
            assert (offset > 0 && offset <= 56);
            for (int i = 0; i < numPairs; ++i) {
                int rowCol = pairs[i];
                int row = rowCol >>> 6;
                int col = rowCol & 0x3F;
                col = permutation[col];
                col = col + (offset + 8) & 0x3F;
                pairs[i] = row << 6 | col;
            }
            target.pairTable = table = PairTable.newInstanceFromPairsArray(pairs, numPairs, srcLgK);
        }
    }

    static CompressedState compress(CpcSketch source, CompressedState target) {
        Flavor srcFlavor = source.getFlavor();
        switch (srcFlavor) {
            case EMPTY: {
                break;
            }
            case SPARSE: {
                CpcCompression.compressSparseFlavor(target, source);
                assert (target.cwStream == null);
                assert (target.csvStream != null);
                break;
            }
            case HYBRID: {
                CpcCompression.compressHybridFlavor(target, source);
                assert (target.cwStream == null);
                assert (target.csvStream != null);
                break;
            }
            case PINNED: {
                CpcCompression.compressPinnedFlavor(target, source);
                assert (target.cwStream != null);
                break;
            }
            case SLIDING: {
                CpcCompression.compressSlidingFlavor(target, source);
                assert (target.cwStream != null);
                break;
            }
        }
        return target;
    }

    static CpcSketch uncompress(CompressedState source, CpcSketch target) {
        assert (target != null);
        Flavor srcFlavor = source.getFlavor();
        switch (srcFlavor) {
            case EMPTY: {
                break;
            }
            case SPARSE: {
                assert (source.cwStream == null);
                CpcCompression.uncompressSparseFlavor(target, source);
                break;
            }
            case HYBRID: {
                CpcCompression.uncompressHybridFlavor(target, source);
                break;
            }
            case PINNED: {
                assert (source.cwStream != null);
                CpcCompression.uncompressPinnedFlavor(target, source);
                break;
            }
            case SLIDING: {
                CpcCompression.uncompressSlidingFlavor(target, source);
            }
        }
        return target;
    }

    private static int golombChooseNumberOfBaseBits(int k, long count) {
        assert ((long)k >= 1L);
        assert (count >= 1L);
        long quotient = ((long)k - count) / count;
        if (quotient == 0L) {
            return 0;
        }
        return (int)CpcCompression.floorLog2ofLong(quotient);
    }

    private static long floorLog2ofLong(long x) {
        assert (x >= 1L);
        long p = 0L;
        long y = 1L;
        while (y != x) {
            if (y > x) {
                return p - 1L;
            }
            ++p;
            y <<= 1;
        }
        return p;
    }

    private static long divideBy32RoundingUp(long x) {
        long tmp = x >>> 5;
        return tmp << 5 == x ? tmp : tmp + 1L;
    }
}

