/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

final class KllMemoryValidate {
    final int preInts;
    final int serVer;
    final int familyID;
    final String famName;
    final int flags;
    boolean empty;
    boolean singleItem;
    final boolean level0Sorted;
    final boolean doublesSketch;
    boolean updatableMemFormat = false;
    final boolean readOnly;
    final int k;
    final int m;
    final int typeBytes;
    long n;
    int minK;
    int numLevels;
    int sketchBytes;
    int[] levelsArr;

    KllMemoryValidate(Memory srcMem) {
        this.readOnly = srcMem.isReadOnly();
        this.preInts = KllPreambleUtil.getMemoryPreInts(srcMem);
        this.serVer = KllPreambleUtil.getMemorySerVer(srcMem);
        this.familyID = KllPreambleUtil.getMemoryFamilyID(srcMem);
        if (this.familyID != Family.KLL.getID()) {
            MemoryInputError.memoryValidateThrow(MemoryInputError.SRC_NOT_KLL, this.familyID);
        }
        this.famName = Family.idToFamily(this.familyID).toString();
        this.flags = KllPreambleUtil.getMemoryFlags(srcMem);
        this.updatableMemFormat = KllPreambleUtil.getMemoryUpdatableFormatFlag(srcMem);
        this.empty = KllPreambleUtil.getMemoryEmptyFlag(srcMem);
        this.singleItem = KllPreambleUtil.getMemorySingleItemFlag(srcMem);
        this.level0Sorted = KllPreambleUtil.getMemoryLevelZeroSortedFlag(srcMem);
        this.doublesSketch = KllPreambleUtil.getMemoryDoubleSketchFlag(srcMem);
        this.k = KllPreambleUtil.getMemoryK(srcMem);
        this.m = KllPreambleUtil.getMemoryM(srcMem);
        KllHelper.checkM(this.m);
        KllHelper.checkK(this.k, this.m);
        if (this.serVer == 3 ^ this.updatableMemFormat) {
            MemoryInputError.memoryValidateThrow(MemoryInputError.UPDATABLEBIT_AND_SER_VER, 1);
        }
        int n = this.typeBytes = this.doublesSketch ? 8 : 4;
        if (this.updatableMemFormat) {
            this.updatableMemFormatValidate((WritableMemory)srcMem);
        } else {
            this.compactMemoryValidate(srcMem);
        }
    }

    void compactMemoryValidate(Memory srcMem) {
        if (this.empty && this.singleItem) {
            MemoryInputError.memoryValidateThrow(MemoryInputError.EMPTYBIT_AND_SINGLEBIT, this.flags);
        }
        int sw = (this.empty ? 1 : 0) | (this.singleItem ? 4 : 0);
        switch (sw) {
            case 0: {
                int capacityItems;
                if (this.preInts != 5) {
                    MemoryInputError.memoryValidateThrow(MemoryInputError.INVALID_PREINTS, this.preInts);
                }
                if (this.serVer != 1) {
                    MemoryInputError.memoryValidateThrow(MemoryInputError.EMPTYBIT_AND_SER_VER, this.serVer);
                }
                this.n = KllPreambleUtil.getMemoryN(srcMem);
                this.minK = KllPreambleUtil.getMemoryMinK(srcMem);
                this.numLevels = KllPreambleUtil.getMemoryNumLevels(srcMem);
                this.levelsArr = new int[this.numLevels + 1];
                srcMem.getIntArray(20L, this.levelsArr, 0, this.numLevels);
                this.levelsArr[this.numLevels] = capacityItems = KllHelper.computeTotalItemCapacity(this.k, this.m, this.numLevels);
                int retainedItems = this.levelsArr[this.numLevels] - this.levelsArr[0];
                this.sketchBytes = 20 + this.numLevels * 4 + 2 * this.typeBytes + retainedItems * this.typeBytes;
                break;
            }
            case 1: {
                if (this.preInts != 2) {
                    MemoryInputError.memoryValidateThrow(MemoryInputError.EMPTYBIT_AND_PREINTS, this.preInts);
                }
                if (this.serVer != 1) {
                    MemoryInputError.memoryValidateThrow(MemoryInputError.EMPTYBIT_AND_SER_VER, this.serVer);
                }
                this.n = 0L;
                this.minK = this.k;
                this.numLevels = 1;
                this.levelsArr = new int[]{this.k, this.k};
                this.sketchBytes = 8;
                break;
            }
            case 4: {
                if (this.preInts != 2) {
                    MemoryInputError.memoryValidateThrow(MemoryInputError.SINGLEBIT_AND_PREINTS, this.preInts);
                }
                if (this.serVer != 2) {
                    MemoryInputError.memoryValidateThrow(MemoryInputError.SINGLEBIT_AND_SER_VER, this.serVer);
                }
                this.n = 1L;
                this.minK = this.k;
                this.numLevels = 1;
                this.levelsArr = new int[]{this.k - 1, this.k};
                this.sketchBytes = 8 + this.typeBytes;
                break;
            }
        }
    }

    void updatableMemFormatValidate(WritableMemory wSrcMem) {
        if (this.preInts != 5) {
            MemoryInputError.memoryValidateThrow(MemoryInputError.INVALID_PREINTS, this.preInts);
        }
        this.n = KllPreambleUtil.getMemoryN((Memory)wSrcMem);
        this.empty = this.n == 0L;
        this.singleItem = this.n == 1L;
        this.minK = KllPreambleUtil.getMemoryMinK((Memory)wSrcMem);
        this.numLevels = KllPreambleUtil.getMemoryNumLevels((Memory)wSrcMem);
        this.levelsArr = new int[this.numLevels + 1];
        wSrcMem.getIntArray(20L, this.levelsArr, 0, this.numLevels + 1);
        int capacity = this.levelsArr[this.numLevels];
        this.sketchBytes = 20 + this.levelsArr.length * 4 + 2 * this.typeBytes + capacity * this.typeBytes;
    }

    static enum MemoryInputError {
        SRC_NOT_KLL("FamilyID Field must be: " + Family.KLL.getID() + ", NOT: "),
        EMPTYBIT_AND_PREINTS("Empty Bit: 1 -> PreInts: 2, NOT: "),
        EMPTYBIT_AND_SER_VER("Empty Bit: 1 -> SerVer: 1, NOT: "),
        SINGLEBIT_AND_SER_VER("Single Item Bit: 1 -> SerVer: 2, NOT: "),
        SINGLEBIT_AND_PREINTS("Single Item Bit: 1 -> PreInts: 2, NOT: "),
        INVALID_PREINTS("PreInts Must Be: 5, NOT: "),
        UPDATABLEBIT_AND_SER_VER("((SerVer == 3) ^ (Updatable Bit)) must = 0, NOT: "),
        EMPTYBIT_AND_SINGLEBIT("Empty flag bit and SingleItem flag bit cannot both be set. Flags: ");

        private String msg;

        private MemoryInputError(String msg) {
            this.msg = msg;
        }

        private String getMessage() {
            return this.msg;
        }

        static final void memoryValidateThrow(MemoryInputError errType, int errVal) {
            throw new SketchesArgumentException(errType.getMessage() + errVal);
        }
    }
}

