/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Arrays;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDoublesHelper;
import org.apache.datasketches.kll.KllFloatsHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.WritableMemory;

final class KllHelper {
    static final double EPS_DELTA_THRESHOLD = 1.0E-6;
    static final double MIN_EPS = 4.7634E-5;
    static final double PMF_COEF = 2.446;
    static final double PMF_EXP = 0.9433;
    static final double CDF_COEF = 2.296;
    static final double CDF_EXP = 0.9723;
    private static long[] powersOfThree = new long[]{1L, 3L, 9L, 27L, 81L, 243L, 729L, 2187L, 6561L, 19683L, 59049L, 177147L, 531441L, 1594323L, 4782969L, 14348907L, 43046721L, 129140163L, 387420489L, 1162261467L, 3486784401L, 10460353203L, 31381059609L, 94143178827L, 282429536481L, 847288609443L, 2541865828329L, 7625597484987L, 22876792454961L, 68630377364883L, 205891132094649L};

    KllHelper() {
    }

    static void checkK(int k, int m) {
        if (k < m || k > 65535) {
            throw new SketchesArgumentException("K must be >= " + m + " and <= " + 65535 + ": " + k);
        }
    }

    static void checkM(int m) {
        if (m < 2 || m > 8 || (m & 1) == 1) {
            throw new SketchesArgumentException("M must be >= 2, <= 8 and even: " + m);
        }
    }

    static void compressWhileUpdatingSketch(KllSketch sketch) {
        int level = KllHelper.findLevelToCompact(sketch.getK(), sketch.getM(), sketch.getNumLevels(), sketch.getLevelsArray());
        if (level == sketch.getNumLevels() - 1) {
            KllHelper.addEmptyTopLevelToCompletelyFullSketch(sketch);
        }
        int[] myLevelsArr = sketch.getLevelsArray();
        int rawBeg = myLevelsArr[level];
        int rawEnd = myLevelsArr[level + 1];
        int popAbove = myLevelsArr[level + 2] - rawEnd;
        int rawPop = rawEnd - rawBeg;
        boolean oddPop = Util.isOdd(rawPop);
        int adjBeg = oddPop ? rawBeg + 1 : rawBeg;
        int adjPop = oddPop ? rawPop - 1 : rawPop;
        int halfAdjPop = adjPop / 2;
        if (sketch.sketchType == KllSketch.SketchType.DOUBLES_SKETCH) {
            double[] myDoubleItemsArr = sketch.getDoubleItemsArray();
            if (level == 0) {
                Arrays.sort(myDoubleItemsArr, adjBeg, adjBeg + adjPop);
            }
            if (popAbove == 0) {
                KllDoublesHelper.randomlyHalveUpDoubles(myDoubleItemsArr, adjBeg, adjPop, KllSketch.random);
            } else {
                KllDoublesHelper.randomlyHalveDownDoubles(myDoubleItemsArr, adjBeg, adjPop, KllSketch.random);
                KllDoublesHelper.mergeSortedDoubleArrays(myDoubleItemsArr, adjBeg, halfAdjPop, myDoubleItemsArr, rawEnd, popAbove, myDoubleItemsArr, adjBeg + halfAdjPop);
            }
            int newIndex = myLevelsArr[level + 1] - halfAdjPop;
            sketch.setLevelsArrayAt(level + 1, newIndex);
            if (oddPop) {
                sketch.setLevelsArrayAt(level, myLevelsArr[level + 1] - 1);
                myDoubleItemsArr[myLevelsArr[level]] = myDoubleItemsArr[rawBeg];
            } else {
                sketch.setLevelsArrayAt(level, myLevelsArr[level + 1]);
            }
            assert (myLevelsArr[level] == rawBeg + halfAdjPop);
            if (level > 0) {
                int amount = rawBeg - myLevelsArr[0];
                System.arraycopy(myDoubleItemsArr, myLevelsArr[0], myDoubleItemsArr, myLevelsArr[0] + halfAdjPop, amount);
            }
            for (int lvl = 0; lvl < level; ++lvl) {
                newIndex = myLevelsArr[lvl] + halfAdjPop;
                sketch.setLevelsArrayAt(lvl, newIndex);
            }
            sketch.setDoubleItemsArray(myDoubleItemsArr);
        } else {
            float[] myFloatItemsArr = sketch.getFloatItemsArray();
            if (level == 0) {
                Arrays.sort(myFloatItemsArr, adjBeg, adjBeg + adjPop);
            }
            if (popAbove == 0) {
                KllFloatsHelper.randomlyHalveUpFloats(myFloatItemsArr, adjBeg, adjPop, KllSketch.random);
            } else {
                KllFloatsHelper.randomlyHalveDownFloats(myFloatItemsArr, adjBeg, adjPop, KllSketch.random);
                KllFloatsHelper.mergeSortedFloatArrays(myFloatItemsArr, adjBeg, halfAdjPop, myFloatItemsArr, rawEnd, popAbove, myFloatItemsArr, adjBeg + halfAdjPop);
            }
            int newIndex = myLevelsArr[level + 1] - halfAdjPop;
            sketch.setLevelsArrayAt(level + 1, newIndex);
            if (oddPop) {
                sketch.setLevelsArrayAt(level, myLevelsArr[level + 1] - 1);
                myFloatItemsArr[myLevelsArr[level]] = myFloatItemsArr[rawBeg];
            } else {
                sketch.setLevelsArrayAt(level, myLevelsArr[level + 1]);
            }
            assert (myLevelsArr[level] == rawBeg + halfAdjPop);
            if (level > 0) {
                int amount = rawBeg - myLevelsArr[0];
                System.arraycopy(myFloatItemsArr, myLevelsArr[0], myFloatItemsArr, myLevelsArr[0] + halfAdjPop, amount);
            }
            for (int lvl = 0; lvl < level; ++lvl) {
                newIndex = myLevelsArr[lvl] + halfAdjPop;
                sketch.setLevelsArrayAt(lvl, newIndex);
            }
            sketch.setFloatItemsArray(myFloatItemsArr);
        }
    }

    static int computeTotalItemCapacity(int k, int m, int numLevels) {
        long total = 0L;
        for (int level = 0; level < numLevels; ++level) {
            total += (long)KllHelper.levelCapacity(k, numLevels, level, m);
        }
        return (int)total;
    }

    public static long convertToCumulative(long[] array) {
        long subtotal = 0L;
        for (int i = 0; i < array.length; ++i) {
            long newSubtotal;
            subtotal = array[i] = (newSubtotal = subtotal + array[i]);
        }
        return subtotal;
    }

    static int currentLevelSize(int level, int numLevels, int[] levels) {
        if (level >= numLevels) {
            return 0;
        }
        return levels[level + 1] - levels[level];
    }

    static LevelStats getFinalSketchStatsAtNumLevels(int k, int m, int numLevels, boolean printSketchStructure) {
        int cumItems = 0;
        long cumN = 0L;
        if (printSketchStructure) {
            KllHelper.println("SKETCH STRUCTURE:");
            KllHelper.println("Given K        : " + k);
            KllHelper.println("Given M        : " + m);
            KllHelper.println("Given NumLevels: " + numLevels);
            KllHelper.printf("%6s %8s %12s %18s %18s\n", "Level", "Items", "CumItems", "N at Level", "CumN");
        }
        for (int level = 0; level < numLevels; ++level) {
            LevelStats lvlStats = KllHelper.getLevelCapacityItems(k, m, numLevels, level);
            cumItems += lvlStats.numItems;
            cumN += lvlStats.n;
            if (!printSketchStructure) continue;
            KllHelper.printf("%6d %,8d %,12d %,18d %,18d\n", level, lvlStats.numItems, cumItems, lvlStats.n, cumN);
        }
        return new LevelStats(cumN, numLevels, cumItems);
    }

    static GrowthStats getGrowthSchemeForGivenN(int k, int m, long n, KllSketch.SketchType sketchType, boolean printGrowthScheme) {
        LevelStats lvlStats;
        GrowthStats gStats = new GrowthStats();
        gStats.numLevels = 0;
        gStats.k = k;
        gStats.m = m;
        gStats.givenN = n;
        gStats.sketchType = sketchType;
        if (printGrowthScheme) {
            KllHelper.println("GROWTH SCHEME:");
            KllHelper.println("Given SketchType: " + gStats.sketchType.toString());
            KllHelper.println("Given K         : " + gStats.k);
            KllHelper.println("Given M         : " + gStats.m);
            KllHelper.println("Given N         : " + gStats.givenN);
            KllHelper.printf("%10s %10s %20s %13s %15s\n", "NumLevels", "MaxItems", "MaxN", "CompactBytes", "UpdatableBytes");
        }
        int typeBytes = sketchType == KllSketch.SketchType.DOUBLES_SKETCH ? 8 : 4;
        do {
            ++gStats.numLevels;
            lvlStats = KllHelper.getFinalSketchStatsAtNumLevels(gStats.k, gStats.m, gStats.numLevels, false);
            gStats.maxItems = lvlStats.numItems;
            gStats.maxN = lvlStats.n;
            gStats.compactBytes = gStats.maxItems * typeBytes + gStats.numLevels * 4 + 2 * typeBytes + 20;
            gStats.updatableBytes = gStats.compactBytes + 4;
            if (!printGrowthScheme) continue;
            KllHelper.printf("%10d %,10d %,20d %,13d %,15d\n", gStats.numLevels, gStats.maxItems, gStats.maxN, gStats.compactBytes, gStats.updatableBytes);
        } while (lvlStats.n < n);
        return gStats;
    }

    static int getKFromEpsilon(double epsilon, boolean pmf) {
        double eps = Math.max(epsilon, 4.7634E-5);
        double kdbl = pmf ? Math.exp(Math.log(2.446 / eps) / 0.9433) : Math.exp(Math.log(2.296 / eps) / 0.9723);
        double krnd = Math.round(kdbl);
        double del = Math.abs(krnd - kdbl);
        int k = (int)(del < 1.0E-6 ? krnd : Math.ceil(kdbl));
        return Math.max(2, Math.min(65535, k));
    }

    static LevelStats getLevelCapacityItems(int k, int m, int numLevels, int level) {
        int items = KllHelper.levelCapacity(k, numLevels, level, m);
        long n = (long)items << level;
        return new LevelStats(n, numLevels, items);
    }

    static double getNormalizedRankError(int k, boolean pmf) {
        return pmf ? 2.446 / Math.pow(k, 0.9433) : 2.296 / Math.pow(k, 0.9723);
    }

    static int getNumRetainedAboveLevelZero(int numLevels, int[] levels) {
        return levels[numLevels] - levels[1];
    }

    static int levelCapacity(int k, int numLevels, int level, int m) {
        assert (k <= 0x20000000);
        assert (numLevels >= 1 && numLevels <= 61);
        assert (level >= 0 && level < numLevels);
        int depth = numLevels - level - 1;
        return (int)Math.max((long)m, KllHelper.intCapAux(k, depth));
    }

    static WritableMemory memorySpaceMgmt(KllSketch sketch, int newLevelsArrLen, int newItemsArrLen) {
        WritableMemory newWmem;
        WritableMemory oldWmem;
        KllSketch.SketchType sketchType = sketch.sketchType;
        int typeBytes = sketchType == KllSketch.SketchType.DOUBLES_SKETCH ? 8 : 4;
        int requiredSketchBytes = 20 + newLevelsArrLen * 4 + 2 * typeBytes + newItemsArrLen * typeBytes;
        if ((long)requiredSketchBytes > (oldWmem = sketch.wmem).getCapacity()) {
            newWmem = sketch.memReqSvr.request(oldWmem, (long)requiredSketchBytes);
            oldWmem.copyTo(0L, newWmem, 0L, 20L);
        } else {
            newWmem = oldWmem;
        }
        assert ((long)requiredSketchBytes <= newWmem.getCapacity());
        return newWmem;
    }

    static String outputData(boolean doubleType, int numLevels, int[] levelsArr, float[] floatItemsArr, double[] doubleItemsArr) {
        int level;
        StringBuilder sb = new StringBuilder();
        sb.append("### KLL items data {index, item}:").append(Util.LS);
        if (levelsArr[0] > 0) {
            int i;
            sb.append(" Garbage:" + Util.LS);
            if (doubleType) {
                for (i = 0; i < levelsArr[0]; ++i) {
                    sb.append("   ").append(i + ", ").append(doubleItemsArr[i]).append(Util.LS);
                }
            } else {
                for (i = 0; i < levelsArr[0]; ++i) {
                    sb.append("   ").append(i + ", ").append(floatItemsArr[i]).append(Util.LS);
                }
            }
        }
        if (doubleType) {
            for (level = 0; level < numLevels; ++level) {
                int fromIndex = levelsArr[level];
                int toIndex = levelsArr[level + 1];
                if (fromIndex < toIndex) {
                    sb.append(" level[").append(level).append("]: offset: " + levelsArr[level] + " wt: " + (1 << level));
                    sb.append(Util.LS);
                }
                for (int i = fromIndex; i < toIndex; ++i) {
                    sb.append("   ").append(i + ", ").append(doubleItemsArr[i]).append(Util.LS);
                }
            }
        } else {
            while (level < numLevels) {
                int fromIndex = levelsArr[level];
                int toIndex = levelsArr[level + 1];
                if (fromIndex <= toIndex) {
                    sb.append(" level[").append(level).append("]: offset: " + levelsArr[level] + " wt: " + (1 << level));
                    sb.append(Util.LS);
                }
                for (int i = fromIndex; i < toIndex; ++i) {
                    sb.append("   ").append(i + ", ").append(floatItemsArr[i]).append(Util.LS);
                }
                ++level;
            }
        }
        sb.append(" level[" + level + "]: offset: " + levelsArr[level] + " (Exclusive)");
        sb.append(Util.LS);
        sb.append("### End items data").append(Util.LS);
        return sb.toString();
    }

    static String outputLevels(int k, int m, int numLevels, int[] levelsArr) {
        int level;
        StringBuilder sb = new StringBuilder();
        sb.append("### KLL levels array:").append(Util.LS).append(" level, offset: nominal capacity, actual size").append(Util.LS);
        for (level = 0; level < numLevels; ++level) {
            sb.append("   ").append(level).append(", ").append(levelsArr[level]).append(": ").append(KllHelper.levelCapacity(k, numLevels, level, m)).append(", ").append(KllHelper.currentLevelSize(level, numLevels, levelsArr)).append(Util.LS);
        }
        sb.append("   ").append(level).append(", ").append(levelsArr[level]).append(": (Exclusive)").append(Util.LS);
        sb.append("### End levels array").append(Util.LS);
        return sb.toString();
    }

    static long sumTheSampleWeights(int num_levels, int[] levels) {
        long total = 0L;
        long weight = 1L;
        for (int i = 0; i < num_levels; ++i) {
            total += weight * (long)(levels[i + 1] - levels[i]);
            weight *= 2L;
        }
        return total;
    }

    static byte[] toCompactByteArrayImpl(KllSketch sketch) {
        if (sketch.isEmpty()) {
            return KllHelper.fastEmptyCompactByteArray(sketch);
        }
        if (sketch.isSingleItem()) {
            return KllHelper.fastSingleItemCompactByteArray(sketch);
        }
        byte[] byteArr = new byte[sketch.getCurrentCompactSerializedSizeBytes()];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllHelper.loadFirst8Bytes(sketch, wmem, false);
        if (sketch.getN() == 0L) {
            return byteArr;
        }
        boolean doubleType = sketch.sketchType == KllSketch.SketchType.DOUBLES_SKETCH;
        int offset = 8;
        int[] myLevelsArr = sketch.getLevelsArray();
        if (sketch.getN() == 1L) {
            if (doubleType) {
                wmem.putDouble((long)offset, sketch.getDoubleItemsArray()[myLevelsArr[0]]);
            } else {
                wmem.putFloat((long)offset, sketch.getFloatItemsArray()[myLevelsArr[0]]);
            }
        } else {
            KllPreambleUtil.setMemoryN(wmem, sketch.getN());
            KllPreambleUtil.setMemoryMinK(wmem, sketch.getMinK());
            KllPreambleUtil.setMemoryNumLevels(wmem, sketch.getNumLevels());
            offset = 20;
            int len = myLevelsArr.length - 1;
            wmem.putIntArray((long)offset, myLevelsArr, 0, len);
            offset += len * 4;
            if (doubleType) {
                wmem.putDouble((long)offset, sketch.getMinDoubleItem());
                wmem.putDouble((long)(offset += 8), sketch.getMaxDoubleItem());
                wmem.putDoubleArray((long)(offset += 8), sketch.getDoubleItemsArray(), myLevelsArr[0], sketch.getNumRetained());
            } else {
                wmem.putFloat((long)offset, sketch.getMinFloatItem());
                wmem.putFloat((long)(offset += 4), sketch.getMaxFloatItem());
                wmem.putFloatArray((long)(offset += 4), sketch.getFloatItemsArray(), myLevelsArr[0], sketch.getNumRetained());
            }
        }
        return byteArr;
    }

    static byte[] fastEmptyCompactByteArray(KllSketch sketch) {
        int doubleFlagBit = sketch.sketchType == KllSketch.SketchType.DOUBLES_SKETCH ? 8 : 0;
        byte[] byteArr = new byte[8];
        byteArr[0] = 2;
        byteArr[1] = 1;
        byteArr[2] = 15;
        byteArr[3] = (byte)(1 | doubleFlagBit);
        ByteArrayUtil.putShortLE(byteArr, 4, (short)sketch.getK());
        byteArr[6] = (byte)sketch.getM();
        return byteArr;
    }

    static byte[] fastSingleItemCompactByteArray(KllSketch sketch) {
        boolean doubleSketch = sketch.sketchType == KllSketch.SketchType.DOUBLES_SKETCH;
        int doubleFlagBit = doubleSketch ? 8 : 0;
        byte[] byteArr = new byte[8 + (doubleSketch ? 8 : 4)];
        byteArr[0] = 2;
        byteArr[1] = 2;
        byteArr[2] = 15;
        byteArr[3] = (byte)(4 | doubleFlagBit);
        ByteArrayUtil.putShortLE(byteArr, 4, (short)sketch.getK());
        byteArr[6] = (byte)sketch.getM();
        if (doubleSketch) {
            ByteArrayUtil.putDoubleLE(byteArr, 8, sketch.getDoubleSingleItem());
        } else {
            ByteArrayUtil.putFloatLE(byteArr, 8, sketch.getFloatSingleItem());
        }
        return byteArr;
    }

    static String toStringImpl(KllSketch sketch, boolean withLevels, boolean withData) {
        boolean doubleType = sketch.sketchType == KllSketch.SketchType.DOUBLES_SKETCH;
        int k = sketch.getK();
        int m = sketch.getM();
        int numLevels = sketch.getNumLevels();
        int[] levelsArr = sketch.getLevelsArray();
        String epsPct = String.format("%.3f%%", sketch.getNormalizedRankError(false) * 100.0);
        String epsPMFPct = String.format("%.3f%%", sketch.getNormalizedRankError(true) * 100.0);
        StringBuilder sb = new StringBuilder();
        String skType = (sketch.updatableMemFormat ? "Direct" : "") + (doubleType ? "Doubles" : "Floats");
        sb.append(Util.LS).append("### Kll").append(skType).append("Sketch Summary:").append(Util.LS);
        sb.append("   K                      : ").append(k).append(Util.LS);
        sb.append("   Dynamic min K          : ").append(sketch.getMinK()).append(Util.LS);
        sb.append("   M                      : ").append(m).append(Util.LS);
        sb.append("   N                      : ").append(sketch.getN()).append(Util.LS);
        sb.append("   Epsilon                : ").append(epsPct).append(Util.LS);
        sb.append("   Epsison PMF            : ").append(epsPMFPct).append(Util.LS);
        sb.append("   Empty                  : ").append(sketch.isEmpty()).append(Util.LS);
        sb.append("   Estimation Mode        : ").append(sketch.isEstimationMode()).append(Util.LS);
        sb.append("   Levels                 : ").append(numLevels).append(Util.LS);
        sb.append("   Level 0 Sorted         : ").append(sketch.isLevelZeroSorted()).append(Util.LS);
        sb.append("   Capacity Items         : ").append(levelsArr[numLevels]).append(Util.LS);
        sb.append("   Retained Items         : ").append(sketch.getNumRetained()).append(Util.LS);
        if (sketch.updatableMemFormat) {
            sb.append("   Updatable Storage Bytes: ").append(sketch.getCurrentUpdatableSerializedSizeBytes()).append(Util.LS);
        } else {
            sb.append("   Compact Storage Bytes  : ").append(sketch.getCurrentCompactSerializedSizeBytes()).append(Util.LS);
        }
        if (doubleType) {
            sb.append("   Min Item               : ").append(sketch.getMinDoubleItem()).append(Util.LS);
            sb.append("   Max Item               : ").append(sketch.getMaxDoubleItem()).append(Util.LS);
        } else {
            sb.append("   Min Item               : ").append(sketch.getMinFloatItem()).append(Util.LS);
            sb.append("   Max Item               : ").append(sketch.getMaxFloatItem()).append(Util.LS);
        }
        sb.append("### End sketch summary").append(Util.LS);
        double[] myDoubleItemsArr = null;
        float[] myFloatItemsArr = null;
        if (doubleType) {
            myDoubleItemsArr = sketch.getDoubleItemsArray();
        } else {
            myFloatItemsArr = sketch.getFloatItemsArray();
        }
        if (withLevels) {
            sb.append(KllHelper.outputLevels(k, m, numLevels, levelsArr));
        }
        if (withData) {
            sb.append(KllHelper.outputData(doubleType, numLevels, levelsArr, myFloatItemsArr, myDoubleItemsArr));
        }
        return sb.toString();
    }

    private static byte[] toUpdatableByteArrayFromUpdatableMemory(KllSketch sketch) {
        boolean doubleType = sketch.sketchType == KllSketch.SketchType.DOUBLES_SKETCH;
        int curBytes = sketch.getCurrentUpdatableSerializedSizeBytes();
        long n = sketch.getN();
        byte flags = (byte)(0x10 | (n == 0L ? 1 : 0) | (n == 1L ? 4 : 0) | (doubleType ? 8 : 0));
        byte[] byteArr = new byte[curBytes];
        sketch.wmem.getByteArray(0L, byteArr, 0, curBytes);
        byteArr[3] = flags;
        return byteArr;
    }

    static byte[] toUpdatableByteArrayImpl(KllSketch sketch) {
        if (sketch.hasMemory() && sketch.updatableMemFormat) {
            return KllHelper.toUpdatableByteArrayFromUpdatableMemory(sketch);
        }
        byte[] byteArr = new byte[sketch.getCurrentUpdatableSerializedSizeBytes()];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllHelper.loadFirst8Bytes(sketch, wmem, true);
        KllPreambleUtil.setMemoryN(wmem, sketch.getN());
        KllPreambleUtil.setMemoryMinK(wmem, sketch.getMinK());
        KllPreambleUtil.setMemoryNumLevels(wmem, sketch.getNumLevels());
        boolean doubleType = sketch.sketchType == KllSketch.SketchType.DOUBLES_SKETCH;
        int offset = 20;
        int[] myLevelsArr = sketch.getLevelsArray();
        int len = myLevelsArr.length;
        wmem.putIntArray((long)offset, myLevelsArr, 0, len);
        offset += len * 4;
        if (doubleType) {
            wmem.putDouble((long)offset, sketch.getMinDoubleItem());
            wmem.putDouble((long)(offset += 8), sketch.getMaxDoubleItem());
            double[] doubleItemsArr = sketch.getDoubleItemsArray();
            wmem.putDoubleArray((long)(offset += 8), doubleItemsArr, 0, doubleItemsArr.length);
        } else {
            wmem.putFloat((long)offset, sketch.getMinFloatItem());
            wmem.putFloat((long)(offset += 4), sketch.getMaxFloatItem());
            float[] floatItemsArr = sketch.getFloatItemsArray();
            wmem.putFloatArray((long)(offset += 4), floatItemsArr, 0, floatItemsArr.length);
        }
        return byteArr;
    }

    static int ubOnNumLevels(long n) {
        return 1 + Long.numberOfTrailingZeros(Util.floorPowerOf2(n));
    }

    private static void addEmptyTopLevelToCompletelyFullSketch(KllSketch sketch) {
        int myNewNumLevels;
        int[] myNewLevelsArr;
        boolean growLevelsArr;
        int[] myCurLevelsArr = sketch.getLevelsArray();
        int myCurNumLevels = sketch.getNumLevels();
        int myCurTotalItemsCapacity = myCurLevelsArr[myCurNumLevels];
        double minDouble = Double.NaN;
        double maxDouble = Double.NaN;
        float minFloat = Float.NaN;
        float maxFloat = Float.NaN;
        double[] myCurDoubleItemsArr = null;
        float[] myCurFloatItemsArr = null;
        float[] myNewFloatItemsArr = null;
        double[] myNewDoubleItemsArr = null;
        if (sketch.sketchType == KllSketch.SketchType.DOUBLES_SKETCH) {
            minDouble = sketch.getMinDoubleItem();
            maxDouble = sketch.getMaxDoubleItem();
            myCurDoubleItemsArr = sketch.getDoubleItemsArray();
            assert (myCurDoubleItemsArr.length == myCurTotalItemsCapacity);
        } else {
            minFloat = sketch.getMinFloatItem();
            maxFloat = sketch.getMaxFloatItem();
            myCurFloatItemsArr = sketch.getFloatItemsArray();
            assert (myCurFloatItemsArr.length == myCurTotalItemsCapacity);
        }
        assert (myCurLevelsArr[0] == 0);
        int deltaItemsCap = KllHelper.levelCapacity(sketch.getK(), myCurNumLevels + 1, 0, sketch.getM());
        int myNewTotalItemsCapacity = myCurTotalItemsCapacity + deltaItemsCap;
        boolean bl = growLevelsArr = myCurLevelsArr.length < myCurNumLevels + 2;
        if (growLevelsArr) {
            myNewLevelsArr = Arrays.copyOf(myCurLevelsArr, myCurNumLevels + 2);
            assert (myNewLevelsArr.length == myCurLevelsArr.length + 1);
            myNewNumLevels = myCurNumLevels + 1;
            sketch.incNumLevels();
        } else {
            myNewLevelsArr = myCurLevelsArr;
            myNewNumLevels = myCurNumLevels;
        }
        int level = 0;
        while (level <= myNewNumLevels - 1) {
            int n = level++;
            myNewLevelsArr[n] = myNewLevelsArr[n] + deltaItemsCap;
        }
        myNewLevelsArr[myNewNumLevels] = myNewTotalItemsCapacity;
        if (sketch.sketchType == KllSketch.SketchType.DOUBLES_SKETCH) {
            myNewDoubleItemsArr = new double[myNewTotalItemsCapacity];
            System.arraycopy(myCurDoubleItemsArr, 0, myNewDoubleItemsArr, deltaItemsCap, myCurTotalItemsCapacity);
        } else {
            myNewFloatItemsArr = new float[myNewTotalItemsCapacity];
            System.arraycopy(myCurFloatItemsArr, 0, myNewFloatItemsArr, deltaItemsCap, myCurTotalItemsCapacity);
        }
        if (sketch.updatableMemFormat) {
            sketch.wmem = KllHelper.memorySpaceMgmt(sketch, myNewLevelsArr.length, myNewTotalItemsCapacity);
        }
        sketch.setNumLevels(myNewNumLevels);
        sketch.setLevelsArray(myNewLevelsArr);
        if (sketch.sketchType == KllSketch.SketchType.DOUBLES_SKETCH) {
            sketch.setMinDoubleItem(minDouble);
            sketch.setMaxDoubleItem(maxDouble);
            sketch.setDoubleItemsArray(myNewDoubleItemsArr);
        } else {
            sketch.setMinFloatItem(minFloat);
            sketch.setMaxFloatItem(maxFloat);
            sketch.setFloatItemsArray(myNewFloatItemsArr);
        }
    }

    private static int findLevelToCompact(int k, int m, int numLevels, int[] levels) {
        int level = 0;
        while (true) {
            assert (level < numLevels);
            int pop = levels[level + 1] - levels[level];
            int cap = KllHelper.levelCapacity(k, numLevels, level, m);
            if (pop >= cap) {
                return level;
            }
            ++level;
        }
    }

    private static long intCapAux(int k, int depth) {
        if (depth <= 30) {
            return KllHelper.intCapAuxAux(k, depth);
        }
        int half = depth / 2;
        int rest = depth - half;
        long tmp = KllHelper.intCapAuxAux(k, half);
        return KllHelper.intCapAuxAux(tmp, rest);
    }

    private static long intCapAuxAux(long k, int depth) {
        long twok = k << 1;
        long tmp = (twok << depth) / powersOfThree[depth];
        long result = tmp + 1L >>> 1;
        assert (result <= k);
        return result;
    }

    private static void loadFirst8Bytes(KllSketch sk, WritableMemory wmem, boolean updatableFormat) {
        boolean doubleType;
        boolean empty = sk.getN() == 0L;
        boolean lvlZeroSorted = sk.isLevelZeroSorted();
        boolean singleItem = sk.getN() == 1L;
        boolean bl = doubleType = sk.sketchType == KllSketch.SketchType.DOUBLES_SKETCH;
        int preInts = updatableFormat ? 5 : (empty || singleItem ? 2 : 5);
        KllPreambleUtil.setMemoryPreInts(wmem, preInts);
        int server = updatableFormat ? 3 : (singleItem ? 2 : 1);
        KllPreambleUtil.setMemorySerVer(wmem, server);
        KllPreambleUtil.setMemoryFamilyID(wmem, Family.KLL.getID());
        KllPreambleUtil.setMemoryEmptyFlag(wmem, empty);
        KllPreambleUtil.setMemoryLevelZeroSortedFlag(wmem, lvlZeroSorted);
        KllPreambleUtil.setMemorySingleItemFlag(wmem, singleItem);
        KllPreambleUtil.setMemoryDoubleSketchFlag(wmem, doubleType);
        KllPreambleUtil.setMemoryUpdatableFlag(wmem, updatableFormat);
        KllPreambleUtil.setMemoryK(wmem, sk.getK());
        KllPreambleUtil.setMemoryM(wmem, sk.getM());
    }

    private static void printf(String fmt, Object ... args) {
    }

    private static void println(Object o) {
    }

    static class LevelStats {
        long n;
        public int numLevels;
        int numItems;

        LevelStats(long n, int numLevels, int numItems) {
            this.n = n;
            this.numLevels = numLevels;
            this.numItems = numItems;
        }
    }

    static class GrowthStats {
        KllSketch.SketchType sketchType;
        int k;
        int m;
        long givenN;
        long maxN;
        int numLevels;
        int maxItems;
        int compactBytes;
        int updatableBytes;

        GrowthStats() {
        }
    }
}

