/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

class KllDirectDoublesSketch
extends KllDoublesSketch {
    KllDirectDoublesSketch(WritableMemory wmem, MemoryRequestServer memReqSvr, KllMemoryValidate memVal) {
        super(wmem, memReqSvr);
        this.levelsArr = memVal.levelsArr;
    }

    static KllDirectDoublesSketch newDirectInstance(int k, int m, WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        KllPreambleUtil.setMemoryPreInts(dstMem, 5);
        KllPreambleUtil.setMemorySerVer(dstMem, 3);
        KllPreambleUtil.setMemoryFamilyID(dstMem, Family.KLL.getID());
        KllPreambleUtil.setMemoryFlags(dstMem, 24);
        KllPreambleUtil.setMemoryK(dstMem, k);
        KllPreambleUtil.setMemoryM(dstMem, m);
        KllPreambleUtil.setMemoryN(dstMem, 0L);
        KllPreambleUtil.setMemoryMinK(dstMem, k);
        KllPreambleUtil.setMemoryNumLevels(dstMem, 1);
        int offset = 20;
        dstMem.putIntArray((long)offset, new int[]{k, k}, 0, 2);
        dstMem.putDoubleArray((long)(offset += 8), new double[]{Double.NaN, Double.NaN}, 0, 2);
        dstMem.putDoubleArray((long)(offset += 16), new double[k], 0, k);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)dstMem);
        return new KllDirectDoublesSketch(dstMem, memReqSvr, memVal);
    }

    @Override
    public int getK() {
        return KllPreambleUtil.getMemoryK((Memory)this.wmem);
    }

    @Override
    public long getN() {
        return KllPreambleUtil.getMemoryN((Memory)this.wmem);
    }

    @Override
    double[] getDoubleItemsArray() {
        int capacityItems = this.levelsArr[this.getNumLevels()];
        double[] quantilesArr = new double[capacityItems];
        int levelsBytes = this.levelsArr.length * 4;
        int offset = 20 + levelsBytes + 16;
        this.wmem.getDoubleArray((long)offset, quantilesArr, 0, capacityItems);
        return quantilesArr;
    }

    @Override
    double getDoubleSingleItem() {
        if (!this.isSingleItem()) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.NOT_SINGLE_ITEM);
            return Double.NaN;
        }
        int k = this.getK();
        int offset = 28 + (2 + k - 1) * 8;
        return this.wmem.getDouble((long)offset);
    }

    @Override
    float getFloatSingleItem() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return Float.NaN;
    }

    @Override
    int getM() {
        return KllPreambleUtil.getMemoryM((Memory)this.wmem);
    }

    @Override
    double getMaxDoubleItem() {
        int offset = 20 + this.getLevelsArray().length * 4 + 8;
        return this.wmem.getDouble((long)offset);
    }

    @Override
    double getMinDoubleItem() {
        int offset = 20 + this.getLevelsArray().length * 4;
        return this.wmem.getDouble((long)offset);
    }

    @Override
    int getMinK() {
        return KllPreambleUtil.getMemoryMinK((Memory)this.wmem);
    }

    @Override
    void incN() {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        long n = KllPreambleUtil.getMemoryN((Memory)this.wmem);
        KllPreambleUtil.setMemoryN(this.wmem, ++n);
    }

    @Override
    void incNumLevels() {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        int numLevels = KllPreambleUtil.getMemoryNumLevels((Memory)this.wmem);
        KllPreambleUtil.setMemoryNumLevels(this.wmem, ++numLevels);
    }

    @Override
    boolean isLevelZeroSorted() {
        return KllPreambleUtil.getMemoryLevelZeroSortedFlag((Memory)this.wmem);
    }

    @Override
    void setDoubleItemsArray(double[] doubleItems) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        int offset = 20 + this.getLevelsArray().length * 4 + 16;
        this.wmem.putDoubleArray((long)offset, doubleItems, 0, doubleItems.length);
    }

    @Override
    void setDoubleItemsArrayAt(int index, double item) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        int offset = 20 + this.getLevelsArray().length * 4 + 16 + index * 8;
        this.wmem.putDouble((long)offset, item);
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllPreambleUtil.setMemoryLevelZeroSortedFlag(this.wmem, sorted);
    }

    @Override
    void setMaxDoubleItem(double item) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        int offset = 20 + this.getLevelsArray().length * 4 + 8;
        this.wmem.putDouble((long)offset, item);
    }

    @Override
    void setMinDoubleItem(double item) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        int offset = 20 + this.getLevelsArray().length * 4;
        this.wmem.putDouble((long)offset, item);
    }

    @Override
    void setMinK(int minK) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllPreambleUtil.setMemoryMinK(this.wmem, minK);
    }

    @Override
    void setN(long n) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllPreambleUtil.setMemoryN(this.wmem, n);
    }

    @Override
    void setNumLevels(int numLevels) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllPreambleUtil.setMemoryNumLevels(this.wmem, numLevels);
    }
}

