/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;

public final class SerializerDeserializer {
    static final int TYPE_BYTE_OFFSET = 3;

    public static void validateFamily(byte familyId, byte preambleLongs) {
        Family family = Family.idToFamily(familyId);
        if (family.equals((Object)Family.TUPLE)) {
            if (preambleLongs != Family.TUPLE.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for family TUPLE: " + preambleLongs);
            }
        } else {
            throw new SketchesArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
    }

    public static void validateType(byte sketchTypeByte, SketchType expectedType) {
        SketchType sketchType = SerializerDeserializer.getSketchType(sketchTypeByte);
        if (!sketchType.equals((Object)expectedType)) {
            throw new SketchesArgumentException("Sketch Type mismatch. Expected " + expectedType.name() + ", got " + sketchType.name());
        }
    }

    public static SketchType getSketchType(Memory mem) {
        byte sketchTypeByte = mem.getByte(3L);
        return SerializerDeserializer.getSketchType(sketchTypeByte);
    }

    private static SketchType getSketchType(byte sketchTypeByte) {
        if (sketchTypeByte < 0 || sketchTypeByte >= SketchType.values().length) {
            throw new SketchesArgumentException("Invalid Sketch Type " + sketchTypeByte);
        }
        return SketchType.values()[sketchTypeByte];
    }

    public static enum SketchType {
        QuickSelectSketch,
        CompactSketch,
        ArrayOfDoublesQuickSelectSketch,
        ArrayOfDoublesCompactSketch,
        ArrayOfDoublesUnion;

    }
}

