/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import org.apache.datasketches.QuickSelect;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.QuickSelectSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummarySetOperations;

public class Union<S extends Summary> {
    private final SummarySetOperations<S> summarySetOps_;
    private QuickSelectSketch<S> sketch_;
    private long theta_;
    private boolean isEmpty_;

    public Union(SummarySetOperations<S> summarySetOps) {
        this(4096, summarySetOps);
    }

    public Union(int nomEntries, SummarySetOperations<S> summarySetOps) {
        this.summarySetOps_ = summarySetOps;
        this.sketch_ = new QuickSelectSketch(nomEntries, null);
        this.theta_ = this.sketch_.getThetaLong();
        this.isEmpty_ = true;
    }

    public void update(Sketch<S> sketchIn) {
        if (sketchIn == null || sketchIn.isEmpty()) {
            return;
        }
        this.isEmpty_ = false;
        if (sketchIn.theta_ < this.theta_) {
            this.theta_ = sketchIn.theta_;
        }
        SketchIterator<S> it = sketchIn.iterator();
        while (it.next()) {
            this.sketch_.merge(it.getKey(), it.getSummary(), this.summarySetOps_);
        }
        if (this.sketch_.theta_ < this.theta_) {
            this.theta_ = this.sketch_.theta_;
        }
    }

    public CompactSketch<S> getResult() {
        long[] keys;
        if (this.isEmpty_) {
            return this.sketch_.compact();
        }
        if (this.theta_ >= this.sketch_.theta_ && this.sketch_.getRetainedEntries() <= this.sketch_.getNominalEntries()) {
            return this.sketch_.compact();
        }
        long theta = Math.min(this.theta_, this.sketch_.theta_);
        int num = 0;
        SketchIterator it = this.sketch_.iterator();
        while (it.next()) {
            if (it.getKey() >= theta) continue;
            ++num;
        }
        if (num == 0) {
            return new CompactSketch(null, null, theta, this.isEmpty_);
        }
        if (num > this.sketch_.getNominalEntries()) {
            keys = new long[num];
            SketchIterator it2 = this.sketch_.iterator();
            int i = 0;
            while (it2.next()) {
                if (it2.getKey() >= theta) continue;
                keys[i++] = it2.getKey();
            }
            theta = QuickSelect.select(keys, 0, num - 1, this.sketch_.getNominalEntries());
            num = this.sketch_.getNominalEntries();
        }
        keys = new long[num];
        Summary[] summaries = (Summary[])Array.newInstance(this.sketch_.summaries_.getClass().getComponentType(), num);
        SketchIterator it3 = this.sketch_.iterator();
        int i = 0;
        while (it3.next()) {
            if (it3.getKey() >= theta) continue;
            keys[i] = it3.getKey();
            summaries[i] = it3.getSummary().copy();
            ++i;
        }
        return new CompactSketch(keys, summaries, theta, this.isEmpty_);
    }

    public void reset() {
        this.sketch_.reset();
        this.theta_ = this.sketch_.getThetaLong();
        this.isEmpty_ = true;
    }
}

