/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.hll.CouponMapping;
import org.apache.datasketches.hll.CubicInterpolation;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.ToByteArrayImpl;

abstract class AbstractCoupons
extends HllSketchImpl {
    AbstractCoupons(int lgConfigK, TgtHllType tgtHllType, CurMode curMode) {
        super(lgConfigK, tgtHllType, curMode);
    }

    @Override
    double getCompositeEstimate() {
        return this.getEstimate();
    }

    abstract int getCouponCount();

    abstract int[] getCouponIntArr();

    @Override
    double getEstimate() {
        int couponCount = this.getCouponCount();
        double est = CubicInterpolation.usingXAndYTables(CouponMapping.xArr, CouponMapping.yArr, couponCount);
        return Math.max(est, (double)couponCount);
    }

    @Override
    double getHipEstimate() {
        return this.getEstimate();
    }

    abstract int getLgCouponArrInts();

    @Override
    double getLowerBound(int numStdDev) {
        HllUtil.checkNumStdDev(numStdDev);
        int couponCount = this.getCouponCount();
        double est = CubicInterpolation.usingXAndYTables(CouponMapping.xArr, CouponMapping.yArr, couponCount);
        double tmp = est / (1.0 + (double)numStdDev * 4.99267578125E-5);
        return Math.max(tmp, (double)couponCount);
    }

    @Override
    double getUpperBound(int numStdDev) {
        HllUtil.checkNumStdDev(numStdDev);
        int couponCount = this.getCouponCount();
        double est = CubicInterpolation.usingXAndYTables(CouponMapping.xArr, CouponMapping.yArr, couponCount);
        double tmp = est / (1.0 - (double)numStdDev * 4.99267578125E-5);
        return Math.max(tmp, (double)couponCount);
    }

    @Override
    int getUpdatableSerializationBytes() {
        return this.getMemDataStart() + (4 << this.getLgCouponArrInts());
    }

    @Override
    boolean isEmpty() {
        return this.getCouponCount() == 0;
    }

    @Override
    boolean isRebuildCurMinNumKxQFlag() {
        return false;
    }

    @Override
    void putEmptyFlag(boolean empty) {
    }

    @Override
    void putRebuildCurMinNumKxQFlag(boolean rebuild) {
    }

    @Override
    byte[] toCompactByteArray() {
        return ToByteArrayImpl.toCouponByteArray(this, true);
    }

    @Override
    byte[] toUpdatableByteArray() {
        return ToByteArrayImpl.toCouponByteArray(this, false);
    }

    static final int find(int[] array, int lgArrInts, int coupon) {
        int stride;
        int probe;
        int arrMask = array.length - 1;
        int loopIndex = probe = coupon & arrMask;
        do {
            int couponAtIdx;
            if ((couponAtIdx = array[probe]) == 0) {
                return ~probe;
            }
            if (coupon != couponAtIdx) continue;
            return probe;
        } while ((probe = probe + (stride = (coupon & 0x3FFFFFF) >>> lgArrInts | 1) & arrMask) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }
}

