/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.hll.AbstractCoupons;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.BaseHllSketch;
import org.apache.datasketches.hll.CouponHashSet;
import org.apache.datasketches.hll.CouponList;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.DirectCouponHashSet;
import org.apache.datasketches.hll.DirectCouponList;
import org.apache.datasketches.hll.DirectHll4Array;
import org.apache.datasketches.hll.DirectHll6Array;
import org.apache.datasketches.hll.DirectHll8Array;
import org.apache.datasketches.hll.Hll4Array;
import org.apache.datasketches.hll.Hll6Array;
import org.apache.datasketches.hll.Hll8Array;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

public class HllSketch
extends BaseHllSketch {
    public static final int DEFAULT_LG_K = 12;
    public static final TgtHllType DEFAULT_HLL_TYPE = TgtHllType.HLL_4;
    private static final String LS = System.getProperty("line.separator");
    HllSketchImpl hllSketchImpl = null;

    public HllSketch() {
        this(12, DEFAULT_HLL_TYPE);
    }

    public HllSketch(int lgConfigK) {
        this(lgConfigK, DEFAULT_HLL_TYPE);
    }

    public HllSketch(int lgConfigK, TgtHllType tgtHllType) {
        this.hllSketchImpl = new CouponList(HllUtil.checkLgK(lgConfigK), tgtHllType, CurMode.LIST);
    }

    public HllSketch(int lgConfigK, TgtHllType tgtHllType, WritableMemory dstMem) {
        long minBytes = HllSketch.getMaxUpdatableSerializationBytes(lgConfigK, tgtHllType);
        long capBytes = dstMem.getCapacity();
        HllUtil.checkMemSize(minBytes, capBytes);
        dstMem.clear(0L, minBytes);
        this.hllSketchImpl = DirectCouponList.newInstance(lgConfigK, tgtHllType, dstMem);
    }

    HllSketch(HllSketch that) {
        this.hllSketchImpl = that.hllSketchImpl.copy();
    }

    HllSketch(HllSketchImpl that) {
        this.hllSketchImpl = that;
    }

    public static final HllSketch heapify(byte[] byteArray) {
        return HllSketch.heapify(Memory.wrap((byte[])byteArray));
    }

    public static final HllSketch heapify(Memory srcMem) {
        TgtHllType tgtHllType;
        CurMode curMode = HllUtil.checkPreamble(srcMem);
        HllSketch heapSketch = curMode == CurMode.HLL ? ((tgtHllType = PreambleUtil.extractTgtHllType(srcMem)) == TgtHllType.HLL_4 ? new HllSketch(Hll4Array.heapify(srcMem)) : (tgtHllType == TgtHllType.HLL_6 ? new HllSketch(Hll6Array.heapify(srcMem)) : new HllSketch(Hll8Array.heapify(srcMem)))) : (curMode == CurMode.LIST ? new HllSketch(CouponList.heapifyList(srcMem)) : new HllSketch(CouponHashSet.heapifySet(srcMem)));
        return heapSketch;
    }

    public static final HllSketch writableWrap(WritableMemory wmem) {
        boolean compact = PreambleUtil.extractCompactFlag((Memory)wmem);
        if (compact) {
            throw new SketchesArgumentException("Cannot perform a writableWrap of a writable sketch image that is in compact form.");
        }
        int lgConfigK = PreambleUtil.extractLgK((Memory)wmem);
        TgtHllType tgtHllType = PreambleUtil.extractTgtHllType((Memory)wmem);
        long minBytes = HllSketch.getMaxUpdatableSerializationBytes(lgConfigK, tgtHllType);
        long capBytes = wmem.getCapacity();
        HllUtil.checkMemSize(minBytes, capBytes);
        CurMode curMode = HllUtil.checkPreamble((Memory)wmem);
        HllSketch directSketch = curMode == CurMode.HLL ? (tgtHllType == TgtHllType.HLL_4 ? new HllSketch(new DirectHll4Array(lgConfigK, wmem)) : (tgtHllType == TgtHllType.HLL_6 ? new HllSketch(new DirectHll6Array(lgConfigK, wmem)) : new HllSketch(new DirectHll8Array(lgConfigK, wmem)))) : (curMode == CurMode.LIST ? new HllSketch(new DirectCouponList(lgConfigK, tgtHllType, curMode, wmem)) : new HllSketch(new DirectCouponHashSet(lgConfigK, tgtHllType, wmem)));
        return directSketch;
    }

    public static final HllSketch wrap(Memory srcMem) {
        int lgConfigK = PreambleUtil.extractLgK(srcMem);
        TgtHllType tgtHllType = PreambleUtil.extractTgtHllType(srcMem);
        CurMode curMode = HllUtil.checkPreamble(srcMem);
        HllSketch directSketch = curMode == CurMode.HLL ? (tgtHllType == TgtHllType.HLL_4 ? new HllSketch(new DirectHll4Array(lgConfigK, srcMem)) : (tgtHllType == TgtHllType.HLL_6 ? new HllSketch(new DirectHll6Array(lgConfigK, srcMem)) : new HllSketch(new DirectHll8Array(lgConfigK, srcMem)))) : (curMode == CurMode.LIST ? new HllSketch(new DirectCouponList(lgConfigK, tgtHllType, curMode, srcMem)) : new HllSketch(new DirectCouponHashSet(lgConfigK, tgtHllType, srcMem)));
        return directSketch;
    }

    public HllSketch copy() {
        return new HllSketch(this);
    }

    public HllSketch copyAs(TgtHllType tgtHllType) {
        return new HllSketch(this.hllSketchImpl.copyAs(tgtHllType));
    }

    @Override
    public double getCompositeEstimate() {
        return this.hllSketchImpl.getCompositeEstimate();
    }

    @Override
    public double getEstimate() {
        return this.hllSketchImpl.getEstimate();
    }

    @Override
    public int getLgConfigK() {
        return this.hllSketchImpl.getLgConfigK();
    }

    @Override
    public int getCompactSerializationBytes() {
        return this.hllSketchImpl.getCompactSerializationBytes();
    }

    @Override
    public double getLowerBound(int numStdDev) {
        return this.hllSketchImpl.getLowerBound(numStdDev);
    }

    public static final int getMaxUpdatableSerializationBytes(int lgConfigK, TgtHllType tgtHllType) {
        int arrBytes;
        if (tgtHllType == TgtHllType.HLL_4) {
            int auxBytes = 4 << HllUtil.LG_AUX_ARR_INTS[lgConfigK];
            arrBytes = AbstractHllArray.hll4ArrBytes(lgConfigK) + auxBytes;
        } else {
            arrBytes = tgtHllType == TgtHllType.HLL_6 ? AbstractHllArray.hll6ArrBytes(lgConfigK) : AbstractHllArray.hll8ArrBytes(lgConfigK);
        }
        return PreambleUtil.HLL_BYTE_ARR_START + arrBytes;
    }

    @Override
    public TgtHllType getTgtHllType() {
        return this.hllSketchImpl.getTgtHllType();
    }

    @Override
    public int getUpdatableSerializationBytes() {
        return this.hllSketchImpl.getUpdatableSerializationBytes();
    }

    @Override
    public double getUpperBound(int numStdDev) {
        return this.hllSketchImpl.getUpperBound(numStdDev);
    }

    @Override
    public boolean isCompact() {
        return this.hllSketchImpl.isCompact();
    }

    @Override
    public boolean isEmpty() {
        return this.hllSketchImpl.isEmpty();
    }

    @Override
    public boolean isMemory() {
        return this.hllSketchImpl.isMemory();
    }

    @Override
    public boolean isOffHeap() {
        return this.hllSketchImpl.isOffHeap();
    }

    @Override
    boolean isOutOfOrderFlag() {
        return this.hllSketchImpl.isOutOfOrderFlag();
    }

    @Override
    public boolean isSameResource(Memory mem) {
        return this.hllSketchImpl.isSameResource(mem);
    }

    @Override
    public void reset() {
        this.hllSketchImpl = this.hllSketchImpl.reset();
    }

    @Override
    public byte[] toCompactByteArray() {
        return this.hllSketchImpl.toCompactByteArray();
    }

    @Override
    public byte[] toUpdatableByteArray() {
        return this.hllSketchImpl.toUpdatableByteArray();
    }

    @Override
    public String toString(boolean summary, boolean detail, boolean auxDetail, boolean all) {
        StringBuilder sb;
        block12: {
            PairIterator auxItr;
            AbstractHllArray absHll;
            sb = new StringBuilder();
            if (summary) {
                sb.append("### HLL SKETCH SUMMARY: ").append(LS);
                sb.append("  Log Config K   : ").append(this.getLgConfigK()).append(LS);
                sb.append("  Hll Target     : ").append((Object)this.getTgtHllType()).append(LS);
                sb.append("  Current Mode   : ").append((Object)this.getCurMode()).append(LS);
                sb.append("  LB             : ").append(this.getLowerBound(1)).append(LS);
                sb.append("  Estimate       : ").append(this.getEstimate()).append(LS);
                sb.append("  UB             : ").append(this.getUpperBound(1)).append(LS);
                sb.append("  OutOfOrder Flag: ").append(this.isOutOfOrderFlag()).append(LS);
                if (this.getCurMode() == CurMode.HLL) {
                    absHll = (AbstractHllArray)this.hllSketchImpl;
                    sb.append("  CurMin         : ").append(absHll.getCurMin()).append(LS);
                    sb.append("  NumAtCurMin    : ").append(absHll.getNumAtCurMin()).append(LS);
                    sb.append("  HipAccum       : ").append(absHll.getHipAccum()).append(LS);
                    sb.append("  KxQ0           : ").append(absHll.getKxQ0()).append(LS);
                    sb.append("  KxQ1           : ").append(absHll.getKxQ1()).append(LS);
                } else {
                    sb.append("  Coupon Count   : ").append(((AbstractCoupons)this.hllSketchImpl).getCouponCount()).append(LS);
                }
            }
            if (detail) {
                sb.append("### HLL SKETCH DATA DETAIL: ").append(LS);
                PairIterator pitr = this.iterator();
                sb.append(pitr.getHeader()).append(LS);
                if (all) {
                    while (pitr.nextAll()) {
                        sb.append(pitr.getString()).append(LS);
                    }
                } else {
                    while (pitr.nextValid()) {
                        sb.append(pitr.getString()).append(LS);
                    }
                }
            }
            if (!auxDetail || this.getCurMode() != CurMode.HLL || this.getTgtHllType() != TgtHllType.HLL_4 || (auxItr = (absHll = (AbstractHllArray)this.hllSketchImpl).getAuxIterator()) == null) break block12;
            sb.append("### HLL SKETCH AUX DETAIL: ").append(LS);
            sb.append(auxItr.getHeader()).append(LS);
            if (all) {
                while (auxItr.nextAll()) {
                    sb.append(auxItr.getString()).append(LS);
                }
            } else {
                while (auxItr.nextValid()) {
                    sb.append(auxItr.getString()).append(LS);
                }
            }
        }
        return sb.toString();
    }

    public static String toString(byte[] byteArr) {
        return PreambleUtil.toString(byteArr);
    }

    public static String toString(Memory mem) {
        return PreambleUtil.toString(mem);
    }

    PairIterator iterator() {
        return this.hllSketchImpl.iterator();
    }

    @Override
    CurMode getCurMode() {
        return this.hllSketchImpl.getCurMode();
    }

    @Override
    void couponUpdate(int coupon) {
        if (coupon == 0) {
            return;
        }
        this.hllSketchImpl = this.hllSketchImpl.couponUpdate(coupon);
    }
}

