/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import org.apache.datasketches.hive.tuple.UnionSketchUDAF;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

@Description(name="UnionSketch", value="_FUNC_(sketch, nominal number of entries)", extended="Returns a Sketch<DoubleSummary> as a binary blob that can be operated on by other tuple sketch related functions. The nominal number of entries is optional, must be a power of 2, does not have to match the input sketches, and controls the relative error expected from the sketch. A number of 16384 can be expected to yield errors of roughly +-1.5% in the estimation of uniques. The default number is defined in the sketches-core library and at the time of this writing was 4096 (about 3% error).")
public class UnionDoubleSummarySketchUDAF
extends UnionSketchUDAF {
    @Override
    public GenericUDAFEvaluator createEvaluator() {
        return new UnionDoubleSummarySketchEvaluator();
    }

    public static class UnionDoubleSummarySketchEvaluator
    extends UnionSketchUDAF.UnionSketchEvaluator<DoubleSummary> {
        private static final SummaryDeserializer<DoubleSummary> SUMMARY_DESERIALIZER = new DoubleSummaryDeserializer();
        private static final SummarySetOperations<DoubleSummary> SUMMARY_SET_OPS = new DoubleSummarySetOperations(DoubleSummary.Mode.Sum);

        @Override
        protected SummaryDeserializer<DoubleSummary> getSummaryDeserializer() {
            return SUMMARY_DESERIALIZER;
        }

        @Override
        protected SummaryFactory<DoubleSummary> getSummaryFactory(Object[] data) {
            return null;
        }

        @Override
        protected SummarySetOperations<DoubleSummary> getSummarySetOperationsForIterate(Object[] data) {
            return SUMMARY_SET_OPS;
        }

        @Override
        protected SummarySetOperations<DoubleSummary> getSummarySetOperationsForMerge(Object data) {
            return SUMMARY_SET_OPS;
        }
    }
}

