/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="DoubleSummarySketchToPercentile", value="_FUNC_(sketch)", extended="Returns a percentile from a given Sketch<DoubleSummary>. The values from DoubleSummary objects in the sketch are extracted,  and a single value with a given normalized rank is returned. The rank is in percent. For example, 50th percentile is the median value of the distribution (the number separating the higher half of a probability distribution from the lower half)")
public class DoubleSummarySketchToPercentileUDF
extends UDF {
    private static final SummaryDeserializer<DoubleSummary> SUMMARY_DESERIALIZER = new DoubleSummaryDeserializer();
    private static final int QUANTILES_SKETCH_K = 1024;

    public Double evaluate(BytesWritable serializedSketch, double percentile) {
        if (serializedSketch == null) {
            return null;
        }
        if (percentile < 0.0 || percentile > 100.0) {
            throw new IllegalArgumentException("percentile must be between 0 and 100");
        }
        Sketch sketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), SUMMARY_DESERIALIZER);
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(1024).build();
        SketchIterator it = sketch.iterator();
        while (it.next()) {
            qs.update(((DoubleSummary)it.getSummary()).getValue());
        }
        return qs.getQuantile(percentile / 100.0);
    }
}

