/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import org.apache.datasketches.hive.tuple.ObjectInspectorValidator;
import org.apache.datasketches.hive.tuple.SketchEvaluator;
import org.apache.datasketches.hive.tuple.SketchState;
import org.apache.datasketches.hive.tuple.UnionState;
import org.apache.datasketches.tuple.UpdatableSummary;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

public abstract class DataToSketchUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] inspectors = info.getParameterObjectInspectors();
        if (inspectors.length < 2) {
            throw new UDFArgumentException("Expected at least 2 arguments");
        }
        ObjectInspectorValidator.validateCategoryPrimitive(inspectors[0], 0);
        if (inspectors.length > 2) {
            ObjectInspectorValidator.validateIntegralParameter(inspectors[2], 2);
        }
        if (inspectors.length > 3) {
            ObjectInspectorValidator.validateCategoryPrimitive(inspectors[3], 3);
            PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)inspectors[3];
            if (primitiveInspector.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.FLOAT && primitiveInspector.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DOUBLE) {
                throw new UDFArgumentTypeException(3, "float or double value expected as parameter 4 but " + primitiveInspector.getPrimitiveCategory().name() + " was received");
            }
        }
        this.checkExtraArguments(inspectors);
        return this.createEvaluator();
    }

    protected void checkExtraArguments(ObjectInspector[] inspectors) throws SemanticException {
        if (inspectors.length > 4) {
            throw new UDFArgumentException("Expected no more than 4 arguments");
        }
    }

    public abstract GenericUDAFEvaluator createEvaluator();

    public static abstract class DataToSketchEvaluator<U, S extends UpdatableSummary<U>>
    extends SketchEvaluator<S> {
        private static final float DEFAULT_SAMPLING_PROBABILITY = 1.0f;
        private PrimitiveObjectInspector keyInspector_;
        private PrimitiveObjectInspector valueInspector_;
        private PrimitiveObjectInspector samplingProbabilityInspector_;
        private GenericUDAFEvaluator.Mode mode_;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] inspectors) throws HiveException {
            super.init(mode, inspectors);
            this.mode_ = mode;
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.keyInspector_ = (PrimitiveObjectInspector)inspectors[0];
                this.valueInspector_ = (PrimitiveObjectInspector)inspectors[1];
                if (inspectors.length > 2) {
                    this.nominalNumEntriesInspector_ = (PrimitiveObjectInspector)inspectors[2];
                }
                if (inspectors.length > 3) {
                    this.samplingProbabilityInspector_ = (PrimitiveObjectInspector)inspectors[3];
                }
            } else {
                this.intermediateInspector_ = (StructObjectInspector)inspectors[0];
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "sketch"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY)));
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer buf, Object[] data) throws HiveException {
            if (data[0] == null) {
                return;
            }
            SketchState state = (SketchState)buf;
            if (!state.isInitialized()) {
                this.initializeState(state, data);
            }
            state.update(data[0], this.keyInspector_, this.extractValue(data[1], this.valueInspector_));
        }

        private void initializeState(SketchState<U, S> state, Object[] data) {
            int nominalNumEntries = 4096;
            if (this.nominalNumEntriesInspector_ != null) {
                nominalNumEntries = PrimitiveObjectInspectorUtils.getInt((Object)data[2], (PrimitiveObjectInspector)this.nominalNumEntriesInspector_);
            }
            float samplingProbability = 1.0f;
            if (this.samplingProbabilityInspector_ != null) {
                samplingProbability = PrimitiveObjectInspectorUtils.getFloat((Object)data[3], (PrimitiveObjectInspector)this.samplingProbabilityInspector_);
            }
            state.init(nominalNumEntries, samplingProbability, this.getSummaryFactory(data));
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            if (this.mode_ == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode_ == GenericUDAFEvaluator.Mode.COMPLETE) {
                return new SketchState();
            }
            return new UnionState();
        }

        public U extractValue(Object data, PrimitiveObjectInspector valueInspector) throws HiveException {
            Object value = valueInspector.getPrimitiveJavaObject(data);
            return (U)value;
        }
    }
}

