/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.quantiles.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetQuantiles", value="_FUNC_(sketch, fractions...) or _FUNC_(sketch, number)", extended="Returns quantile values from a given ItemsSketch<String> based on a given list of fractions or a number of evenly spaced fractions. The fractions represent normalized ranks, and must be from 0 to 1 inclusive. For example, a fraction of 0.5 corresponds to 50th percentile, which is the median value of the distribution (the number separating the higher half of the probability distribution from the lower half). The number of evenly spaced fractions must be a positive integer greater than 0. A value of 1 will return the min value (normalized rank of 0.0). A value of 2 will return the min and the max value (ranks 0.0 amd 1.0). A value of 3 will return the min, the median and the max value (ranks 0.0, 0.5, and 1.0), etc.")
public class GetQuantilesFromStringsSketchUDF
extends UDF {
    public List<String> evaluate(BytesWritable serializedSketch, Double ... fractions) {
        if (serializedSketch == null) {
            return null;
        }
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        return Arrays.asList(sketch.getQuantiles(Util.objectsToPrimitives(fractions)));
    }

    public List<String> evaluate(BytesWritable serializedSketch, int number) {
        if (serializedSketch == null) {
            return null;
        }
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        String[] quantiles = (String[])sketch.getQuantiles(number);
        if (quantiles == null) {
            return null;
        }
        return Arrays.asList(quantiles);
    }
}

