/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetQuantile", value="_FUNC_(sketch, fraction)", extended=" Returns a quantile value from a given DoublesSketch sketch. A single value for a given fraction is returned. The fraction represents a normalized rank, and must be from 0 to 1 inclusive. For example, a fraction of 0.5 corresponds to 50th percentile, which is the median value of the distribution (the number separating the higher half of the probability distribution from the lower half).")
public class GetQuantileFromDoublesSketchUDF
extends UDF {
    public Double evaluate(BytesWritable serializedSketch, double fraction) {
        if (serializedSketch == null) {
            return null;
        }
        DoublesSketch sketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        return sketch.getQuantile(fraction);
    }
}

