/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Comparator;
import java.util.List;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.quantiles.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetCDF", value="_FUNC_(sketch, split points...)", extended="Returns an approximation to the Cumulative Distribution Function (CDF) from a sketch given a set of split points (values). Split points are an array of M unique, monotonically increasing values that divide the domain into M+1 consecutive disjoint intervals. The function returns an array of M+1 double valuess, the first M of which are approximations to the ranks of the corresponding split points (fraction of input stream values that are less than a split point). The last value is always 1. CDF can also be viewed as a cumulative version of PMF.")
public class GetCdfFromStringsSketchUDF
extends UDF {
    public List<Double> evaluate(BytesWritable serializedSketch, String ... splitPoints) {
        if (serializedSketch == null) {
            return null;
        }
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        double[] cdf = sketch.getCDF((Object[])splitPoints);
        if (cdf == null) {
            return null;
        }
        return Util.primitivesToList(cdf);
    }
}

