/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Comparator;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.hive.quantiles.DataToItemsSketchUDAF;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="DataToSketch", value="_FUNC_(value, k) - Returns an ItemsSketch<String> in a serialized form as a binary blob. Values must be of string type. Parameter k controls the accuracy and the size of the sketch. If k is ommitted, the default is used.")
public class DataToStringsSketchUDAF
extends DataToItemsSketchUDAF<String> {
    @Override
    public GenericUDAFEvaluator createEvaluator() {
        return new DataToStringsSketchEvaluator();
    }

    static class DataToStringsSketchEvaluator
    extends DataToItemsSketchUDAF.DataToSketchEvaluator<String> {
        DataToStringsSketchEvaluator() {
            super(Comparator.naturalOrder(), new ArrayOfStringsSerDe());
        }

        @Override
        public String extractValue(Object data, ObjectInspector objectInspector) throws HiveException {
            Object value = this.inputObjectInspector.getPrimitiveJavaObject(data);
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof HiveChar) {
                return ((HiveChar)value).getValue();
            }
            if (value instanceof HiveVarchar) {
                return ((HiveVarchar)value).getValue();
            }
            throw new UDFArgumentTypeException(0, "unsupported type " + value.getClass().getName());
        }
    }
}

